/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities;

import com.imcode.entities.Application;
import com.imcode.entities.embed.ApplicationFormQuestion;
import com.imcode.entities.interfaces.JpaEntity;
import com.imcode.entities.superclasses.AbstractNamedEntity;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang3.builder.EqualsBuilder;

@Entity
@Table(name="dbo_application_form")
public class ApplicationForm
extends AbstractNamedEntity<Long> {
    @Column
    private Integer version;
    @ElementCollection(fetch=FetchType.EAGER)
    @OrderBy(value="sortOrder ASC")
    @CollectionTable(name="dbo_application_form_question", joinColumns={@JoinColumn(name="applicationFormId")}, uniqueConstraints={@UniqueConstraint(columnNames={"applicationFormId", "xsdElementName"})})
    private Set<ApplicationFormQuestion> questions;
    @OneToMany(fetch=FetchType.EAGER, mappedBy="applicationForm")
    private Set<Application> applications;

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public Set<ApplicationFormQuestion> getQuestions() {
        return this.questions;
    }

    public void setQuestions(Set<ApplicationFormQuestion> questions) {
        this.questions = questions;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(this.getName());
        sb.append('v');
        sb.append(this.getVersion());
        return sb.toString();
    }

    @Override
    public boolean deepEquals(JpaEntity entity) {
        if (this == entity) {
            return true;
        }
        if (entity == null || this.getClass() != entity.getClass()) {
            return false;
        }
        ApplicationForm that = (ApplicationForm)entity;
        if (Objects.equals(this.id, that.id) && Objects.equals(this.name, that.name) && Objects.equals(this.version, that.version)) {
            if (this.questions == that.questions) {
                return true;
            }
            if (this.questions != null && that.questions != null && this.questions.size() == that.questions.size()) {
                Set<ApplicationFormQuestion> thisQuestions = this.questions;
                HashSet<ApplicationFormQuestion> tempQuestions = new HashSet<ApplicationFormQuestion>(that.questions);
                for (ApplicationFormQuestion thisQuestion : thisQuestions) {
                    Iterator iterator = tempQuestions.iterator();
                    boolean hasEquals = false;
                    while (iterator.hasNext()) {
                        ApplicationFormQuestion thatQuestion = (ApplicationFormQuestion)iterator.next();
                        if (!EqualsBuilder.reflectionEquals((Object)thisQuestion, (Object)thatQuestion, (boolean)false)) continue;
                        iterator.remove();
                        hasEquals = true;
                        break;
                    }
                    if (hasEquals) continue;
                    return false;
                }
                return tempQuestions.isEmpty();
            }
        }
        return false;
    }

    public Set<Application> getApplications() {
        return this.applications;
    }

    public void setApplications(Set<Application> applications) {
        this.applications = applications;
    }
}

