/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.imcode.entities.ApplicationForm;
import com.imcode.entities.Person;
import com.imcode.entities.User;
import com.imcode.entities.embed.Decision;
import com.imcode.entities.interfaces.JpaEntity;
import com.imcode.entities.listners.AuditableModelListener;
import com.imcode.entities.listners.DatedEntityListner;
import com.imcode.entities.superclasses.AbstractJpaDatedEntity;
import java.io.Serializable;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity
@Table(name="dbo_application")
@EntityListeners(value={AuditableModelListener.class, DatedEntityListner.class})
public class Application
extends AbstractJpaDatedEntity<Long>
implements Serializable {
    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="applicationFormId")
    private ApplicationForm applicationForm;
    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="submittedUserId")
    private User submittedUser;
    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="regardingUserId")
    private User regardingUser;
    @Column
    private Long registrationNumber;
    @Embedded
    private Decision decision;
    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="handledUserId")
    private Person handledUser;

    public ApplicationForm getApplicationForm() {
        return this.applicationForm;
    }

    public void setApplicationForm(ApplicationForm applicationForm) {
        this.applicationForm = applicationForm;
    }

    public User getSubmittedUser() {
        return this.submittedUser;
    }

    public void setSubmittedUser(User submittedUser) {
        this.submittedUser = submittedUser;
    }

    public User getRegardingUser() {
        return this.regardingUser;
    }

    public void setRegardingUser(User regardingUser) {
        this.regardingUser = regardingUser;
    }

    public Long getRegistrationNumber() {
        return this.registrationNumber;
    }

    public void setRegistrationNumber(Long registrationNumber) {
        this.registrationNumber = registrationNumber;
    }

    public Decision getDecision() {
        return this.decision;
    }

    public void setDecision(Decision decision) {
        this.decision = decision;
    }

    public Person getHandledUser() {
        return this.handledUser;
    }

    public void setHandledUser(Person handledUser) {
        this.handledUser = handledUser;
    }

    @JsonIgnore
    @Transient
    public Decision.Status getStatus() {
        if (this.decision != null) {
            return this.decision.getStatus();
        }
        return null;
    }

    @JsonIgnore
    @Transient
    public void setStatus(Decision.Status status) {
        if (this.decision == null) {
            this.decision = new Decision();
        }
        this.decision.setStatus(status);
    }

    @Override
    public boolean deepEquals(JpaEntity entity) {
        if (this == entity) {
            return true;
        }
        if (entity == null || this.getClass() != entity.getClass()) {
            return false;
        }
        Application that = (Application)entity;
        return Objects.equals(this.id, that.id) && Objects.equals(this.decision, that.decision) && Objects.equals(this.regardingUser, that.regardingUser) && Objects.equals(this.registrationNumber, that.registrationNumber) && Objects.equals(this.handledUser, that.handledUser) && Objects.equals(this.submittedUser, that.submittedUser) && JpaEntity.deepEquals(this.applicationForm, that.applicationForm);
    }
}

