/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.imcode.entities.Person;
import com.imcode.entities.Pupil;
import com.imcode.entities.embed.Address;
import com.imcode.entities.embed.Email;
import com.imcode.entities.embed.Phone;
import com.imcode.entities.enums.AddressTypeEnum;
import com.imcode.entities.enums.CommunicationTypeEnum;
import com.imcode.entities.interfaces.JpaPersonalizedEntity;
import com.imcode.entities.superclasses.AbstractPerson;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.MapKeyEnumerated;
import javax.persistence.Table;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;

@Entity
@Table(name="dbo_contact_person")
public class ContactPerson
extends AbstractPerson
implements Serializable,
JpaPersonalizedEntity {
    public static final String TABLE_SUFFIX = "contact_person";
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH})
    @JoinColumn(name="personId")
    private Person person;
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="dbo_pupil_guardians_cross", joinColumns={@JoinColumn(name="guardianId")}, inverseJoinColumns={@JoinColumn(name="pupilId")})
    private Set<Pupil> pupils;
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @ElementCollection
    @CollectionTable(name="dbo_contact_person_address", joinColumns={@JoinColumn(name="ownerId")})
    @MapKeyEnumerated(value=EnumType.STRING)
    @MapKeyColumn(name="typeKey", length=50)
    private Map<AddressTypeEnum, Address> addresses = new EnumMap<AddressTypeEnum, Address>(AddressTypeEnum.class);
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @ElementCollection
    @CollectionTable(name="dbo_contact_person_email", joinColumns={@JoinColumn(name="ownerId")})
    @MapKeyEnumerated(value=EnumType.STRING)
    @MapKeyColumn(name="typeKey", length=50)
    private Map<CommunicationTypeEnum, Email> emails = new EnumMap<CommunicationTypeEnum, Email>(CommunicationTypeEnum.class);
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @ElementCollection
    @CollectionTable(name="dbo_contact_person_phone", joinColumns={@JoinColumn(name="ownerId")})
    @MapKeyEnumerated(value=EnumType.STRING)
    @MapKeyColumn(name="typeKey", length=50)
    private Map<CommunicationTypeEnum, Phone> phones = new EnumMap<CommunicationTypeEnum, Phone>(CommunicationTypeEnum.class);

    @Override
    public Map<AddressTypeEnum, Address> getAddresses() {
        return this.addresses;
    }

    @Override
    public void setAddresses(Map<AddressTypeEnum, Address> addresses) {
        this.addresses = addresses;
    }

    @Override
    @JsonIgnore
    public void setAddress(Address address) {
        this.putAddressValueIntoMap(AddressTypeEnum.class, address, this.addresses);
    }

    @Override
    @JsonIgnore
    public Address getAddress(AddressTypeEnum addressType) {
        Objects.requireNonNull(addressType);
        if (this.addresses == null) {
            return null;
        }
        return this.addresses.get((Object)addressType);
    }

    @Override
    public Map<CommunicationTypeEnum, Email> getEmails() {
        return this.emails;
    }

    @Override
    public void setEmails(Map<CommunicationTypeEnum, Email> emails) {
        this.emails = emails;
    }

    @Override
    @JsonIgnore
    public void setEmail(Email email) {
        this.putAddressValueIntoMap(CommunicationTypeEnum.class, email, this.emails);
    }

    @Override
    @JsonIgnore
    public Email getEmail(CommunicationTypeEnum type) {
        Objects.requireNonNull(type);
        if (this.emails == null) {
            return null;
        }
        return this.emails.get((Object)type);
    }

    @Override
    public Map<CommunicationTypeEnum, Phone> getPhones() {
        return this.phones;
    }

    @Override
    public void setPhones(Map<CommunicationTypeEnum, Phone> phones) {
        this.phones = phones;
    }

    @Override
    @JsonIgnore
    public void setPhone(Phone phone) {
        this.putAddressValueIntoMap(CommunicationTypeEnum.class, phone, this.phones);
    }

    @Override
    @JsonIgnore
    public Phone getPhone(CommunicationTypeEnum type) {
        Objects.requireNonNull(type);
        if (this.emails == null) {
            return null;
        }
        return this.phones.get((Object)type);
    }

    public ContactPerson() {
    }

    public ContactPerson(String pid, String firstName, String lastName) {
        super(pid, firstName, lastName);
    }

    @Override
    public Person getPerson() {
        return this.person;
    }

    @Override
    public void setPerson(Person person) {
        this.person = person;
    }

    public Set<Pupil> getPupils() {
        return this.pupils;
    }

    public void setPupils(Set<Pupil> pupils) {
        this.pupils = pupils;
    }

    @Override
    public String toString() {
        return super.toString();
    }
}

