/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities.embed;

import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;

@Embeddable
public class Decision {
    @Column
    @Enumerated(value=EnumType.STRING)
    public Status status;
    @Column
    public Date date;
    @Column
    public String comment;

    public Decision() {
        this(Status.SUBMIT, new Date(), "");
    }

    public Decision(Status status) {
        this(status, new Date(), "");
    }

    public Decision(Status status, Date date, String comment) {
        this.status = status;
        this.date = date;
        this.comment = comment;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void approve() {
        this.applyStatus(Status.APPROVE);
    }

    public void deni() {
        this.applyStatus(Status.DENI);
    }

    public void submit() {
        this.applyStatus(Status.SUBMIT);
    }

    public void applyStatus(Status status) {
        this.status = status;
        this.date = new Date();
    }

    public String toString() {
        return this.status.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Decision)) {
            return false;
        }
        Decision decision = (Decision)o;
        return this.status == decision.status;
    }

    public int hashCode() {
        return this.status != null ? this.status.hashCode() : 0;
    }

    public static enum Status {
        APPROVE("Godk"),
        DENI("P\u00e5g\u00e5r"),
        SUBMIT("Avslag");

        private final String description;

        private Status(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

