/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities.embed;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.imcode.entities.enums.AddressTypeEnum;
import com.imcode.entities.superclasses.ContactInformation;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;

@Embeddable
public class Address
extends ContactInformation<AddressTypeEnum>
implements Serializable {
    @Column
    private Integer postalCode;
    @Column
    private String municipalityCode;
    @Column(length=50)
    private String city;
    @Column
    private String street;
    @Column
    private String street2;
    @Column
    private String careOf;

    public static Address of(AddressTypeEnum type) {
        Address address = new Address();
        address.setAddressType(type);
        return address;
    }

    public Address() {
        super(AddressTypeEnum.REGISTERED, null);
    }

    public Integer getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(Integer postalCode) {
        this.postalCode = postalCode;
    }

    public String getMunicipalityCode() {
        return this.municipalityCode;
    }

    public void setMunicipalityCode(String municipality_code) {
        this.municipalityCode = municipality_code;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
    }

    public String getStreet2() {
        return this.street2;
    }

    public void setStreet2(String street2) {
        this.street2 = street2;
    }

    public String getCareOf() {
        return this.careOf;
    }

    public void setCareOf(String careOf) {
        this.careOf = careOf;
    }

    @Deprecated
    public AddressTypeEnum getAddressType() {
        return (AddressTypeEnum)this.type;
    }

    @Deprecated
    public void setAddressType(AddressTypeEnum addressType) {
        this.type = addressType;
    }

    @Override
    @JsonIgnore
    public String getValue() {
        return this.toString();
    }

    @Override
    @JsonIgnore
    public void setValue(String address) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder().append(this.type).append(this.postalCode).append(this.city).append('(').append(this.municipalityCode).append("), ").append(this.street);
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        if (this.postalCode != null ? !this.postalCode.equals(address.postalCode) : address.postalCode != null) {
            return false;
        }
        if (this.municipalityCode != null ? !this.municipalityCode.equals(address.municipalityCode) : address.municipalityCode != null) {
            return false;
        }
        if (this.city != null ? !this.city.equals(address.city) : address.city != null) {
            return false;
        }
        if (this.street != null ? !this.street.equals(address.street) : address.street != null) {
            return false;
        }
        if (this.street2 != null ? !this.street2.equals(address.street2) : address.street2 != null) {
            return false;
        }
        if (this.careOf != null ? !this.careOf.equals(address.careOf) : address.careOf != null) {
            return false;
        }
        return this.type == address.type;
    }

    @Override
    public int hashCode() {
        int result = this.postalCode != null ? this.postalCode.hashCode() : 0;
        result = 31 * result + (this.municipalityCode != null ? this.municipalityCode.hashCode() : 0);
        result = 31 * result + (this.city != null ? this.city.hashCode() : 0);
        result = 31 * result + (this.street != null ? this.street.hashCode() : 0);
        result = 31 * result + (this.street2 != null ? this.street2.hashCode() : 0);
        result = 31 * result + (this.careOf != null ? this.careOf.hashCode() : 0);
        result = 31 * result + (this.type != null ? ((AddressTypeEnum)this.type).hashCode() : 0);
        return result;
    }
}

