/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.imcode.entities.Person;
import com.imcode.entities.Role;
import com.imcode.entities.interfaces.JpaPersonalizedEntity;
import com.imcode.entities.superclasses.AbstractNamedEntity;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.springframework.security.core.userdetails.UserDetails;

@Entity
@Table(name="dbo_user")
@AttributeOverride(name="name", column=@Column(unique=true, length=150, nullable=false))
public class User
extends AbstractNamedEntity<Long>
implements UserDetails,
Serializable,
JpaPersonalizedEntity {
    public static final String DEFAULT_PASSWORD = "";
    @Column(nullable=false, columnDefinition="")
    @JsonIgnore
    private String password = "";
    @Transient
    @JsonIgnore
    private String confirmPassword = "";
    @Column
    private Boolean enabled = true;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="personId")
    private Person person;
    @ManyToMany(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinTable(name="dbo_user_roles_cross", joinColumns={@JoinColumn(name="userId")}, inverseJoinColumns={@JoinColumn(name="roleId")})
    private Set<Role> roles = new HashSet<Role>();
    @Column
    private String saml2Id;

    public User() {
    }

    public User(String username, String password, Boolean enabled, Set<Role> roles) {
        this.name = username;
        this.password = password;
        this.enabled = enabled;
        this.roles = roles;
    }

    public User(String username, String password, Role ... roles) {
        this.name = username;
        this.password = password;
        Collections.addAll(this.roles, roles);
    }

    @JsonIgnore
    public String getUsername() {
        return this.name;
    }

    @JsonIgnore
    public void setUsername(String username) {
        this.name = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Set<Role> getAuthorities() {
        return this.roles;
    }

    public void setAuthorities(Set<Role> roles) {
        this.roles = roles;
    }

    @Override
    public Person getPerson() {
        return this.person;
    }

    @Override
    public void setPerson(Person person) {
        this.person = person;
    }

    @JsonIgnore
    public String getConfirmPassword() {
        return this.confirmPassword;
    }

    @JsonIgnore
    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    @JsonIgnore
    public boolean isAccountNonExpired() {
        return true;
    }

    @JsonIgnore
    public boolean isAccountNonLocked() {
        return true;
    }

    @JsonIgnore
    public boolean isCredentialsNonExpired() {
        return true;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    @Override
    public String toString() {
        return this.name == null ? Long.toString((Long)this.id) : this.name;
    }

    @JsonIgnore
    public void setAuthorities(Role role) {
        this.roles = new HashSet<Role>(Collections.singleton(role));
    }

    public String getSaml2Id() {
        return this.saml2Id;
    }

    public void setSaml2Id(String saml2Id) {
        this.saml2Id = saml2Id;
    }
}

