/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities.superclasses;

import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.imcode.entities.interfaces.JpaEntity;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.MappedSuperclass;

@MappedSuperclass
@JsonIdentityInfo(generator=ObjectIdGenerators.IntSequenceGenerator.class, property="@Id")
public abstract class AbstractIdEntity<ID extends Serializable>
implements JpaEntity<ID>,
Serializable {
    @Id
    @GeneratedValue
    @Column
    protected ID id;

    public AbstractIdEntity() {
    }

    public AbstractIdEntity(ID id) {
        this.id = id;
    }

    @Override
    public ID getId() {
        return this.id;
    }

    @Override
    public void setId(ID id) {
        this.id = id;
    }

    @Override
    public String getClassDescription() {
        StringBuilder builder = new StringBuilder();
        String className = this.getClass().getSimpleName();
        String[] words = className.split("(?=[A-Z])");
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            if (i != 0) {
                builder.append(word.toLowerCase());
            } else {
                builder.append(word);
            }
            if (i >= words.length - 1) continue;
            builder.append(' ');
        }
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractIdEntity idEntity = (AbstractIdEntity)o;
        return !(this.id == null ? idEntity.id != null : !this.id.equals(idEntity.id));
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.id + ')';
    }
}

