/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.imcode.entities.embed.Address;
import com.imcode.entities.embed.Email;
import com.imcode.entities.embed.Phone;
import com.imcode.entities.enums.AddressTypeEnum;
import com.imcode.entities.superclasses.AbstractIdEntity;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.JoinColumn;
import javax.persistence.MapKeyColumn;
import javax.persistence.MapKeyEnumerated;
import javax.persistence.Table;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;
import org.springframework.util.StringUtils;

@Entity
@Table(name="dbo_person")
public class Person
extends AbstractIdEntity<Long>
implements Serializable {
    @Column
    private String personalId;
    @Column
    private String firstName;
    @Column
    private String lastName;
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @ElementCollection
    @CollectionTable(name="dbo_person_address", joinColumns={@JoinColumn(name="ownerId")})
    @MapKeyEnumerated(value=EnumType.STRING)
    @MapKeyColumn(name="addressTypeKey")
    private Map<AddressTypeEnum, Address> addresses;
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @ElementCollection
    @CollectionTable(name="dbo_person_email", joinColumns={@JoinColumn(name="ownerId")})
    private List<Email> emails;
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @ElementCollection
    @CollectionTable(name="dbo_person_phone", joinColumns={@JoinColumn(name="ownerId")})
    private List<Phone> phones;

    public Person() {
    }

    public Person(String pid, String firstName, String lastName) {
        this.personalId = pid;
        this.firstName = firstName;
        this.lastName = lastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public Map<AddressTypeEnum, Address> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(Map<AddressTypeEnum, Address> addresses) {
        if (!(addresses instanceof EnumMap)) {
            addresses = addresses == null || addresses.isEmpty() ? new EnumMap<AddressTypeEnum, Address>(AddressTypeEnum.class) : new EnumMap<AddressTypeEnum, Address>(addresses);
        }
        this.addresses = addresses;
    }

    @JsonIgnore
    public Address getRegistredAddress() {
        return this.getAddress(AddressTypeEnum.REGISTERED);
    }

    @JsonIgnore
    public Address getResidentalAddress() {
        return this.getAddress(AddressTypeEnum.RESIDENTIAL);
    }

    @JsonIgnore
    public Address getBoarderdAddress() {
        return this.getAddress(AddressTypeEnum.BOARDER);
    }

    @JsonIgnore
    public Address getAddress(AddressTypeEnum addressType) {
        Objects.requireNonNull(addressType);
        if (this.addresses == null) {
            return null;
        }
        return this.addresses.get((Object)addressType);
    }

    @JsonIgnore
    public void setAddress(Address address) {
        Objects.requireNonNull(address);
        Objects.requireNonNull(address.getAddressType());
        if (this.addresses == null) {
            this.addresses = new EnumMap<AddressTypeEnum, Address>(AddressTypeEnum.class);
        }
        this.addresses.put(address.getAddressType(), address);
    }

    public String getPersonalId() {
        return this.personalId;
    }

    public void setPersonalId(String personalId) {
        this.personalId = personalId;
    }

    public List<Email> getEmails() {
        return this.emails;
    }

    public void setEmails(List<Email> emails) {
        this.emails = emails;
    }

    public void setPhones(List<Phone> phones) {
        this.phones = phones;
    }

    public List<Phone> getPhones() {
        return this.phones;
    }

    public static Person fromString(String firstNameLastName) {
        if (firstNameLastName == null || firstNameLastName.isEmpty()) {
            throw new IllegalArgumentException("The \"firstNameLastName\" should be not epmty!");
        }
        Person person = new Person();
        String[] parts = firstNameLastName.split(" ");
        person.setFirstName(parts[0]);
        try {
            person.setLastName(parts[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return person;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (StringUtils.hasText((String)this.firstName)) {
            this.addWord(sb, this.firstName);
        }
        if (StringUtils.hasText((String)this.lastName)) {
            this.addWord(sb, this.lastName);
        }
        if (sb.length() == 0) {
            this.addWord(sb, this.personalId);
        }
        return sb.toString();
    }

    private void addWord(StringBuilder sb, String word) {
        if (sb.length() > 0 && sb.charAt(sb.length() - 1) != ' ') {
            sb.append(' ');
        }
        sb.append(word);
    }
}

