/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.imcode.entities.Person;
import com.imcode.entities.Role;
import com.imcode.entities.superclasses.AbstractNamedEntity;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.springframework.security.core.userdetails.UserDetails;

@Entity
@Table(name="dbo_user")
@AttributeOverride(name="name", column=@Column(unique=true, length=150, nullable=false))
public class User
extends AbstractNamedEntity<Long>
implements UserDetails,
Serializable {
    public static final String DEFAULT_PASSWORD = "";
    @Column(nullable=false, columnDefinition="")
    @JsonIgnore
    private String password = "";
    @Transient
    @JsonIgnore
    private String confirmPassword = "";
    @Column
    private Boolean enabled = true;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="personId")
    private Person person;
    @ManyToMany(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinTable(name="dbo_user_roles_cross", joinColumns={@JoinColumn(name="userId")}, inverseJoinColumns={@JoinColumn(name="roleId")})
    private Set<Role> roles = new HashSet<Role>();

    public User() {
    }

    public User(String username, String password, Boolean enabled, Set<Role> roles) {
        this.name = username;
        this.password = password;
        this.enabled = enabled;
        this.roles = roles;
    }

    public User(String username, String password, Role ... roles) {
        this.name = username;
        this.password = password;
        Collections.addAll(this.roles, roles);
    }

    @JsonIgnore
    public String getUsername() {
        return this.name;
    }

    @JsonIgnore
    public void setUsername(String username) {
        this.name = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Set<Role> getAuthorities() {
        return this.roles;
    }

    public void setAuthorities(Set<Role> roles) {
        this.roles = roles;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    @JsonIgnore
    public String getConfirmPassword() {
        return this.confirmPassword;
    }

    @JsonIgnore
    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    @JsonIgnore
    public boolean isAccountNonExpired() {
        return true;
    }

    @JsonIgnore
    public boolean isAccountNonLocked() {
        return true;
    }

    @JsonIgnore
    public boolean isCredentialsNonExpired() {
        return true;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("User{");
        sb.append("id=").append(this.id);
        sb.append(", login='").append(this.name).append('\'');
        sb.append(", pwd='").append(this.password).append('\'');
        sb.append('}');
        return sb.toString();
    }

    @JsonIgnore
    public void setAuthorities(Role role) {
        this.roles = new HashSet<Role>(Arrays.asList(role));
    }
}

