/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities;

import com.imcode.entities.AcademicYear;
import com.imcode.entities.Guardian;
import com.imcode.entities.Person;
import com.imcode.entities.Pupil;
import com.imcode.entities.SchoolTransport;
import com.imcode.entities.embed.Address;
import com.imcode.entities.embed.SchoolTransportSchema;
import com.imcode.entities.enums.StatementStatus;
import com.imcode.entities.superclasses.AbstractIdEntity;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;

@Entity
@Table(name="dbo_statement")
public class Application
extends AbstractIdEntity<Long>
implements Serializable {
    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn
    public Person submittedPerson;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column
    public Date submitDate;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Column
    public Date changedDate;
    @Enumerated(value=EnumType.STRING)
    @Column
    public StatementStatus status;
    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="pupilId")
    public Pupil pupil;
    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="guardianId")
    public Guardian guardian;
    @ManyToOne(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinColumn(name="handledPersonId")
    public Person handledPerson;
    @Embedded
    public Address address = new Address();
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="academicYearId")
    private AcademicYear academicYear;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="schoolTransportId")
    private SchoolTransport schoolTransport;
    @Column
    private String reasone;
    @ElementCollection
    @CollectionTable(name="dbo_school_transport_schema", joinColumns={@JoinColumn(name="ownerId")}, uniqueConstraints={@UniqueConstraint(columnNames={"ownerId", "dayOfWeek"})})
    private List<SchoolTransportSchema> schoolTransportSchema;
    @Column
    private Boolean accompanyingAssistant;
    @Column
    private Boolean byMobilPhone;
    @Column
    private Boolean wheelchair;
    @Column
    private Boolean shorty;

    @PrePersist
    void prePresist() {
        this.submitDate = new Date();
    }

    @PreUpdate
    void preUpdate() {
        this.changedDate = new Date();
    }

    public Date getSubmitDate() {
        return this.submitDate;
    }

    public void setSubmitDate(Date submitDate) {
        this.submitDate = submitDate;
    }

    public Date getChangedDate() {
        return this.changedDate;
    }

    public void setChangedDate(Date changedDate) {
        this.changedDate = changedDate;
    }

    public StatementStatus getStatus() {
        return this.status;
    }

    public void setStatus(StatementStatus status) {
        this.status = status;
    }

    public Person getSubmittedPerson() {
        return this.submittedPerson;
    }

    public void setSubmittedPerson(Person submittedPerson) {
        this.submittedPerson = submittedPerson;
    }

    public Pupil getPupil() {
        return this.pupil;
    }

    public void setPupil(Pupil pupil) {
        this.pupil = pupil;
    }

    public Guardian getGuardian() {
        return this.guardian;
    }

    public void setGuardian(Guardian guardian) {
        this.guardian = guardian;
    }

    public Person getHandledPerson() {
        return this.handledPerson;
    }

    public void setHandledPerson(Person handledPerson) {
        this.handledPerson = handledPerson;
    }

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public AcademicYear getAcademicYear() {
        return this.academicYear;
    }

    public void setAcademicYear(AcademicYear academicYear) {
        this.academicYear = academicYear;
    }

    public SchoolTransport getSchoolTransport() {
        return this.schoolTransport;
    }

    public void setSchoolTransport(SchoolTransport schoolTransport) {
        this.schoolTransport = schoolTransport;
    }

    public String getReasone() {
        return this.reasone;
    }

    public void setReasone(String reasone) {
        this.reasone = reasone;
    }

    public List<SchoolTransportSchema> getSchoolTransportSchema() {
        return this.schoolTransportSchema;
    }

    public void setSchoolTransportSchema(List<SchoolTransportSchema> schoolTransportSchema) {
        this.schoolTransportSchema = schoolTransportSchema;
    }

    public Boolean getAccompanyingAssistant() {
        return this.accompanyingAssistant;
    }

    public void setAccompanyingAssistant(Boolean accompanyingAssistant) {
        this.accompanyingAssistant = accompanyingAssistant;
    }

    public Boolean getByMobilPhone() {
        return this.byMobilPhone;
    }

    public void setByMobilPhone(Boolean byMobilPhone) {
        this.byMobilPhone = byMobilPhone;
    }

    public Boolean getWheelchair() {
        return this.wheelchair;
    }

    public void setWheelchair(Boolean wheelchair) {
        this.wheelchair = wheelchair;
    }

    public Boolean getShorty() {
        return this.shorty;
    }

    public void setShorty(Boolean shorty) {
        this.shorty = shorty;
    }
}

