/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities;

import com.imcode.entities.Entity;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class SetListAdapter<T>
implements List<T> {
    private final LinkedHashSet<T> nestedSet;
    private final Map<Integer, T> indexMap;

    public SetListAdapter(LinkedHashSet<T> nestedSet) {
        this.nestedSet = nestedSet;
        this.indexMap = new HashMap<Integer, T>();
        this.fillIndexMap(nestedSet);
    }

    private void fillIndexMap(LinkedHashSet<T> nestedSet) {
        int i = 0;
        for (Object value : nestedSet) {
            this.indexMap.put(i++, value);
        }
    }

    private void rangeCheck(int index) {
        if (index >= this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
    }

    @Override
    public T get(int index) {
        this.rangeCheck(index);
        return this.indexMap.get(index);
    }

    @Override
    public T set(int index, T element) {
        this.rangeCheck(index);
        T oldValue = this.get(index);
        if (oldValue != null) {
            Object[] oldOrder = this.nestedSet.toArray();
            for (int i = 0; i < oldOrder.length; ++i) {
                Object entity = oldOrder[i];
                if (!oldValue.equals(entity)) continue;
                oldOrder[i] = element;
            }
            this.nestedSet.clear();
            this.nestedSet.addAll(Arrays.asList(oldOrder));
            for (Map.Entry<Integer, T> entry : this.indexMap.entrySet()) {
                T value = entry.getValue();
                if (!oldValue.equals(value)) continue;
                entry.setValue(element);
            }
        }
        return null;
    }

    @Override
    public int size() {
        return this.indexMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.nestedSet.isEmpty();
    }

    @Override
    public boolean add(T t) {
        for (Map.Entry<Integer, T> entry : this.indexMap.entrySet()) {
            T value = entry.getValue();
            if (value == null) {
                if (t != null) continue;
                this.indexMap.put(this.indexMap.size(), value);
                return true;
            }
            if (!value.equals(t)) continue;
            this.indexMap.put(this.indexMap.size(), value);
            return true;
        }
        this.indexMap.put(this.indexMap.size(), t);
        this.nestedSet.add(t);
        return true;
    }

    public String toString() {
        return this.indexMap.values().toString();
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) {
        LinkedHashSet<Entity> set = new LinkedHashSet<Entity>();
        Entity e0 = new Entity(0);
        Entity e1 = new Entity(1);
        Entity e2 = new Entity(2);
        Entity e3 = new Entity(4);
        set.add(e0);
        set.add(e1);
        set.add(e2);
        set.add(e3);
        SetListAdapter listAdapter = new SetListAdapter(set);
        listAdapter.add((T)new Entity(5));
        listAdapter.add((T)e2);
        e2.setId(20);
        Entity e = (Entity)listAdapter.get(5);
        e.setId(200);
        listAdapter.add((T)null);
        listAdapter.add((T)null);
        System.out.println(listAdapter.indexMap);
        System.out.println(set);
        System.out.println("----------------------------------------------");
        listAdapter.set(5, (T)new Entity(6));
        System.out.println(listAdapter.indexMap);
        System.out.println(set);
    }
}

