/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities;

import com.imcode.entities.AbstractIdEntity;
import com.imcode.entities.AcademicYear;
import com.imcode.entities.Guardian;
import com.imcode.entities.Person;
import com.imcode.entities.School;
import com.imcode.entities.SchoolClass;
import com.imcode.entities.Truancy;
import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;

@Entity
@Table(name="dbo_pupil")
public class Pupil
extends AbstractIdEntity
implements Serializable {
    @ManyToOne(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH})
    @JoinColumn(name="personId")
    private Person person;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="schoolClassId")
    private SchoolClass schoolClass;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="schoolId")
    private School school;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="academicYearId")
    private AcademicYear academicYear;
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @ManyToMany(fetch=FetchType.EAGER, cascade={CascadeType.PERSIST, CascadeType.MERGE, CascadeType.REFRESH})
    @JoinTable(name="dbo_pupil_guardians_cross", joinColumns={@JoinColumn(name="pupilId")}, inverseJoinColumns={@JoinColumn(name="guardianId")})
    private List<Guardian> guardians;
    @OneToMany(mappedBy="pupil", fetch=FetchType.EAGER)
    private Set<Truancy> truancies;

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public SchoolClass getSchoolClass() {
        return this.schoolClass;
    }

    public void setSchoolClass(SchoolClass schoolClass) {
        this.schoolClass = schoolClass;
    }

    public AcademicYear getAcademicYear() {
        return this.academicYear;
    }

    public void setAcademicYear(AcademicYear academicYear) {
        this.academicYear = academicYear;
    }

    public Set<Truancy> getTruancies() {
        return this.truancies;
    }

    public void setTruancies(Set<Truancy> truancies) {
        this.truancies = truancies;
    }

    public List<Guardian> getGuardians() {
        return this.guardians;
    }

    public void setGuardians(List<Guardian> guardians) {
        this.guardians = guardians;
    }

    public School getSchool() {
        return this.school;
    }

    public void setSchool(School school) {
        this.school = school;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("Pupil{");
        if (this.person != null) {
            sb.append(this.person.getLastName()).append(" ").append(this.person.getFirstName());
        }
        sb.append("(").append(this.academicYear);
        sb.append(":").append(this.schoolClass);
        sb.append(")}");
        return sb.toString();
    }
}

