/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities;

import com.imcode.entities.AbstractIdEntity;
import com.imcode.entities.embed.Address;
import com.imcode.entities.embed.Email;
import com.imcode.entities.embed.Phone;
import java.io.Serializable;
import java.util.List;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.Table;
import org.hibernate.annotations.LazyCollection;
import org.hibernate.annotations.LazyCollectionOption;

@Entity
@Table(name="dbo_person")
public class Person
extends AbstractIdEntity
implements Serializable {
    @Column
    private String personalId;
    @Column
    private String firstName;
    @Column
    private String lastName;
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @ElementCollection
    @CollectionTable(name="dbo_person_address", joinColumns={@JoinColumn(name="ownerId")})
    private List<Address> addresses;
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @ElementCollection
    @CollectionTable(name="dbo_person_email", joinColumns={@JoinColumn(name="ownerId")})
    private List<Email> emails;
    @LazyCollection(value=LazyCollectionOption.FALSE)
    @ElementCollection
    @CollectionTable(name="dbo_person_phone", joinColumns={@JoinColumn(name="ownerId")})
    private List<Phone> phones;

    public Person() {
    }

    public Person(String pid, String firstName, String lastName) {
        this.personalId = pid;
        this.firstName = firstName;
        this.lastName = lastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public List<Address> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }

    public String getPersonalId() {
        return this.personalId;
    }

    public void setPersonalId(String personalId) {
        this.personalId = personalId;
    }

    public List<Email> getEmails() {
        return this.emails;
    }

    public void setEmails(List<Email> emails) {
        this.emails = emails;
    }

    public void setPhones(List<Phone> phones) {
        this.phones = phones;
    }

    public List<Phone> getPhones() {
        return this.phones;
    }

    public static Person fromString(String firstNameLastName) {
        if (firstNameLastName == null || firstNameLastName.isEmpty()) {
            throw new IllegalArgumentException("The \"firstNameLastName\" should be not epmty!");
        }
        Person person = new Person();
        String[] parts = firstNameLastName.split(" ");
        person.setFirstName(parts[0]);
        try {
            person.setLastName(parts[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return person;
    }

    @Override
    public String toString() {
        return "Person{id=" + this.id + ", firstName='" + this.firstName + '\'' + ", lastName='" + this.lastName + '\'' + ", addresses=" + this.addresses + '}';
    }
}

