/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities;

import com.imcode.entities.AbstractNamedEntity;
import com.imcode.entities.Person;
import com.imcode.entities.Role;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.springframework.security.core.userdetails.UserDetails;

@Entity
@Table(name="dbo_user")
@AttributeOverride(name="name", column=@Column(unique=true, length=150, nullable=false))
public class User
extends AbstractNamedEntity
implements UserDetails,
Serializable {
    public static final String DEFAULT_PASSWORD = "";
    @Column(nullable=false, columnDefinition="")
    private String password = "";
    @Transient
    private String confirmPassword = "";
    @Column
    private Boolean enabled = true;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="personId")
    private Person person;
    @ManyToMany(cascade={CascadeType.REFRESH}, fetch=FetchType.EAGER)
    @JoinTable(name="dbo_user_roles_cross", joinColumns={@JoinColumn(name="userId")}, inverseJoinColumns={@JoinColumn(name="roleId")})
    private Set<Role> roles = new HashSet<Role>();

    public User() {
    }

    public User(String username, String password, Boolean enabled, Set<Role> roles) {
        this.name = username;
        this.password = password;
        this.enabled = enabled;
        this.roles = roles;
    }

    public User(String username, String password, Role ... roles) {
        this.name = username;
        this.password = password;
        Collections.addAll(this.roles, roles);
    }

    public String getUsername() {
        return this.name;
    }

    public void setUsername(String username) {
        this.name = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Set<Role> getAuthorities() {
        return this.roles;
    }

    public void setAuthorities(Set<Role> roles) {
        this.roles = roles;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public String getConfirmPassword() {
        return this.confirmPassword;
    }

    public void setConfirmPassword(String confirmPassword) {
        this.confirmPassword = confirmPassword;
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("User{");
        sb.append("id=").append(this.id);
        sb.append(", login='").append(this.name).append('\'');
        sb.append(", pwd='").append(this.password).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public void setAuthorities(Role role) {
        this.roles = new HashSet<Role>(Arrays.asList(role));
    }
}

