/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities;

import com.imcode.entities.AbstractIdEntity;
import com.imcode.entities.Address;
import com.imcode.entities.Email;
import com.imcode.entities.Phone;
import java.io.Serializable;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.Table;

@Entity
@Table(name="dbo_person")
public class Person
extends AbstractIdEntity
implements Serializable {
    @Column
    private String personalId;
    @Column
    private String firstName;
    @Column
    private String lastName;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="dbo_person_address_cross", joinColumns={@JoinColumn(name="personId", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="addressId", referencedColumnName="id")})
    private Set<Address> addresses;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="dbo_person_email_cross", joinColumns={@JoinColumn(name="personId")}, inverseJoinColumns={@JoinColumn(name="emailId")})
    private Set<Email> emails;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="dbo_person_phone_cross", joinColumns={@JoinColumn(name="personId")}, inverseJoinColumns={@JoinColumn(name="phoneId")})
    private Set<Phone> phones;

    public Person() {
    }

    public Person(String pid, String firstName, String lastName) {
        this.personalId = pid;
        this.firstName = firstName;
        this.lastName = lastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public Set<Address> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(Set<Address> addresses) {
        this.addresses = addresses;
    }

    public String getPersonalId() {
        return this.personalId;
    }

    public void setPersonalId(String personalId) {
        this.personalId = personalId;
    }

    public Set<Email> getEmails() {
        return this.emails;
    }

    public void setEmails(Set<Email> emails) {
        this.emails = emails;
    }

    public Set<Phone> getPhones() {
        return this.phones;
    }

    public void setPhones(Set<Phone> phones) {
        this.phones = phones;
    }

    public static Person fromString(String firstNameLastName) {
        if (firstNameLastName == null || firstNameLastName.isEmpty()) {
            throw new IllegalArgumentException("The \"firstNameLastName\" should be not epmty!");
        }
        Person person = new Person();
        String[] parts = firstNameLastName.split(" ");
        person.setFirstName(parts[0]);
        try {
            person.setLastName(parts[1]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return person;
    }

    @Override
    public String toString() {
        return "Person{id=" + this.id + ", firstName='" + this.firstName + '\'' + ", lastName='" + this.lastName + '\'' + ", addresses=" + this.addresses + '}';
    }
}

