/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.entities.enums;

import com.imcode.entities.Address;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;

@Entity
@Table(name="dbo_address_type")
public class _AddressType {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private Integer id;
    @Enumerated(value=EnumType.STRING)
    private AddressTypeEnum addressType;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="addressType")
    private Set<Address> addresses;

    public _AddressType() {
    }

    public _AddressType(AddressTypeEnum addressType) {
        this.id = addressType.id;
        this.addressType = addressType;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public AddressTypeEnum getAddressType() {
        return this.addressType;
    }

    public void setAddressType(AddressTypeEnum addressType) {
        this.addressType = addressType;
    }

    public Set<Address> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(Set<Address> addresses) {
        this.addresses = addresses;
    }

    public static enum AddressTypeEnum {
        REGISTERED(0, "Registered address"),
        RESIDENTIAL(1, "Residential address"),
        BOARDER(2, "Boarder address");

        private String representation;
        private int id;

        private AddressTypeEnum(int id, String representation) {
            this.representation = representation;
        }

        public int toInt() {
            return this.id;
        }

        public static AddressTypeEnum fromInt(int id) {
            for (AddressTypeEnum addressTypeEnum : AddressTypeEnum.values()) {
                if (addressTypeEnum.id != id) continue;
                return addressTypeEnum;
            }
            throw new IllegalArgumentException();
        }

        public String toString() {
            return this.representation;
        }
    }
}

