/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.user;

import com.imcode.imcms.api.I18nLanguage;
import com.imcode.imcms.api.I18nMeta;
import com.imcode.imcms.api.I18nSupport;
import com.imcode.imcms.api.Meta;
import imcode.server.Imcms;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentPermissionSetDomainObject;
import imcode.server.document.DocumentPermissionSetTypeDomainObject;
import imcode.server.document.RoleIdToDocumentPermissionSetTypeMappings;
import imcode.server.document.TemplateGroupDomainObject;
import imcode.server.document.TextDocumentPermissionSetDomainObject;
import imcode.server.user.DocumentShowSettings;
import imcode.server.user.ImcmsAuthenticatorAndUserAndRoleMapper;
import imcode.server.user.PhoneNumber;
import imcode.server.user.PhoneNumberType;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.RoleId;
import imcode.server.user.RoleIds;
import imcode.server.user.RolePermissionDomainObject;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.NotPredicate;
import org.apache.commons.lang.UnhandledException;

public class UserDomainObject
implements Cloneable,
Serializable {
    public static final int DEFAULT_USER_ID = 2;
    protected int id;
    private String loginName = "";
    private String password;
    private String firstName = "";
    private String lastName = "";
    private String title = "";
    private String company = "";
    private String address = "";
    private String city = "";
    private String zip = "";
    private String country = "";
    private String province = "";
    private String emailAddress = "";
    private boolean active = true;
    private Date createDate;
    private String languageIso639_2;
    private TemplateGroupDomainObject templateGroup;
    private boolean imcmsExternal;
    private HashSet phoneNumbers = new HashSet();
    RoleIds roleIds = this.createRolesSetWithUserRole();
    protected RoleIds userAdminRoleIds = new RoleIds();
    private DocumentShowSettings documentShowSettings = new DocumentShowSettings();
    private String sessionId;
    private String currentContextPath;

    public UserDomainObject() {
    }

    public UserDomainObject(int id) {
        this.id = id;
    }

    private RoleIds createRolesSetWithUserRole() {
        RoleIds newRoleIds = new RoleIds();
        newRoleIds.add(RoleId.USERS);
        return newRoleIds;
    }

    public Object clone() {
        try {
            UserDomainObject clone = (UserDomainObject)super.clone();
            clone.roleIds = (RoleIds)this.roleIds.clone();
            clone.userAdminRoleIds = (RoleIds)this.userAdminRoleIds.clone();
            clone.phoneNumbers = (HashSet)this.phoneNumbers.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getLoginName() {
        return this.loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFullName() {
        return this.getFirstName() + " " + this.getLastName();
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getCompany() {
        return this.company;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return this.address;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCity() {
        return this.city;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }

    public String getZip() {
        return this.zip;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getCountry() {
        return this.country;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getProvince() {
        return this.province;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getWorkPhone() {
        return this.getFirstPhoneNumberOfTypeAsString(PhoneNumberType.WORK);
    }

    private String getFirstPhoneNumberOfTypeAsString(PhoneNumberType phoneNumberType) {
        PhoneNumber firstPhoneNumberOfType = this.getFirstPhoneNumberOfType(phoneNumberType);
        String number = null;
        if (null != firstPhoneNumberOfType) {
            number = firstPhoneNumberOfType.getNumber();
        }
        return number;
    }

    private PhoneNumber getFirstPhoneNumberOfType(PhoneNumberType phoneNumberType) {
        Set phoneNumbersOfType = this.getPhoneNumbersOfType(phoneNumberType);
        Iterator iterator = phoneNumbersOfType.iterator();
        if (iterator.hasNext()) {
            return (PhoneNumber)iterator.next();
        }
        return null;
    }

    public Set getPhoneNumbersOfType(PhoneNumberType phoneNumberType) {
        return new HashSet(CollectionUtils.select((Collection)this.phoneNumbers, (Predicate)new PhoneNumberOfTypePredicate(phoneNumberType)));
    }

    public void setWorkPhone(String workphone) {
        this.replacePhoneNumbersOfType(workphone, PhoneNumberType.WORK);
    }

    public void replacePhoneNumbersOfType(String number, PhoneNumberType type) {
        this.removePhoneNumbersOfType(type);
        this.addPhoneNumber(new PhoneNumber(number, type));
    }

    private void removePhoneNumbersOfType(PhoneNumberType phoneNumberType) {
        CollectionUtils.filter((Collection)this.phoneNumbers, (Predicate)new NotPredicate((Predicate)new PhoneNumberOfTypePredicate(phoneNumberType)));
    }

    public String getMobilePhone() {
        return this.getFirstPhoneNumberOfTypeAsString(PhoneNumberType.MOBILE);
    }

    public void setMobilePhone(String mobilephone) {
        this.replacePhoneNumbersOfType(mobilephone, PhoneNumberType.MOBILE);
    }

    public String getHomePhone() {
        return this.getFirstPhoneNumberOfTypeAsString(PhoneNumberType.HOME);
    }

    public void setHomePhone(String homephone) {
        this.replacePhoneNumbersOfType(homephone, PhoneNumberType.HOME);
    }

    public String getFaxPhone() {
        return this.getFirstPhoneNumberOfTypeAsString(PhoneNumberType.FAX);
    }

    public void setFaxPhone(String faxphone) {
        this.replacePhoneNumbersOfType(faxphone, PhoneNumberType.FAX);
    }

    public String getOtherPhone() {
        return this.getFirstPhoneNumberOfTypeAsString(PhoneNumberType.OTHER);
    }

    public void setOtherPhone(String otherphone) {
        this.replacePhoneNumbersOfType(otherphone, PhoneNumberType.OTHER);
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = (Date)createDate.clone();
    }

    public Date getCreateDate() {
        return (Date)(null == this.createDate ? null : this.createDate.clone());
    }

    public void setTemplateGroup(TemplateGroupDomainObject templateGroup) {
        this.templateGroup = templateGroup;
    }

    public TemplateGroupDomainObject getTemplateGroup() {
        return this.templateGroup;
    }

    public String getLanguageIso639_2() {
        return this.languageIso639_2;
    }

    public void setLanguageIso639_2(String languageIso639_2) {
        this.languageIso639_2 = languageIso639_2;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public boolean isImcmsExternal() {
        return this.imcmsExternal;
    }

    public void setImcmsExternal(boolean imcmsExternal) {
        this.imcmsExternal = imcmsExternal;
    }

    public void addRoleId(RoleId role) {
        this.roleIds.add(role);
    }

    public void removeRoleId(RoleId roleId) {
        if (!RoleId.USERS.equals(roleId)) {
            this.roleIds.remove(roleId);
        }
    }

    public void setRoleIds(RoleId[] roleIds) {
        this.roleIds = new RoleIds(roleIds);
        this.roleIds.add(RoleId.USERS);
    }

    public boolean hasRoleId(RoleId roleId) {
        return this.roleIds.contains(roleId);
    }

    public RoleId[] getRoleIds() {
        return this.roleIds.toArray();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserDomainObject)) {
            return false;
        }
        UserDomainObject userDomainObject = (UserDomainObject)o;
        return this.id == userDomainObject.id;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean isDefaultUser() {
        return 2 == this.id;
    }

    public boolean isSuperAdmin() {
        return this.hasRoleId(RoleId.SUPERADMIN);
    }

    public boolean isUserAdminAndCanEditAtLeastOneRole() {
        return this.isUserAdmin() && !this.userAdminRoleIds.isEmpty();
    }

    public boolean canEdit(DocumentDomainObject document) {
        return this.hasAtLeastPermissionSetIdOn(DocumentPermissionSetTypeDomainObject.RESTRICTED_2, document);
    }

    public boolean canAccess(DocumentDomainObject document) {
        return this.hasAtLeastPermissionSetIdOn(DocumentPermissionSetTypeDomainObject.READ, document);
    }

    public boolean isSuperAdminOrHasFullPermissionOn(DocumentDomainObject document) {
        return this.isSuperAdminOrHasAtLeastPermissionSetIdOn(DocumentPermissionSetTypeDomainObject.FULL, document);
    }

    public boolean canDefineRestrictedOneFor(DocumentDomainObject document) {
        return this.isSuperAdminOrHasFullPermissionOn(document);
    }

    public boolean canDefineRestrictedTwoFor(DocumentDomainObject document) {
        boolean hasFullPermission = this.isSuperAdminOrHasFullPermissionOn(document);
        boolean canEditPermissionsForDocument = this.canEditPermissionsFor(document);
        boolean hasAtLeastRestrictedOne = this.hasAtLeastRestrictedOnePermissionOn(document);
        boolean hasAtLeastRestrictedOnePermissionAndIsMorePrivilegedThanRestrictedTwo = hasAtLeastRestrictedOne && document.isRestrictedOneMorePrivilegedThanRestrictedTwo();
        return hasFullPermission || canEditPermissionsForDocument && hasAtLeastRestrictedOnePermissionAndIsMorePrivilegedThanRestrictedTwo;
    }

    private boolean hasAtLeastRestrictedOnePermissionOn(DocumentDomainObject document) {
        return this.hasAtLeastPermissionSetIdOn(DocumentPermissionSetTypeDomainObject.RESTRICTED_1, document);
    }

    public String toString() {
        return "(user " + this.id + " \"" + this.loginName + "\")";
    }

    public void addPhoneNumber(PhoneNumber number) {
        this.phoneNumbers.add(number);
    }

    public void removePhoneNumber(PhoneNumber number) {
        this.phoneNumbers.remove(number);
    }

    public void setCurrentContextPath(String currentContextPath) {
        this.currentContextPath = currentContextPath;
    }

    public String getCurrentContextPath() {
        return this.currentContextPath;
    }

    public boolean isSuperAdminOrHasAtLeastPermissionSetIdOn(DocumentPermissionSetTypeDomainObject documentPermissionSetType, DocumentDomainObject document) {
        return this.isSuperAdmin() || this.hasAtLeastPermissionSetIdOn(documentPermissionSetType, document);
    }

    public boolean canEditPermissionsFor(DocumentDomainObject document) {
        return this.getPermissionSetFor(document).getEditPermissions();
    }

    public boolean canSetDocumentPermissionSetTypeForRoleIdOnDocument(DocumentPermissionSetTypeDomainObject documentPermissionSetType, RoleId roleId, DocumentDomainObject document) {
        if (!this.canEditPermissionsFor(document)) {
            return false;
        }
        DocumentPermissionSetTypeDomainObject currentPermissionSetType = document.getDocumentPermissionSetTypeForRoleId(roleId);
        boolean userIsSuperAdminOrHasAtLeastTheCurrentPermissionSet = this.isSuperAdminOrHasAtLeastPermissionSetIdOn(currentPermissionSetType, document);
        boolean userIsSuperAdminOrHasAtLeastTheWantedPermissionSet = this.isSuperAdminOrHasAtLeastPermissionSetIdOn(documentPermissionSetType, document);
        boolean userHasAtLeastRestrictedOne = this.hasAtLeastRestrictedOnePermissionOn(document);
        boolean changingRestrictedTwo = DocumentPermissionSetTypeDomainObject.RESTRICTED_2.equals(documentPermissionSetType) || DocumentPermissionSetTypeDomainObject.RESTRICTED_2.equals(currentPermissionSetType);
        boolean canDefineRestrictedTwoForDocument = this.canDefineRestrictedTwoFor(document);
        return userIsSuperAdminOrHasAtLeastTheWantedPermissionSet && userIsSuperAdminOrHasAtLeastTheCurrentPermissionSet && (!changingRestrictedTwo || !userHasAtLeastRestrictedOne || canDefineRestrictedTwoForDocument);
    }

    public boolean canCreateDocumentOfTypeIdFromParent(int documentTypeId, DocumentDomainObject parent) {
        TextDocumentPermissionSetDomainObject documentPermissionSet = (TextDocumentPermissionSetDomainObject)this.getPermissionSetFor(parent);
        Set allowedDocumentTypeIds = documentPermissionSet.getAllowedDocumentTypeIds();
        return allowedDocumentTypeIds.contains(new Integer(documentTypeId));
    }

    public DocumentPermissionSetDomainObject getPermissionSetFor(DocumentDomainObject document) {
        DocumentPermissionSetTypeDomainObject permissionSetId = this.getDocumentPermissionSetTypeFor(document);
        if (DocumentPermissionSetTypeDomainObject.FULL.equals(permissionSetId)) {
            return DocumentPermissionSetDomainObject.FULL;
        }
        if (DocumentPermissionSetTypeDomainObject.READ.equals(permissionSetId)) {
            return DocumentPermissionSetDomainObject.READ;
        }
        if (DocumentPermissionSetTypeDomainObject.RESTRICTED_1.equals(permissionSetId)) {
            return document.getPermissionSets().getRestricted1();
        }
        if (DocumentPermissionSetTypeDomainObject.RESTRICTED_2.equals(permissionSetId)) {
            return document.getPermissionSets().getRestricted2();
        }
        return DocumentPermissionSetDomainObject.NONE;
    }

    public DocumentPermissionSetTypeDomainObject getDocumentPermissionSetTypeFor(DocumentDomainObject document) {
        RoleId roleId;
        DocumentPermissionSetTypeDomainObject documentPermissionSetType;
        if (null == document) {
            return DocumentPermissionSetTypeDomainObject.NONE;
        }
        if (this.isSuperAdmin()) {
            return DocumentPermissionSetTypeDomainObject.FULL;
        }
        RoleIdToDocumentPermissionSetTypeMappings roleIdsMappedToDocumentPermissionSetTypes = document.getRoleIdsMappedToDocumentPermissionSetTypes();
        RoleId[] usersRoleIds = this.getRoleIds();
        DocumentPermissionSetTypeDomainObject mostPrivilegedPermissionSetIdFoundYet = DocumentPermissionSetTypeDomainObject.NONE;
        for (int i = 0; !(i >= usersRoleIds.length || (documentPermissionSetType = roleIdsMappedToDocumentPermissionSetTypes.getPermissionSetTypeForRole(roleId = usersRoleIds[i])).isMorePrivilegedThan(mostPrivilegedPermissionSetIdFoundYet) && DocumentPermissionSetTypeDomainObject.FULL.equals(mostPrivilegedPermissionSetIdFoundYet = documentPermissionSetType)); ++i) {
        }
        return mostPrivilegedPermissionSetIdFoundYet;
    }

    public boolean hasAtLeastPermissionSetIdOn(DocumentPermissionSetTypeDomainObject leastPrivilegedPermissionSetIdWanted, DocumentDomainObject document) {
        DocumentPermissionSetTypeDomainObject usersDocumentPermissionSetType = this.getDocumentPermissionSetTypeFor(document);
        return usersDocumentPermissionSetType.isAtLeastAsPrivilegedAs(leastPrivilegedPermissionSetIdWanted);
    }

    public boolean canAddDocumentToAnyMenu(DocumentDomainObject document) {
        if (null == document) {
            return false;
        }
        boolean canEdit = this.canEdit(document);
        boolean linkableByOtherUsers = document.isLinkableByOtherUsers();
        return canEdit || linkableByOtherUsers;
    }

    public boolean canSearchFor(DocumentDomainObject document) {
        boolean canSearchForDocument = false;
        if (document.isSearchDisabled()) {
            if (this.isSuperAdmin()) {
                canSearchForDocument = true;
            }
        } else {
            canSearchForDocument = document.isPublished() ? document.isLinkedForUnauthorizedUsers() || this.canAccess(document) : this.canEdit(document);
        }
        return canSearchForDocument;
    }

    public boolean canEditDocumentInformationFor(DocumentDomainObject document) {
        return this.getPermissionSetFor(document).getEditDocumentInformation();
    }

    public boolean canAccessAdminPages() {
        RolePermissionDomainObject rolePermissionToAccessAdminPages = RoleDomainObject.ADMIN_PAGES_PERMISSION;
        return this.isSuperAdmin() || this.isUserAdminAndCanEditAtLeastOneRole() || this.hasRoleWithPermission(rolePermissionToAccessAdminPages);
    }

    public boolean hasRoleWithPermission(RolePermissionDomainObject rolePermission) {
        ImcmsAuthenticatorAndUserAndRoleMapper imcmsAuthenticatorAndUserAndRoleMapper = Imcms.getServices().getImcmsAuthenticatorAndUserAndRoleMapper();
        RoleId[] roleReferencesArray = this.roleIds.toArray();
        for (int i = 0; i < roleReferencesArray.length; ++i) {
            RoleId roleId = roleReferencesArray[i];
            if (!imcmsAuthenticatorAndUserAndRoleMapper.getRole(roleId).hasPermission(rolePermission)) continue;
            return true;
        }
        return false;
    }

    public boolean canSeeDocumentInMenus(DocumentDomainObject document) {
        return document.isActive() && this.canSeeDocumentWhenEditingMenus(document) && this.languageIsActive(document);
    }

    private boolean languageIsActive(DocumentDomainObject document) {
        I18nLanguage currentLanguage = I18nSupport.getCurrentLanguage();
        Meta meta = document.getMeta();
        I18nMeta i18nMeta = meta.getI18nMeta(currentLanguage);
        return i18nMeta.getEnabled() != false || meta.getUnavailableI18nDataSubstitution() == Meta.UnavailableI18nDataSubstitution.SHOW_IN_DEFAULT_LANGUAGE;
    }

    public boolean canSeeDocumentWhenEditingMenus(DocumentDomainObject document) {
        return document.isLinkedForUnauthorizedUsers() || this.canAccess(document);
    }

    public Set getPhoneNumbers() {
        return Collections.unmodifiableSet(this.phoneNumbers);
    }

    public RoleId[] getUserAdminRoleIds() {
        return this.userAdminRoleIds.toArray();
    }

    public void setUserAdminRolesIds(RoleId[] userAdminRoleReferences) {
        this.userAdminRoleIds = new RoleIds(userAdminRoleReferences);
    }

    public boolean isUserAdminAndNotSuperAdmin() {
        return this.isUserAdmin() && !this.isSuperAdmin();
    }

    public boolean canEditRolesFor(UserDomainObject editedUser) {
        return this.isSuperAdmin() || this.canEditAsUserAdmin(editedUser) && !this.equals(editedUser);
    }

    public void removeUserAdminRoleId(RoleId role) {
        this.userAdminRoleIds.remove(role);
    }

    public boolean canEdit(UserDomainObject editedUser) {
        return this.equals(editedUser) || this.isSuperAdmin() || this.canEditAsUserAdmin(editedUser);
    }

    public boolean canEditAsUserAdmin(UserDomainObject editedUser) {
        return this.isUserAdminAndNotSuperAdmin() && (editedUser.isNew() || this.canEditRolesAccordingToUserAdminRoles(editedUser));
    }

    public boolean canEditRolesAccordingToUserAdminRoles(UserDomainObject editedUser) {
        return CollectionUtils.containsAny((Collection)editedUser.roleIds.asSet(), (Collection)this.userAdminRoleIds.asSet());
    }

    public boolean isUserAdmin() {
        return this.hasRoleId(RoleId.USERADMIN);
    }

    public boolean isNew() {
        return 0 == this.id;
    }

    public DocumentShowSettings getDocumentShowSettings() {
        return this.documentShowSettings;
    }

    public void setDocumentShowSettings(DocumentShowSettings documentShowSettings) {
        this.documentShowSettings = documentShowSettings;
    }

    private static class PhoneNumberOfTypePredicate
    implements Predicate {
        private final PhoneNumberType phoneNumberType;

        PhoneNumberOfTypePredicate(PhoneNumberType phoneNumberType) {
            this.phoneNumberType = phoneNumberType;
        }

        public boolean evaluate(Object object) {
            PhoneNumber phoneNumber = (PhoneNumber)object;
            return phoneNumber.getType().equals(this.phoneNumberType);
        }
    }
}

