/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.user;

import com.imcode.net.ldap.LdapClient;
import com.imcode.net.ldap.LdapClientException;
import com.imcode.net.ldap.LdapConnection;
import imcode.server.user.Authenticator;
import imcode.server.user.UserAndRoleRegistry;
import imcode.server.user.UserDomainObject;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.naming.CommunicationException;
import javax.naming.directory.SearchControls;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapUserAndRoleRegistry
implements Authenticator,
UserAndRoleRegistry {
    private static final Logger LOG = Logger.getLogger(LdapUserAndRoleRegistry.class);
    public static final String DEFAULT_LDAP_ROLE = "LDAP";
    private static final String PERSON_SURNAME = "sn";
    private static final String PERSON_TELEPHONE_NUMBER = "telephoneNumber";
    private static final String ORGANIZATIONALPERSON_TITLE = "title";
    private static final String ORGANIZATIONALPERSON_STATE_OR_PROVINCE_NAME = "st";
    private static final String ORGANIZATIONALPERSON_POSTAL_CODE = "postalCode";
    private static final String ORGANIZATIONALPERSON_STREET_ADRESS = "streetAddress";
    private static final String INETORGPERSON_GIVEN_NAME = "givenName";
    private static final String INETORGPERSON_MAIL = "mail";
    private static final String INETORGPERSON_HOME_PHONE = "homePhone";
    private static final String INETORGPERSON_MOBILE = "mobile";
    private static final String INETORGPERSON_LOCALITY_NAME = "l";
    private static final String INETORGPERSON_ORGANIZATION = "o";
    static final String INETORGPERSON_USER_IDENTITY = "uid";
    private final LdapClient ldapClient;
    private LdapConnection ldapConnection;
    private final String ldapUserObjectClass;
    private final String[] ldapAttributesAutoMappedToRoles;
    private Properties userPropertyNameToLdapAttributeNameMap = new Properties();
    private static final Map DEFAULT_USER_PROPERTY_NAME_TO_LDAP_ATTRIBUTE_NAME_MAP = ArrayUtils.toMap((Object[])new String[][]{{"LoginName", "uid"}, {"FirstName", "givenName"}, {"LastName", "sn"}, {"Title", "title"}, {"Company", "o"}, {"Address", "streetAddress"}, {"City", "l"}, {"Zip", "postalCode"}, {"Province", "st"}, {"EmailAddress", "mail"}, {"WorkPhone", "telephoneNumber"}, {"MobilePhone", "mobile"}, {"HomePhone", "homePhone"}});
    private String ldapUsername;
    private String ldapPassword;
    private static final String LDAP_USER_OBJECTCLASS__INETORGPERSON = "inetOrgPerson";
    private static final String LDAP_USER_OBJECTCLASS_DEFAULT = "inetOrgPerson";

    public LdapUserAndRoleRegistry(Properties ldapConfig) throws LdapClientException {
        this(ldapConfig.getProperty("LdapUrl", "ldap://localhost/"), ldapConfig.getProperty("LdapUserObjectClass", "inetOrgPerson"), ldapConfig.getProperty("LdapBindDn", ""), ldapConfig.getProperty("LdapPassword", ""), LdapUserAndRoleRegistry.buildAttributesMappedToRoles(ldapConfig), LdapUserAndRoleRegistry.buildUserAttributes(ldapConfig));
    }

    private static String[] buildAttributesMappedToRoles(Properties ldapConfig) {
        String ldapStringOfAttributesMappedToRoles = ldapConfig.getProperty("LdapAttributesMappedToRoles", "");
        return LdapUserAndRoleRegistry.splitStringOnCommasAndSpaces(ldapStringOfAttributesMappedToRoles);
    }

    private static Properties buildUserAttributes(Properties ldapConfig) {
        Properties ldapUserAttributes = new Properties();
        ExtendedProperties ldapUserAttributesSubset = ExtendedProperties.convertProperties((Properties)ldapConfig).subset("LdapUserAttribute");
        if (null != ldapUserAttributesSubset) {
            ldapUserAttributes.putAll((Map<?, ?>)ldapUserAttributesSubset);
        }
        return ldapUserAttributes;
    }

    public LdapUserAndRoleRegistry(String ldapUrl, String ldapUserObjectClass, String ldapUserName, String ldapPassword, String[] ldapAttributesMappedToRoles, Properties ldapUserAttributes) throws LdapClientException {
        this.ldapAttributesAutoMappedToRoles = ldapAttributesMappedToRoles;
        this.initLdapUserAttributesMap(ldapUserAttributes);
        this.ldapUserObjectClass = ldapUserObjectClass;
        this.ldapClient = new LdapClient(ldapUrl);
        this.ldapUsername = ldapUserName;
        this.ldapPassword = ldapPassword;
        this.createLdapConnection();
    }

    private void createLdapConnection() throws LdapClientException {
        this.ldapConnection = this.ldapClient.bind(this.ldapUsername, this.ldapPassword);
    }

    @Override
    public String[] getAllRoleNames() {
        return new String[]{DEFAULT_LDAP_ROLE};
    }

    private void initLdapUserAttributesMap(Properties ldapUserAttributes) throws LdapClientException {
        this.userPropertyNameToLdapAttributeNameMap.putAll((Map<?, ?>)DEFAULT_USER_PROPERTY_NAME_TO_LDAP_ATTRIBUTE_NAME_MAP);
        this.userPropertyNameToLdapAttributeNameMap.putAll((Map<?, ?>)ldapUserAttributes);
        TreeSet<Object> badUserAttributes = new TreeSet<Object>(this.userPropertyNameToLdapAttributeNameMap.keySet());
        String[] capitalizedSettableUserPropertyNames = LdapUserAndRoleRegistry.getCapitalizedSettableBeanPropertyNames(UserDomainObject.class);
        badUserAttributes.removeAll(Arrays.asList(capitalizedSettableUserPropertyNames));
        if (!badUserAttributes.isEmpty()) {
            throw new LdapClientException("Unrecognized LdapUserAttributes: " + StringUtils.join(badUserAttributes.iterator(), (String)", "));
        }
    }

    @Override
    public boolean authenticate(String loginName, String password) {
        try {
            Map<String, String> userAttributes = this.searchForUserAttributes(loginName, new String[]{"dn"});
            if (null != userAttributes) {
                String userDistinguishedName = userAttributes.get("dn");
                return this.ldapClient.canBind(userDistinguishedName, password);
            }
        }
        catch (LdapClientException ex) {
            LOG.warn((Object)"Failed to get ldap context.", (Throwable)ex);
        }
        return false;
    }

    @Override
    public UserDomainObject getUser(String loginName) {
        UserDomainObject result = null;
        Map<String, String> attributeMap = this.searchForUserAttributes(loginName, null);
        if (null != attributeMap) {
            result = this.createUserFromLdapAttributes(attributeMap);
            result.setLoginName(loginName);
            result.setActive(true);
        }
        return result;
    }

    private UserDomainObject createUserFromLdapAttributes(Map<String, String> ldapAttributeValues) {
        UserDomainObject newlyFoundLdapUser = new UserDomainObject();
        PropertyDescriptor[] propertyDescriptors = PropertyUtils.getPropertyDescriptors((Object)newlyFoundLdapUser);
        try {
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                String ldapAttributeValue;
                String uncapitalizedPropertyName;
                String capitalizedPropertyName;
                String ldapAttributeName;
                if (null == propertyDescriptor.getWriteMethod() || null == (ldapAttributeName = this.userPropertyNameToLdapAttributeNameMap.getProperty(capitalizedPropertyName = StringUtils.capitalize((String)(uncapitalizedPropertyName = propertyDescriptor.getName())))) || null == (ldapAttributeValue = ldapAttributeValues.get(ldapAttributeName))) continue;
                BeanUtils.setProperty((Object)newlyFoundLdapUser, (String)uncapitalizedPropertyName, (Object)ldapAttributeValue);
            }
        }
        catch (IllegalAccessException e) {
            throw new UnhandledException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new UnhandledException((Throwable)e);
        }
        return newlyFoundLdapUser;
    }

    @Override
    public String[] getRoleNames(UserDomainObject user) {
        String loginName = user.getLoginName();
        Map<String, String> attributeMappedRoles = this.searchForUserAttributes(loginName, this.ldapAttributesAutoMappedToRoles);
        HashSet<String> roles = new HashSet<String>(attributeMappedRoles.values());
        roles.add(DEFAULT_LDAP_ROLE);
        return roles.toArray(new String[roles.size()]);
    }

    private Map<String, String> searchForUserAttributes(String loginName, String[] attributesToReturn) {
        Map attributeMap;
        block5: {
            attributeMap = null;
            try {
                String ldapUserIdentifyingAttribute = this.userPropertyNameToLdapAttributeNameMap.getProperty("LoginName");
                SearchControls searchControls = new SearchControls();
                searchControls.setSearchScope(2);
                searchControls.setReturningAttributes(attributesToReturn);
                searchControls.setReturningObjFlag(true);
                try {
                    attributeMap = this.ldapConnection.search("(&(objectClass={0})({1}={2}))", new Object[]{this.ldapUserObjectClass, ldapUserIdentifyingAttribute, loginName}, searchControls);
                }
                catch (LdapClientException e) {
                    if (e.getCause() instanceof CommunicationException) {
                        this.createLdapConnection();
                        attributeMap = this.ldapConnection.search("(&(objectClass={0})({1}={2}))", new Object[]{this.ldapUserObjectClass, ldapUserIdentifyingAttribute, loginName}, searchControls);
                        break block5;
                    }
                    throw e;
                }
            }
            catch (LdapClientException e) {
                LOG.warn((Object)("Could not find user " + loginName), (Throwable)e);
            }
        }
        return attributeMap;
    }

    private static String[] splitStringOnCommasAndSpaces(String stringToSplit) {
        StringTokenizer attributesTokenizer = new StringTokenizer(stringToSplit, ", ");
        String[] tokens = new String[attributesTokenizer.countTokens()];
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = attributesTokenizer.nextToken();
        }
        return tokens;
    }

    private static String[] getCapitalizedSettableBeanPropertyNames(Class beanClass) {
        PropertyDescriptor[] propertyDescriptors = PropertyUtils.getPropertyDescriptors((Class)beanClass);
        ArrayList<String> settableBeanPropertyNames = new ArrayList<String>();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (null == propertyDescriptor.getWriteMethod()) continue;
            String uncapitalizedPropertyName = propertyDescriptor.getName();
            String capitalizedPropertyName = StringUtils.capitalize((String)uncapitalizedPropertyName);
            settableBeanPropertyNames.add(capitalizedPropertyName);
        }
        return settableBeanPropertyNames.toArray(new String[settableBeanPropertyNames.size()]);
    }

    public void setUserPropertyLdapAttribute(String userPropertyName, String ldapAttribute) {
        this.userPropertyNameToLdapAttributeNameMap.put(userPropertyName, ldapAttribute);
    }
}

