/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document.textdocument;

import com.imcode.imcms.api.I18nLanguage;
import imcode.util.Parser;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@Entity(name="Text")
@Table(name="texts")
@NamedQueries(value={@NamedQuery(name="Text.getByDocumentIdAndDocumentVersionAndLanguageId", query="SELECT t FROM Text t WHERE t.metaId = :documentId AND t.metaVersion = :documentVersiob AND t.language.id = :languageId"), @NamedQuery(name="Text.getByDocumentIdAndDocumentVersionAndIndexAndLanguageId", query="SELECT t FROM Text t WHERE t.metaId = :documentId AND t.metaVersion = :documentVersion AND t.index = :index AND t.language.id = :languageId"), @NamedQuery(name="Text.getByDocumentIdAndDocumentVersion", query="SELECT t FROM Text t WHERE t.metaId = :documentId AND t.metaVersion = :documentVersion")})
public class TextDomainObject
implements Serializable,
Cloneable {
    public static final int TEXT_TYPE_PLAIN = 0;
    public static final int TEXT_TYPE_HTML = 1;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="counter")
    private Long id;
    @Column(name="meta_id")
    private Integer metaId;
    @Column(name="meta_version")
    private Integer metaVersion;
    @Column(name="name")
    Integer index;
    @Transient
    private boolean modified;
    String text;
    int type;
    @OneToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="language_id", referencedColumnName="language_id")
    private I18nLanguage language;

    protected TextDomainObject clone() {
        try {
            return (TextDomainObject)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public TextDomainObject() {
        this("");
    }

    public TextDomainObject(String text) {
        this(text, 0);
    }

    public TextDomainObject(String text, int type) {
        this.setText(text);
        this.setType(type);
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        switch (type) {
            case 0: 
            case 1: {
                this.type = type;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal text-type.");
            }
        }
    }

    public String toString() {
        return this.getText();
    }

    public String toHtmlString() {
        String result = this.getText();
        if (this.getType() == 0) {
            String[] vp = new String[]{"&", "&amp;", "<", "&lt;", ">", "&gt;", "\"", "&quot;", "\r\n", "\n", "\r", "\n", "\n", "<br />\n"};
            result = Parser.parseDoc(result, vp);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TextDomainObject)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        TextDomainObject o = (TextDomainObject)obj;
        return new EqualsBuilder().append((Object)this.text, (Object)o.getText()).append(this.type, o.getType()).append((Object)this.index, (Object)o.getIndex()).append((Object)this.language, (Object)o.getLanguage()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(33, 31).append((Object)this.text).append(this.type).append((Object)this.index).append((Object)this.language).toHashCode();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getMetaId() {
        return this.metaId;
    }

    public void setMetaId(Integer metaId) {
        this.metaId = metaId;
    }

    public I18nLanguage getLanguage() {
        return this.language;
    }

    public void setLanguage(I18nLanguage language) {
        this.language = language;
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public Integer getMetaVersion() {
        return this.metaVersion;
    }

    public void setMetaVersion(Integer metaVersion) {
        this.metaVersion = metaVersion;
    }
}

