/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document.textdocument;

import com.imcode.util.ChainableReversibleNullComparator;
import imcode.server.document.textdocument.MenuItemComparator;
import imcode.server.document.textdocument.MenuItemDomainObject;
import imcode.server.user.UserDomainObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Table;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.UnhandledException;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.MapKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity(name="Menu")
@Table(name="menus")
public class MenuDomainObject
implements Cloneable,
Serializable {
    public static final int MENU_SORT_ORDER__BY_HEADLINE = 1;
    public static final int MENU_SORT_ORDER__BY_MANUAL_ORDER_REVERSED = 2;
    public static final int MENU_SORT_ORDER__BY_MODIFIED_DATETIME_REVERSED = 3;
    public static final int MENU_SORT_ORDER__BY_MANUAL_TREE_ORDER = 4;
    public static final int MENU_SORT_ORDER__BY_PUBLISHED_DATETIME_REVERSED = 5;
    public static final int MENU_SORT_ORDER__DEFAULT = 1;
    public static final int DEFAULT_SORT_KEY = 500;
    private static final int DEFAULT_SORT_KEY_INCREMENT = 10;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="menu_id")
    private Long id;
    @Column(name="sort_order")
    private int sortOrder;
    @Column(name="menu_index")
    private Integer index;
    @Column(name="meta_id")
    private Integer metaId;
    @CollectionOfElements(fetch=FetchType.EAGER)
    @JoinTable(name="childs", joinColumns={@JoinColumn(name="menu_id")})
    @MapKey(columns={@Column(name="to_meta_id")})
    private Map<Integer, MenuItemDomainObject> menuItems = new HashMap<Integer, MenuItemDomainObject>();

    public MenuDomainObject() {
        this(null, 1);
    }

    public MenuDomainObject clone() {
        try {
            MenuDomainObject clone = (MenuDomainObject)super.clone();
            clone.menuItems = new HashMap<Integer, MenuItemDomainObject>();
            for (Map.Entry<Integer, MenuItemDomainObject> entry : this.menuItems.entrySet()) {
                Integer documentId = entry.getKey();
                MenuItemDomainObject menuItem = entry.getValue();
                clone.menuItems.put(documentId, (MenuItemDomainObject)menuItem.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    public MenuDomainObject(Long id, int sortOrder) {
        this.id = id;
        this.sortOrder = sortOrder;
        this.menuItems = new HashMap<Integer, MenuItemDomainObject>();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public int getSortOrder() {
        return this.sortOrder;
    }

    public MenuItemDomainObject[] getMenuItemsUserCanSee(UserDomainObject user) {
        List menuItemsUserCanSee = this.getMenuItemsVisibleToUser(user);
        return menuItemsUserCanSee.toArray(new MenuItemDomainObject[menuItemsUserCanSee.size()]);
    }

    List getMenuItemsVisibleToUser(UserDomainObject user) {
        MenuItemDomainObject[] menuItemsArray = this.getMenuItems();
        ArrayList<MenuItemDomainObject> menuItemsUserCanSee = new ArrayList<MenuItemDomainObject>(this.menuItems.size());
        for (int i = 0; i < menuItemsArray.length; ++i) {
            MenuItemDomainObject menuItem = menuItemsArray[i];
            if (!user.canSeeDocumentWhenEditingMenus(menuItem.getDocument())) continue;
            menuItemsUserCanSee.add(menuItem);
        }
        Collections.sort(menuItemsUserCanSee, this.getMenuItemComparatorForSortOrder(this.sortOrder));
        return menuItemsUserCanSee;
    }

    public MenuItemDomainObject[] getPublishedMenuItemsUserCanSee(UserDomainObject user) {
        List menuItems = this.getMenuItemsVisibleToUser(user);
        CollectionUtils.filter((Collection)menuItems, (Predicate)new Predicate(){

            public boolean evaluate(Object object) {
                return ((MenuItemDomainObject)object).getDocument().isActive();
            }
        });
        return menuItems.toArray(new MenuItemDomainObject[menuItems.size()]);
    }

    public MenuItemDomainObject[] getMenuItems() {
        Set menuItemsUnsorted = this.getMenuItemsUnsorted();
        MenuItemDomainObject[] menuItemsArray = menuItemsUnsorted.toArray(new MenuItemDomainObject[menuItemsUnsorted.size()]);
        Arrays.sort(menuItemsArray, this.getMenuItemComparatorForSortOrder(this.sortOrder));
        return menuItemsArray;
    }

    public Set getMenuItemsUnsorted() {
        HashSet<MenuItemDomainObject> set = new HashSet<MenuItemDomainObject>();
        for (MenuItemDomainObject menuItem : this.menuItems.values()) {
            if (null == menuItem.getDocument()) continue;
            set.add(menuItem);
        }
        return set;
    }

    public void addMenuItem(MenuItemDomainObject menuItem) {
        if (null == menuItem.getSortKey()) {
            this.generateSortKey(menuItem);
        }
        if (null != menuItem.getDocument()) {
            this.addMenuItemUnchecked(menuItem);
        }
    }

    public void addMenuItemUnchecked(MenuItemDomainObject menuItem) {
        this.menuItems.put(new Integer(menuItem.getDocumentId()), menuItem);
    }

    private void generateSortKey(MenuItemDomainObject menuItem) {
        Integer maxSortKey = this.getMaxSortKey();
        Integer sortKey = null != maxSortKey ? new Integer(maxSortKey + 10) : new Integer(500);
        menuItem.setSortKey(sortKey);
    }

    private Integer getMaxSortKey() {
        Collection menuItemSortKeys = CollectionUtils.collect(this.menuItems.values(), (Transformer)new Transformer(){

            public Object transform(Object o) {
                return ((MenuItemDomainObject)o).getSortKey();
            }
        });
        if (menuItemSortKeys.isEmpty()) {
            return null;
        }
        return (Integer)Collections.max(menuItemSortKeys);
    }

    private Comparator getMenuItemComparatorForSortOrder(int sortOrder) {
        ChainableReversibleNullComparator comparator = MenuItemComparator.HEADLINE.chain((Comparator)((Object)MenuItemComparator.ID));
        if (sortOrder == 4) {
            comparator = MenuItemComparator.TREE_SORT_KEY.chain((Comparator)comparator);
        } else if (sortOrder == 2) {
            comparator = MenuItemComparator.SORT_KEY.reversed().chain((Comparator)comparator);
        } else if (sortOrder == 3) {
            comparator = MenuItemComparator.MODIFIED_DATETIME.reversed().chain((Comparator)comparator);
        } else if (sortOrder == 5) {
            comparator = MenuItemComparator.PUBLISHED_DATETIME.reversed().chain((Comparator)comparator);
        }
        return comparator;
    }

    public void setSortOrder(int sortOrder) {
        switch (sortOrder) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.sortOrder = sortOrder;
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad sort order. Use one of the constants.");
            }
        }
    }

    public void removeMenuItemByDocumentId(int childId) {
        this.menuItems.remove(new Integer(childId));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MenuDomainObject)) {
            return false;
        }
        MenuDomainObject otherMenu = (MenuDomainObject)obj;
        return new EqualsBuilder().append(this.sortOrder, otherMenu.sortOrder).append(this.menuItems, otherMenu.menuItems).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.sortOrder).append(this.menuItems).toHashCode();
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }

    public Integer getMetaId() {
        return this.metaId;
    }

    public void setMetaId(Integer metaId) {
        this.metaId = metaId;
    }

    public Map<Integer, MenuItemDomainObject> getItemsMap() {
        return this.menuItems;
    }
}

