/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document.textdocument;

import com.imcode.imcms.api.I18nLanguage;
import com.imcode.util.ImageSize;
import imcode.server.document.textdocument.ImageSource;
import imcode.server.document.textdocument.NullImageSource;
import java.io.IOException;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

@Entity(name="Image")
@Table(name="images")
@NamedQueries(value={@NamedQuery(name="Image.getByLanguageId", query="select i from Image i where i.metaId = :metaId and i.language.id = :languageId"), @NamedQuery(name="Image.getLanguagesToImagesByMetaId", query="select l, i from Image i right join i.language l where (i.metaId = :metaId and i.name = :name) or i.metaId is null order by l.default desc"), @NamedQuery(name="Image.getAllImages", query="select i from Image i where i.metaId = :metaId"), @NamedQuery(name="Image.getAllDocumentImagesByLanguage", query="select i from Image i where i.metaId = :metaId and i.language.id = :languageId"), @NamedQuery(name="Image.getDefaultImage", query="select i from Image i where i.metaId = :metaId and i.name = :name and i.language.default is true"), @NamedQuery(name="Image.getByDocumentIdAndDocumentVersion", query="SELECT i FROM Image i WHERE i.metaId = :documentId AND i.metaVersion = :documentVersion")})
public class ImageDomainObject
implements Serializable,
Cloneable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="image_id")
    private Long id;
    @Transient
    private ImageSource source = new NullImageSource();
    @Column(name="meta_id")
    private Integer metaId;
    @Column(name="meta_version")
    private Integer metaVersion;
    private String name = "";
    private int width;
    private int height;
    private int border;
    private String align = "";
    @Column(name="alt_text")
    private String alternateText = "";
    @Column(name="low_scr")
    private String lowResolutionUrl = "";
    @Column(name="v_space")
    private int verticalSpace;
    @Column(name="h_space")
    private int horizontalSpace;
    private String target = "";
    @Column(name="linkurl")
    private String linkUrl = "";
    @Column(name="imgurl")
    private String imageUrl = "";
    private Integer type;
    @Transient
    private boolean modified;
    @OneToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="language_id", referencedColumnName="language_id")
    private I18nLanguage language;

    public String getName() {
        return this.name;
    }

    public ImageSize getDisplayImageSize() {
        ImageSize realImageSize = this.getRealImageSize();
        int wantedWidth = this.getWidth();
        int wantedHeight = this.getHeight();
        if (0 == wantedWidth && 0 != wantedHeight && 0 != realImageSize.getHeight()) {
            wantedWidth = (int)((double)realImageSize.getWidth() * ((double)wantedHeight / (double)realImageSize.getHeight()));
        } else if (0 == wantedHeight && 0 != wantedWidth && 0 != realImageSize.getWidth()) {
            wantedHeight = (int)((double)realImageSize.getHeight() * ((double)wantedWidth / (double)realImageSize.getWidth()));
        } else if (0 == wantedWidth && 0 == wantedHeight) {
            wantedWidth = realImageSize.getWidth();
            wantedHeight = realImageSize.getHeight();
        }
        return new ImageSize(wantedWidth, wantedHeight);
    }

    public ImageSize getRealImageSize() {
        ImageSize imageSize = new ImageSize(0, 0);
        if (!this.isEmpty()) {
            try {
                imageSize = this.source.getImageSize();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return imageSize;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getBorder() {
        return this.border;
    }

    public String getAlign() {
        return this.align;
    }

    public String getAlternateText() {
        return this.alternateText;
    }

    public String getLowResolutionUrl() {
        return this.lowResolutionUrl;
    }

    public int getVerticalSpace() {
        return this.verticalSpace;
    }

    public int getHorizontalSpace() {
        return this.horizontalSpace;
    }

    public String getTarget() {
        return this.target;
    }

    public String getLinkUrl() {
        return this.linkUrl;
    }

    public void setName(String image_name) {
        this.name = image_name;
    }

    public void setWidth(int image_width) {
        this.width = image_width;
    }

    public void setHeight(int image_height) {
        this.height = image_height;
    }

    public void setBorder(int image_border) {
        this.border = image_border;
    }

    public void setAlign(String image_align) {
        this.align = image_align;
    }

    public void setAlternateText(String alt_text) {
        this.alternateText = alt_text;
    }

    public void setLowResolutionUrl(String low_scr) {
        this.lowResolutionUrl = low_scr;
    }

    public void setVerticalSpace(int v_space) {
        this.verticalSpace = v_space;
    }

    public void setHorizontalSpace(int h_space) {
        this.horizontalSpace = h_space;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setLinkUrl(String image_ref_link) {
        this.linkUrl = image_ref_link;
    }

    public void setSourceAndClearSize(ImageSource source) {
        this.setSource(source);
        this.setWidth(0);
        this.setHeight(0);
    }

    public void setSource(ImageSource source) {
        if (null == source) {
            throw new NullArgumentException("source");
        }
        this.source = source;
    }

    public boolean isEmpty() {
        return this.source.isEmpty();
    }

    public String getUrlPath(String contextPath) {
        String urlPathRelativeToContextPath = this.getUrlPathRelativeToContextPath();
        if (StringUtils.isBlank((String)urlPathRelativeToContextPath)) {
            return "";
        }
        return contextPath + urlPathRelativeToContextPath;
    }

    public String getUrlPathRelativeToContextPath() {
        return this.source.getUrlPathRelativeToContextPath();
    }

    public long getSize() {
        if (this.isEmpty()) {
            return 0L;
        }
        try {
            return this.source.getInputStreamSource().getSize();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public ImageSource getSource() {
        if (this.isEmpty()) {
            return new NullImageSource();
        }
        return this.source;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ImageDomainObject)) {
            return false;
        }
        ImageDomainObject o = (ImageDomainObject)obj;
        return new EqualsBuilder().append((Object)this.source.toStorageString(), (Object)o.getSource().toStorageString()).append((Object)this.name, (Object)o.getName()).append(this.width, o.getWidth()).append(this.height, o.getHeight()).append(this.border, o.getBorder()).append((Object)this.align, (Object)o.getAlign()).append((Object)this.alternateText, (Object)o.getAlternateText()).append((Object)this.lowResolutionUrl, (Object)o.getLowResolutionUrl()).append(this.verticalSpace, o.getVerticalSpace()).append(this.horizontalSpace, o.getHorizontalSpace()).append((Object)this.target, (Object)o.getTarget()).append((Object)this.linkUrl, (Object)o.getLinkUrl()).append((Object)this.language, (Object)o.getLanguage()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.source.toStorageString()).append((Object)this.name).append(this.width).append(this.height).append(this.border).append((Object)this.align).append((Object)this.alternateText).append((Object)this.lowResolutionUrl).append(this.verticalSpace).append(this.horizontalSpace).append((Object)this.target).append((Object)this.linkUrl).append((Object)this.language).toHashCode();
    }

    public I18nLanguage getLanguage() {
        return this.language;
    }

    public void setLanguage(I18nLanguage language) {
        this.language = language;
    }

    public Integer getMetaId() {
        return this.metaId;
    }

    public void setMetaId(Integer metaId) {
        this.metaId = metaId;
    }

    public ImageDomainObject clone() {
        try {
            return (ImageDomainObject)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String getImageUrl() {
        return this.imageUrl;
    }

    public void setImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Integer getIndex() {
        return this.name == null ? null : new Integer(this.name);
    }

    public void setIndex(Integer index) {
        this.name = index == null ? null : index.toString();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public Integer getMetaVersion() {
        return this.metaVersion;
    }

    public void setMetaVersion(Integer metaVersion) {
        this.metaVersion = metaVersion;
    }
}

