/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document;

import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.I18nException;
import com.imcode.imcms.api.I18nLanguage;
import com.imcode.imcms.api.I18nMeta;
import com.imcode.imcms.api.I18nSupport;
import com.imcode.imcms.api.Meta;
import com.imcode.imcms.util.l10n.LocalizedMessage;
import imcode.server.document.DocumentPermissionSetTypeDomainObject;
import imcode.server.document.DocumentPermissionSets;
import imcode.server.document.DocumentTypeDomainObject;
import imcode.server.document.DocumentVisitor;
import imcode.server.document.FileDocumentDomainObject;
import imcode.server.document.HtmlDocumentDomainObject;
import imcode.server.document.LifeCyclePhase;
import imcode.server.document.RoleIdToDocumentPermissionSetTypeMappings;
import imcode.server.document.UrlDocumentDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.RoleId;
import imcode.server.user.UserDomainObject;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DocumentDomainObject
implements Cloneable,
Serializable {
    public static final int ID_NEW = 0;
    public static final String DOCUMENT_PROPERTIES__IMCMS_DOCUMENT_ALIAS = "imcms.document.alias";
    protected Attributes attributes = new Attributes();
    private static Logger log = Logger.getLogger(DocumentDomainObject.class);
    private Meta meta = new Meta();

    public DocumentDomainObject clone() {
        DocumentDomainObject clone;
        try {
            clone = (DocumentDomainObject)super.clone();
            if (null != this.attributes) {
                clone.attributes = (Attributes)this.attributes.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        if (clone.meta != null) {
            clone.meta = this.meta.clone();
        }
        return clone;
    }

    public static DocumentDomainObject fromDocumentTypeId(int documentTypeId) {
        DocumentDomainObject document;
        switch (documentTypeId) {
            case 2: {
                document = new TextDocumentDomainObject();
                break;
            }
            case 5: {
                document = new UrlDocumentDomainObject();
                break;
            }
            case 8: {
                document = new FileDocumentDomainObject();
                break;
            }
            case 7: {
                document = new HtmlDocumentDomainObject();
                break;
            }
            default: {
                String errorMessage = "Unknown document-type-id: " + documentTypeId;
                log.error((Object)errorMessage);
                throw new IllegalArgumentException(errorMessage);
            }
        }
        return document;
    }

    public Date getArchivedDatetime() {
        return this.meta.getArchivedDatetime();
    }

    public void setArchivedDatetime(Date v) {
        this.meta.setArchivedDatetime(v);
    }

    public Set<Integer> getCategoryIds() {
        return Collections.unmodifiableSet(this.meta.getCategoryIds());
    }

    public Date getCreatedDatetime() {
        return this.meta.getCreatedDatetime();
    }

    public void setCreatedDatetime(Date v) {
        this.meta.setCreatedDatetime(v);
    }

    public int getCreatorId() {
        return this.meta.getCreatorId();
    }

    public void setCreatorId(int creatorId) {
        this.meta.setCreatorId(creatorId);
    }

    public void setCreator(UserDomainObject creator) {
        this.setCreatorId(creator.getId());
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    @Deprecated
    public String getHeadline() {
        return this.getHeadline(I18nSupport.getCurrentLanguage());
    }

    public String getHeadline(I18nLanguage language) {
        return this.getI18nMeta(language).getHeadline();
    }

    @Deprecated
    public void setHeadline(String v) {
        this.setHeadline(I18nSupport.getCurrentLanguage(), v);
    }

    public void setHeadline(I18nLanguage language, String v) {
        this.getI18nMeta(language).setHeadline(v);
    }

    public int getId() {
        Integer id = this.meta.getId();
        return id == null ? 0 : id;
    }

    public void setId(int v) {
        this.meta.setId(v);
    }

    @Deprecated
    public String getMenuImage() {
        return this.getMenuImage(I18nSupport.getCurrentLanguage());
    }

    public String getMenuImage(I18nLanguage language) {
        return this.getI18nMeta(language).getMenuImageURL();
    }

    public void setMenuImage(I18nLanguage language, String v) {
        this.getI18nMeta(language).setMenuImageURL(v);
    }

    @Deprecated
    public Set getKeywords() {
        return this.getKeywords(I18nSupport.getCurrentLanguage());
    }

    @Deprecated
    public Set getKeywords(I18nLanguage language) {
        return this.getI18nMeta(language).getKeywords();
    }

    @Deprecated
    public void setKeywords(I18nLanguage language, Set keywords) {
        this.getI18nMeta(language).setKeywords(keywords);
    }

    public void setProperties(Map properties) {
        this.meta.setProperties(properties);
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.meta.getProperties());
    }

    public String getProperty(String key) {
        Map<String, String> properties = this.meta.getProperties();
        return properties.get(key);
    }

    public void setProperty(String key, String value) {
        Map<String, String> properties = this.meta.getProperties();
        properties.put(key, value);
    }

    public void removeProperty(String key) {
        Map<String, String> properties = this.meta.getProperties();
        properties.remove(key);
    }

    @Deprecated
    public String getMenuText() {
        return this.getMenuText(I18nSupport.getCurrentLanguage());
    }

    @Deprecated
    public void setMenuText(String v) {
        this.setMenuText(I18nSupport.getCurrentLanguage(), v);
    }

    public String getMenuText(I18nLanguage language) {
        return this.getI18nMeta(language).getMenuText();
    }

    public void setMenuText(I18nLanguage language, String v) {
        this.getI18nMeta(language).setMenuText(v);
    }

    public Date getModifiedDatetime() {
        return this.meta.getModifiedDatetime();
    }

    public void setModifiedDatetime(Date v) {
        this.meta.setModifiedDatetime(v);
    }

    public void setActualModifiedDatetime(Date modifiedDatetime) {
        this.meta.setActualModifiedDatetime(modifiedDatetime);
    }

    public Date getActualModifiedDatetime() {
        return this.meta.getActualModifiedDatetime();
    }

    public Date getPublicationEndDatetime() {
        return this.meta.getPublicationEndDatetime();
    }

    public void setPublicationEndDatetime(Date datetime) {
        this.meta.setPublicationEndDatetime(datetime);
    }

    public Date getPublicationStartDatetime() {
        return this.meta.getPublicationStartDatetime();
    }

    public void setPublicationStartDatetime(Date v) {
        this.meta.setPublicationStartDatetime(v);
    }

    public Integer getPublisherId() {
        return this.meta.getPublisherId();
    }

    public void setPublisher(UserDomainObject user) {
        this.setPublisherId(user.getId());
    }

    public void setPublisherId(Integer publisherId) {
        this.meta.setPublisherId(publisherId);
    }

    public RoleIdToDocumentPermissionSetTypeMappings getRoleIdsMappedToDocumentPermissionSetTypes() {
        return this.getRolePermissionMappings().clone();
    }

    private RoleIdToDocumentPermissionSetTypeMappings getRolePermissionMappings() {
        return this.attributes.roleIdToDocumentPermissionSetTypeMappings;
    }

    public void setRoleIdsMappedToDocumentPermissionSetTypes(RoleIdToDocumentPermissionSetTypeMappings roleIdToDocumentPermissionSetTypeMappings) {
        this.attributes.roleIdToDocumentPermissionSetTypeMappings = roleIdToDocumentPermissionSetTypeMappings.clone();
    }

    public Set getSectionIds() {
        return Collections.unmodifiableSet(this.meta.getSectionIds());
    }

    public void setSectionIds(Set sectionIds) {
        this.meta.setSectionIds(sectionIds);
    }

    public Document.PublicationStatus getPublicationStatus() {
        return this.attributes.publicationStatus;
    }

    public void setPublicationStatus(Document.PublicationStatus status) {
        if (null == status) {
            throw new NullArgumentException("status");
        }
        this.attributes.publicationStatus = status;
    }

    public String getTarget() {
        return this.meta.getTarget();
    }

    public void setTarget(String v) {
        this.meta.setTarget(v);
    }

    public boolean isArchived() {
        return this.hasBeenArchivedAtTime(new Date());
    }

    public boolean isLinkableByOtherUsers() {
        return this.meta.getLinkableByOtherUsers();
    }

    public void setLinkableByOtherUsers(boolean linkableByOtherUsers) {
        this.meta.setLinkableByOtherUsers(linkableByOtherUsers);
    }

    public boolean isRestrictedOneMorePrivilegedThanRestrictedTwo() {
        return this.meta.getRestrictedOneMorePrivilegedThanRestrictedTwo();
    }

    public void setRestrictedOneMorePrivilegedThanRestrictedTwo(boolean b) {
        this.meta.setRestrictedOneMorePrivilegedThanRestrictedTwo(b);
    }

    public boolean isPublished() {
        return this.isPublishedAtTime(new Date());
    }

    public boolean isActive() {
        return this.isActiveAtTime(new Date());
    }

    private boolean isActiveAtTime(Date now) {
        return this.isPublishedAtTime(now) && !this.hasBeenArchivedAtTime(now);
    }

    public boolean isSearchDisabled() {
        return this.meta.getSearchDisabled();
    }

    public void setSearchDisabled(boolean searchDisabled) {
        this.meta.setSearchDisabled(searchDisabled);
    }

    public boolean isLinkedForUnauthorizedUsers() {
        return this.meta.getLinkedForUnauthorizedUsers();
    }

    public void setLinkedForUnauthorizedUsers(boolean linkedForUnauthorizedUsers) {
        this.meta.setLinkedForUnauthorizedUsers(linkedForUnauthorizedUsers);
    }

    public void addCategoryId(int categoryId) {
        Set<Integer> categoryIds = this.meta.getCategoryIds();
        categoryIds.add(categoryId);
    }

    public void addSectionId(int sectionId) {
        Set<Integer> sectionIds = this.meta.getSectionIds();
        sectionIds.add(sectionId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentDomainObject)) {
            return false;
        }
        DocumentDomainObject document = (DocumentDomainObject)o;
        return this.getId() == document.getId();
    }

    public abstract DocumentTypeDomainObject getDocumentType();

    public final int getDocumentTypeId() {
        return this.getDocumentType().getId();
    }

    public final LocalizedMessage getDocumentTypeName() {
        return this.getDocumentType().getName();
    }

    public int hashCode() {
        return this.getId();
    }

    private boolean hasBeenArchivedAtTime(Date time) {
        Date archivedDatetime = this.meta.getArchivedDatetime();
        return archivedDatetime != null && archivedDatetime.before(time);
    }

    public void removeAllCategories() {
        this.meta.setCategoryIds(new HashSet<Integer>());
    }

    public void removeAllSections() {
        this.meta.setSectionIds(new HashSet<Integer>());
    }

    public void removeCategoryId(int categoryId) {
        Set<Integer> categoryIds = this.meta.getCategoryIds();
        categoryIds.remove(categoryId);
    }

    public void setDocumentPermissionSetTypeForRoleId(RoleId roleId, DocumentPermissionSetTypeDomainObject permissionSetType) {
        this.getRolePermissionMappings().setPermissionSetTypeForRole(roleId, permissionSetType);
    }

    public DocumentPermissionSetTypeDomainObject getDocumentPermissionSetTypeForRoleId(RoleId roleId) {
        return this.getRolePermissionMappings().getPermissionSetTypeForRole(roleId);
    }

    private boolean isPublishedAtTime(Date date) {
        boolean statusIsApproved = Document.PublicationStatus.APPROVED.equals(this.getPublicationStatus());
        return statusIsApproved && this.publicationHasStartedAtTime(date) && !this.publicationHasEndedAtTime(date);
    }

    private boolean publicationHasStartedAtTime(Date date) {
        Date publicationStartDatetime = this.meta.getPublicationStartDatetime();
        return publicationStartDatetime != null && publicationStartDatetime.before(date);
    }

    private boolean publicationHasEndedAtTime(Date date) {
        Date publicationEndDatetime = this.meta.getPublicationEndDatetime();
        return publicationEndDatetime != null && publicationEndDatetime.before(date);
    }

    public DocumentPermissionSets getPermissionSets() {
        return this.attributes.permissionSets;
    }

    public DocumentPermissionSets getPermissionSetsForNewDocuments() {
        return this.attributes.permissionSetsForNewDocuments;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public abstract void accept(DocumentVisitor var1);

    public LifeCyclePhase getLifeCyclePhase() {
        return this.getLifeCyclePhaseAtTime(new Date());
    }

    LifeCyclePhase getLifeCyclePhaseAtTime(Date time) {
        Document.PublicationStatus publicationStatus = this.getPublicationStatus();
        LifeCyclePhase lifeCyclePhase = Document.PublicationStatus.NEW.equals(publicationStatus) ? LifeCyclePhase.NEW : (Document.PublicationStatus.DISAPPROVED.equals(publicationStatus) ? LifeCyclePhase.DISAPPROVED : (this.publicationHasEndedAtTime(time) ? LifeCyclePhase.UNPUBLISHED : (this.publicationHasStartedAtTime(time) ? (this.hasBeenArchivedAtTime(time) ? LifeCyclePhase.ARCHIVED : LifeCyclePhase.PUBLISHED) : LifeCyclePhase.APPROVED)));
        return lifeCyclePhase;
    }

    public void setCategoryIds(Set categoryIds) {
        this.meta.setCategoryIds(categoryIds);
    }

    public void setPermissionSets(DocumentPermissionSets permissionSets) {
        this.attributes.permissionSets = permissionSets;
    }

    public void setPermissionSetsForNew(DocumentPermissionSets permissionSetsForNew) {
        this.attributes.permissionSetsForNewDocuments = permissionSetsForNew;
    }

    public String getAlias() {
        return this.getProperty(DOCUMENT_PROPERTIES__IMCMS_DOCUMENT_ALIAS);
    }

    public void setAlias(String alias) {
        if (alias == null) {
            this.removeProperty(DOCUMENT_PROPERTIES__IMCMS_DOCUMENT_ALIAS);
        } else {
            this.setProperty(DOCUMENT_PROPERTIES__IMCMS_DOCUMENT_ALIAS, alias);
        }
    }

    public String getName() {
        return StringUtils.defaultString((String)this.getAlias(), (String)(this.getId() + ""));
    }

    public Meta getMeta() {
        return this.meta;
    }

    public void setMeta(Meta meta) {
        if (meta == null) {
            throw new NullPointerException("Meta argument can not be null.");
        }
        this.meta = meta.clone();
    }

    public I18nMeta getI18nMeta(I18nLanguage language) {
        I18nMeta i18nMeta = this.meta.getI18nMeta(language);
        if (i18nMeta == null) {
            throw new I18nException("No I18nMeta found for document [" + this.getId() + "], language [" + language + "].");
        }
        return i18nMeta;
    }

    public void setDependenciesMetaIdToNull() {
        this.meta.setId(null);
        Set<I18nMeta> i18nMetas = this.meta.getI18nMetas();
        if (i18nMetas != null) {
            for (I18nMeta i18nMeta : i18nMetas) {
                i18nMeta.setId(null);
                i18nMeta.setMetaId(null);
            }
        }
    }

    public static class Attributes
    implements Cloneable,
    Serializable {
        private Document.PublicationStatus publicationStatus = Document.PublicationStatus.NEW;
        private DocumentPermissionSets permissionSets = new DocumentPermissionSets();
        private DocumentPermissionSets permissionSetsForNewDocuments = new DocumentPermissionSets();
        private RoleIdToDocumentPermissionSetTypeMappings roleIdToDocumentPermissionSetTypeMappings = new RoleIdToDocumentPermissionSetTypeMappings();

        public Object clone() throws CloneNotSupportedException {
            Attributes clone = (Attributes)super.clone();
            clone.roleIdToDocumentPermissionSetTypeMappings = this.roleIdToDocumentPermissionSetTypeMappings.clone();
            clone.permissionSets = this.permissionSets.clone();
            clone.permissionSetsForNewDocuments = this.permissionSetsForNewDocuments.clone();
            return clone;
        }
    }
}

