/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.util.l10n;

import com.imcode.imcms.util.l10n.LocalizedMessageProvider;
import imcode.server.Imcms;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.lang.StringUtils;

public class LocalizedMessage
implements Serializable {
    private final String languageKey;
    private final LocalizedMessageProvider provider;

    public LocalizedMessage(String languageKey) {
        this(languageKey, null);
    }

    LocalizedMessage(String languageKey, LocalizedMessageProvider provider) {
        if (null == languageKey) {
            throw new NullArgumentException("languageKey");
        }
        this.provider = provider;
        this.languageKey = languageKey;
    }

    public final String toLocalizedString(HttpServletRequest request) {
        UserDomainObject user = Utility.getLoggedOnUser(request);
        return this.toLocalizedString(user);
    }

    public final String toLocalizedString(UserDomainObject user) {
        return this.toLocalizedString(user.getLanguageIso639_2());
    }

    public String toLocalizedString(String languageIso639_2) {
        LocalizedMessageProvider localProvider = this.provider;
        if (null == localProvider) {
            localProvider = Imcms.getServices().getLocalizedMessageProvider();
        }
        return StringUtils.defaultString((String)localProvider.getResourceBundle(languageIso639_2).getString(this.languageKey));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalizedMessage that = (LocalizedMessage)o;
        if (!this.languageKey.equals(that.languageKey)) {
            return false;
        }
        return !(this.provider == null ? that.provider != null : !this.provider.equals(that.provider));
    }

    public int hashCode() {
        int result = this.languageKey.hashCode();
        result = 29 * result + (this.provider != null ? this.provider.hashCode() : 0);
        return result;
    }
}

