/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.superadmin;

import com.imcode.db.Database;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.commands.SqlQueryDatabaseCommand;
import com.imcode.db.handlers.CollectionHandler;
import com.imcode.db.handlers.RowTransformer;
import imcode.server.Imcms;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminSearchTerms
extends HttpServlet {
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        UserDomainObject user = Utility.getLoggedOnUser(request);
        if (!user.isSuperAdmin()) {
            Utility.forwardToLogin(request, response);
            return;
        }
        this.doView(null, null, false, request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        UserDomainObject user = Utility.getLoggedOnUser(request);
        if (!user.isSuperAdmin()) {
            Utility.forwardToLogin(request, response);
            return;
        }
        if (null != request.getParameter("cancel")) {
            response.sendRedirect(request.getContextPath() + "/servlet/AdminManager");
            return;
        }
        Date fromDate = this.getDateParameter(request, "from_date");
        Date toDate = Utility.addDate(this.getDateParameter(request, "to_date"), 1);
        this.doView(fromDate, toDate, true, request, response);
    }

    private Date getDateParameter(HttpServletRequest request, String parameterName) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String parameterValue = request.getParameter(parameterName);
        Date date = null;
        try {
            date = dateFormat.parse(parameterValue);
        }
        catch (ParseException e) {
            // empty catch block
        }
        return date;
    }

    private List<TermCount> getTermCounts(Date fromDate, Date toDate) {
        Database database = Imcms.getServices().getDatabase();
        ArrayList<String> whereClauses = new ArrayList<String>();
        ArrayList<Timestamp> parameters = new ArrayList<Timestamp>();
        if (null != fromDate) {
            whereClauses.add("datetime >= ?");
            parameters.add(new Timestamp(fromDate.getTime()));
        }
        if (null != toDate) {
            whereClauses.add("datetime < ?");
            parameters.add(new Timestamp(toDate.getTime()));
        }
        String whereClausesString = whereClauses.isEmpty() ? "" : " WHERE " + StringUtils.join(whereClauses.iterator(), (String)" AND ");
        SqlQueryDatabaseCommand queryCommand = new SqlQueryDatabaseCommand("SELECT term, COUNT(term) c FROM document_search_log" + whereClausesString + " GROUP BY term ORDER BY c DESC, term", parameters.toArray(new Object[parameters.size()]), (ResultSetHandler)new CollectionHandler(new ArrayList(), (RowTransformer)new TermCountFactory()));
        return (List)database.execute((DatabaseCommand)queryCommand);
    }

    private void doView(Date fromDate, Date toDate, boolean search, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (search) {
            request.setAttribute("fromDate", (Object)fromDate);
            request.setAttribute("toDate", (Object)Utility.addDate(toDate, -1));
            request.setAttribute("termCounts", this.getTermCounts(fromDate, toDate));
        }
        request.getRequestDispatcher("/WEB-INF/jsp/imcms/document_search_terms.jsp").forward((ServletRequest)request, (ServletResponse)response);
    }

    private static class TermCountFactory
    implements RowTransformer {
        private TermCountFactory() {
        }

        public Object createObjectFromResultSetRow(ResultSet resultSet) throws SQLException {
            return new TermCount(resultSet.getString(1), resultSet.getInt(2));
        }

        public Class getClassOfCreatedObjects() {
            return TermCount.class;
        }
    }

    public static class TermCount {
        private String term;
        private int count;

        public TermCount(String term, int count) {
            this.term = term;
            this.count = count;
        }

        public int getCount() {
            return this.count;
        }

        public String getTerm() {
            return this.term;
        }
    }
}

