/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.admin;

import com.imcode.imcms.api.I18nSupport;
import com.imcode.imcms.dao.ImageDao;
import com.imcode.imcms.flow.DispatchCommand;
import com.imcode.imcms.mapping.DocumentMapper;
import com.imcode.imcms.mapping.DocumentSaveException;
import com.imcode.imcms.servlet.admin.Handler;
import com.imcode.imcms.servlet.admin.ImageEditPage;
import com.imcode.imcms.util.l10n.LocalizedMessageFormat;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.ConcurrentDocumentModificationException;
import imcode.server.document.NoPermissionToEditDocumentException;
import imcode.server.document.textdocument.ImageDomainObject;
import imcode.server.document.textdocument.NoPermissionToAddDocumentToMenuException;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.ShouldHaveCheckedPermissionsEarlierException;
import imcode.util.ShouldNotBeThrownException;
import imcode.util.Utility;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class ChangeImage
extends HttpServlet {
    public static final String REQUEST_PARAMETER__IMAGE_INDEX = "img";
    public static final String REQUEST_PARAMETER__LABEL = "label";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ImageDomainObject image;
        ImcmsServices imcref = Imcms.getServices();
        final UserDomainObject user = Utility.getLoggedOnUser(request);
        DocumentMapper documentMapper = imcref.getDocumentMapper();
        Integer documentId = Integer.parseInt(request.getParameter("meta_id"));
        final TextDocumentDomainObject document = (TextDocumentDomainObject)documentMapper.getDocument(documentId, user.getDocumentShowSettings().getVersionSelector());
        final int imageIndex = Integer.parseInt(request.getParameter(REQUEST_PARAMETER__IMAGE_INDEX));
        ImageDomainObject defaultImage = document.getImage(I18nSupport.getDefaultLanguage(), imageIndex);
        ImageDomainObject imageDomainObject = image = defaultImage != null ? defaultImage : new ImageDomainObject();
        if (!ImageEditPage.userHasImagePermissionsOnDocument(user, document)) {
            Utility.redirectToStartDocument(request, response);
            return;
        }
        DispatchCommand returnCommand = new DispatchCommand(){

            public void dispatch(HttpServletRequest request, HttpServletResponse response) throws IOException {
                response.sendRedirect("AdminDoc?meta_id=" + document.getId() + "&flags=" + 131072);
            }
        };
        Handler<List<ImageDomainObject>> imageCommand = new Handler<List<ImageDomainObject>>(){

            @Override
            public void handle(List<ImageDomainObject> images) {
                ImcmsServices services = Imcms.getServices();
                for (ImageDomainObject image2 : images) {
                    document.setImage(image2.getLanguage(), imageIndex, image2);
                }
                try {
                    services.getDocumentMapper().saveDocument(document, user);
                }
                catch (NoPermissionToEditDocumentException e) {
                    throw new ShouldHaveCheckedPermissionsEarlierException(e);
                }
                catch (NoPermissionToAddDocumentToMenuException e) {
                    throw new ConcurrentDocumentModificationException(e);
                }
                catch (DocumentSaveException e) {
                    throw new ShouldNotBeThrownException(e);
                }
                services.updateMainLog("ImageRef " + imageIndex + " =" + image.getUrlPathRelativeToContextPath() + " in  " + "[" + document.getId() + "] modified by user: [" + user.getFullName() + "]");
            }
        };
        ImageDao imageDao = (ImageDao)((Object)Imcms.getServices().getSpringBean("imageDao"));
        List<ImageDomainObject> images = imageDao.getImagesByIndex(document.getMeta().getId(), document.getMeta().getVersion().getVersion(), imageIndex, true);
        LocalizedMessageFormat heading = new LocalizedMessageFormat("image/edit_image_on_page", imageIndex, document.getId());
        ImageEditPage imageEditPage = new ImageEditPage(document, image, heading, StringUtils.defaultString((String)request.getParameter(REQUEST_PARAMETER__LABEL)), this.getServletContext(), imageCommand, returnCommand, true);
        imageEditPage.setImages(images);
        imageEditPage.forward(request, response);
    }
}

