/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet;

import com.imcode.db.DatabaseCommand;
import com.imcode.db.DatabaseConnection;
import com.imcode.db.DatabaseException;
import imcode.server.Imcms;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;

public class Version
extends HttpServlet {
    private static final String VERSION_FILE = "/WEB-INF/version.txt";

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String imcmsVersion = this.getImcmsVersion();
        String serverInfo = this.getServletContext().getServerInfo();
        String databaseProductNameAndVersion = this.getDatabaseProductNameAndVersion();
        String javaVersion = this.getJavaVersion();
        res.setContentType("text/plain");
        PrintWriter out = res.getWriter();
        out.println(imcmsVersion);
        out.println(javaVersion);
        out.println(serverInfo);
        out.println(databaseProductNameAndVersion);
    }

    private String getJavaVersion() {
        return System.getProperty("java.vm.vendor") + " " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getImcmsVersion() {
        String string;
        InputStreamReader in = new InputStreamReader(this.getServletContext().getResourceAsStream(VERSION_FILE));
        try {
            string = "imCMS " + IOUtils.toString((Reader)in).trim();
        }
        catch (Throwable throwable) {
            try {
                ((Reader)in).close();
                throw throwable;
            }
            catch (Exception npe) {
                return "imCMS";
            }
        }
        ((Reader)in).close();
        return string;
    }

    private String getDatabaseProductNameAndVersion() {
        return (String)Imcms.getServices().getDatabase().execute(new DatabaseCommand(){

            public Object executeOn(DatabaseConnection connection) throws DatabaseException {
                try {
                    DatabaseMetaData metaData = connection.getConnection().getMetaData();
                    return metaData.getDatabaseProductName() + " " + metaData.getDatabaseProductVersion();
                }
                catch (SQLException e) {
                    throw DatabaseException.fromSQLException((String)"", (SQLException)e);
                }
            }
        });
    }
}

