/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet;

import imcode.util.FallbackDecoder;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

class UriEncodingWorkaroundWrapper
extends HttpServletRequestWrapper {
    private FallbackDecoder decoder;
    private boolean redecodeParameters;

    UriEncodingWorkaroundWrapper(HttpServletRequest request, FallbackDecoder fallbackDecoder) {
        super(request);
        this.decoder = fallbackDecoder;
        String method = this.getMethod();
        this.redecodeParameters = "GET".equals(method) || "HEAD".equals(method);
    }

    public String getPathInfo() {
        String pathInfo = super.getPathInfo();
        return this.redecode(pathInfo, "path-info " + pathInfo);
    }

    public String getParameter(String parameterName) {
        String parameterValue = super.getParameter(parameterName);
        return this.redecodeParameters ? this.redecode(parameterValue, "parameter " + parameterName) : parameterValue;
    }

    public String[] getParameterValues(String parameterName) {
        String[] parameterValues = super.getParameterValues(parameterName);
        return this.redecodeParameters ? this.redecode(parameterValues, "parameter " + parameterName) : parameterValues;
    }

    public Map getParameterMap() {
        HashMap parameterMap = super.getParameterMap();
        if (this.redecodeParameters) {
            HashMap result = new HashMap();
            for (Map.Entry entry : parameterMap.entrySet()) {
                result.put(entry.getKey(), this.redecode((String[])entry.getValue(), (String)entry.getKey()));
            }
            parameterMap = result;
        }
        return parameterMap;
    }

    private String[] redecode(String[] parameterValues, String parameterName) {
        if (null == parameterValues) {
            return null;
        }
        String[] result = new String[parameterValues.length];
        for (int i = 0; i < parameterValues.length; ++i) {
            result[i] = this.redecode(parameterValues[i], parameterName);
        }
        return result;
    }

    private String redecode(String parameterValue, String parameterName) {
        if (null == parameterValue) {
            return null;
        }
        return this.decoder.decodeBytes(this.decoder.getFallbackCharset().encode(parameterValue).array(), parameterName);
    }
}

