/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping.aop;

import com.imcode.imcms.mapping.TextDocumentInitializer;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;

@Aspect
public class TextDocumentLazyLoadingAspect {
    private boolean textsLoaded;
    private boolean imagesLoaded;
    private boolean menusLoaded;
    private boolean includesLoaded;
    private boolean templateNamesLoaded;
    private boolean contentLoopsLoaded;
    private TextDocumentInitializer textDocumentInitializer;

    public TextDocumentLazyLoadingAspect(TextDocumentInitializer textDocumentInitializer) {
        this.textDocumentInitializer = textDocumentInitializer;
    }

    @Before(value="(execution(* clone()) || execution(* setDependenciesMetaIdToNull())) && target(document)")
    public void loadAll(TextDocumentDomainObject document) {
        this.loadImages(document);
        this.loadIncludes(document);
        this.loadContentLoops(document);
        this.loadMenus(document);
        this.loadTemplates(document);
        this.loadTexts(document);
    }

    @Before(value="execution(* *Image*(..)) && target(document)")
    public void loadImages(TextDocumentDomainObject document) {
        if (!this.imagesLoaded) {
            this.textDocumentInitializer.initImages(document);
            this.imagesLoaded = true;
        }
    }

    @Before(value="execution(* *Text*(..)) && target(document)")
    public void loadTexts(TextDocumentDomainObject document) {
        if (!this.textsLoaded) {
            this.textDocumentInitializer.initTexts(document);
            this.textsLoaded = true;
        }
    }

    @Before(value="(execution(* *Menu*(..)) || execution(* getChildDocumentIds())) && target(document)")
    public void loadMenus(TextDocumentDomainObject document) {
        if (!this.menusLoaded) {
            this.textDocumentInitializer.initMenus(document);
            this.menusLoaded = true;
        }
    }

    @Before(value="execution(* *Include*(..)) && target(document)")
    public void loadIncludes(TextDocumentDomainObject document) {
        if (!this.includesLoaded) {
            this.textDocumentInitializer.initIncludes(document);
            this.includesLoaded = true;
        }
    }

    @Before(value="execution(* *Template*(..)) && target(document)")
    public void loadTemplates(TextDocumentDomainObject document) {
        if (!this.templateNamesLoaded) {
            this.textDocumentInitializer.initTemplateNames(document);
            this.templateNamesLoaded = true;
        }
    }

    @Before(value="execution(* *Loop*(..)) && target(document)")
    public void loadContentLoops(TextDocumentDomainObject document) {
        if (!this.contentLoopsLoaded) {
            this.textDocumentInitializer.initContentLoops(document);
            this.contentLoopsLoaded = true;
        }
    }
}

