/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping.aop;

import com.imcode.imcms.mapping.DocumentInitializingVisitor;
import imcode.server.document.HtmlDocumentDomainObject;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;

@Aspect
public class HtmlDocumentLazyLoadingAspect {
    private boolean loaded;
    private DocumentInitializingVisitor documentInitializingVisitor;

    public HtmlDocumentLazyLoadingAspect(DocumentInitializingVisitor documentInitializingVisitor) {
        this.documentInitializingVisitor = documentInitializingVisitor;
    }

    @Before(value="(execution(* *Html*(..)) || execution(* clone())) && target(document)")
    public void load(HtmlDocumentDomainObject document) {
        if (!this.loaded) {
            this.documentInitializingVisitor.visitHtmlDocument(document);
            this.loaded = true;
        }
    }
}

