/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping.aop;

import com.imcode.imcms.mapping.DocumentInitializingVisitor;
import imcode.server.document.FileDocumentDomainObject;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;

@Aspect
public class FileDocumentLazyLoadingAspect {
    private boolean loaded;
    private DocumentInitializingVisitor documentInitializingVisitor;

    public FileDocumentLazyLoadingAspect(DocumentInitializingVisitor documentInitializingVisitor) {
        this.documentInitializingVisitor = documentInitializingVisitor;
    }

    @Before(value="(execution(* *File*(..)) || execution(* clone())) && target(document)")
    public void load(FileDocumentDomainObject document) {
        if (!this.loaded) {
            this.documentInitializingVisitor.visitFileDocument(document);
            this.loaded = true;
        }
    }
}

