/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.imcms.dao.MetaDao;
import com.imcode.imcms.mapping.DocumentStoringVisitor;
import com.imcode.imcms.mapping.orm.HtmlReference;
import com.imcode.imcms.mapping.orm.UrlReference;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.HtmlDocumentDomainObject;
import imcode.server.document.UrlDocumentDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.UserDomainObject;

public class DocumentSavingVisitor
extends DocumentStoringVisitor {
    private DocumentDomainObject oldDocument;
    private UserDomainObject savingUser;

    public DocumentSavingVisitor(DocumentDomainObject documentInDatabase, ImcmsServices services, UserDomainObject user) {
        super(services);
        this.oldDocument = documentInDatabase;
        this.savingUser = user;
    }

    public void visitHtmlDocument(HtmlDocumentDomainObject document) {
        MetaDao dao = (MetaDao)((Object)Imcms.getServices().getSpringBean("metaDao"));
        HtmlReference htmlReference = new HtmlReference();
        htmlReference.setMetaId(document.getMeta().getId());
        htmlReference.setHtml(document.getHtml());
        dao.saveHtmlReference(htmlReference);
    }

    public void visitUrlDocument(UrlDocumentDomainObject document) {
        MetaDao dao = (MetaDao)((Object)Imcms.getServices().getSpringBean("metaDao"));
        UrlReference reference = new UrlReference();
        reference.setMetaId(document.getMeta().getId());
        reference.setUrl(document.getUrl());
        dao.saveUrlReference(reference);
    }

    public void visitTextDocument(TextDocumentDomainObject textDocument) {
        this.updateTextDocumentTemplateNames(textDocument, (TextDocumentDomainObject)this.oldDocument, this.savingUser);
        this.updateTextDocumentTexts(textDocument, (TextDocumentDomainObject)this.oldDocument, this.savingUser);
        this.updateTextDocumentImages(textDocument, (TextDocumentDomainObject)this.oldDocument, this.savingUser);
        this.updateTextDocumentIncludes(textDocument);
        this.updateTextDocumentContentLoops(textDocument, null, null);
        if (this.oldDocument != null) {
            boolean menusChanged;
            boolean bl = menusChanged = !((Object)textDocument.getMenus()).equals(((TextDocumentDomainObject)this.oldDocument).getMenus());
            if (menusChanged) {
                this.updateTextDocumentMenus(textDocument, (TextDocumentDomainObject)this.oldDocument, this.savingUser);
            }
        }
    }
}

