/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping;

import com.imcode.db.Database;
import com.imcode.db.DatabaseCommand;
import com.imcode.db.commands.CompositeDatabaseCommand;
import com.imcode.db.commands.DeleteWhereColumnsEqualDatabaseCommand;
import com.imcode.db.commands.SqlQueryCommand;
import com.imcode.db.commands.SqlUpdateDatabaseCommand;
import com.imcode.db.handlers.CollectionHandler;
import com.imcode.db.handlers.RowTransformer;
import com.imcode.imcms.api.Document;
import com.imcode.imcms.api.DocumentVersion;
import com.imcode.imcms.api.DocumentVersionSelector;
import com.imcode.imcms.api.DocumentVersionSupport;
import com.imcode.imcms.api.I18nDisabledException;
import com.imcode.imcms.api.I18nLanguage;
import com.imcode.imcms.api.I18nMeta;
import com.imcode.imcms.api.I18nSupport;
import com.imcode.imcms.api.Meta;
import com.imcode.imcms.dao.MetaDao;
import com.imcode.imcms.flow.DocumentPageFlow;
import com.imcode.imcms.mapping.CachingDocumentGetter;
import com.imcode.imcms.mapping.CategoryMapper;
import com.imcode.imcms.mapping.DatabaseDocumentGetter;
import com.imcode.imcms.mapping.DocumentDeletingVisitor;
import com.imcode.imcms.mapping.DocumentGetter;
import com.imcode.imcms.mapping.DocumentPermissionSetMapper;
import com.imcode.imcms.mapping.DocumentSaveException;
import com.imcode.imcms.mapping.DocumentSaver;
import com.imcode.imcms.mapping.DocumentSavingVisitor;
import com.imcode.imcms.mapping.NoPermissionInternalException;
import com.imcode.imcms.mapping.aop.DocumentAspect;
import com.imcode.imcms.mapping.aop.TextDocumentAspect;
import imcode.server.Config;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.CategoryDomainObject;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentPermissionSetTypeDomainObject;
import imcode.server.document.DocumentReference;
import imcode.server.document.FileDocumentDomainObject;
import imcode.server.document.GetterDocumentReference;
import imcode.server.document.NoPermissionToEditDocumentException;
import imcode.server.document.SectionDomainObject;
import imcode.server.document.index.DocumentIndex;
import imcode.server.document.textdocument.NoPermissionToAddDocumentToMenuException;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.DocumentShowSettings;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.Clock;
import imcode.util.LazilyLoadedObject;
import imcode.util.SystemClock;
import imcode.util.Utility;
import imcode.util.io.FileUtility;
import java.io.File;
import java.io.FileFilter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.apache.commons.lang.math.IntRange;
import org.apache.oro.text.perl.Perl5Util;
import org.springframework.aop.aspectj.annotation.AspectJProxyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentMapper
implements DocumentGetter {
    private static final String SQL_GET_ALL_SECTIONS = "SELECT section_id, section_name FROM sections";
    private static final String COPY_HEADLINE_SUFFIX_TEMPLATE = "copy_prefix.html";
    private Database database;
    private DocumentPermissionSetMapper documentPermissionSetMapper;
    private DocumentIndex documentIndex;
    private Clock clock = new SystemClock();
    private ImcmsServices imcmsServices;
    private DatabaseDocumentGetter databaseDocumentGetter;
    private CachingDocumentGetter cachingDocumentGetter;
    private DocumentSaver documentSaver;
    private CategoryMapper categoryMapper;
    private LazilyLoadedObject sections;
    private static final SectionNameComparator SECTION_NAME_COMPARATOR = new SectionNameComparator();

    public DocumentMapper() {
    }

    public DocumentMapper(ImcmsServices services, Database database) {
        this.imcmsServices = services;
        this.database = database;
        Config config = services.getConfig();
        int documentCacheMaxSize = config.getDocumentCacheMaxSize();
        this.databaseDocumentGetter = (DatabaseDocumentGetter)services.getSpringBean("databaseDocumentGetter");
        this.databaseDocumentGetter.setServices(services);
        this.databaseDocumentGetter.getDocumentInitializingVisitor().getTextDocumentInitializer().setDocumentGetter(this);
        MetaDao metaDao = (MetaDao)((Object)services.getSpringBean("metaDao"));
        this.cachingDocumentGetter = new CachingDocumentGetter(this.databaseDocumentGetter, metaDao, documentCacheMaxSize);
        this.documentPermissionSetMapper = new DocumentPermissionSetMapper(database);
        this.categoryMapper = new CategoryMapper(database);
        this.documentSaver = (DocumentSaver)services.getSpringBean("documentSaver");
        this.documentSaver.setDocumentMapper(this);
        this.initSections();
    }

    public DocumentVersionSupport getDocumentVersionSupport(Integer documentId) {
        return this.cachingDocumentGetter.getDocumentVersionSupport(documentId);
    }

    public void initSections() {
        this.sections = new LazilyLoadedObject(new SectionsSetLoader());
    }

    public DocumentSaver getDocumentSaver() {
        return this.documentSaver;
    }

    public DocumentDomainObject createDocumentOfTypeFromParent(int documentTypeId, DocumentDomainObject parent, UserDomainObject user) {
        DocumentDomainObject newDocument;
        try {
            if (2 == documentTypeId) {
                newDocument = parent.clone();
                TextDocumentDomainObject newTextDocument = (TextDocumentDomainObject)newDocument;
                newTextDocument.removeAllTexts();
                newTextDocument.removeAllImages();
                newTextDocument.removeAllIncludes();
                newTextDocument.removeAllMenus();
                newTextDocument.removeAllContentLoops();
                this.setTemplateForNewTextDocument(newTextDocument, user, parent);
            } else {
                newDocument = DocumentDomainObject.fromDocumentTypeId(documentTypeId);
                newDocument.setAttributes((DocumentDomainObject.Attributes)parent.getAttributes().clone());
                newDocument.setMeta(parent.getMeta().clone());
            }
        }
        catch (CloneNotSupportedException e) {
            throw new UnhandledException((Throwable)e);
        }
        Meta meta = newDocument.getMeta();
        meta.setId(null);
        for (I18nMeta i18nMeta : meta.getI18nMetas()) {
            i18nMeta.setHeadline("");
            i18nMeta.setMenuText("");
            i18nMeta.setMenuImageURL("");
            i18nMeta.getKeywords().clear();
        }
        newDocument.setProperties(new HashMap());
        this.makeDocumentLookNew(newDocument, user);
        this.removeNonInheritedCategories(newDocument);
        return newDocument;
    }

    void setTemplateForNewTextDocument(TextDocumentDomainObject newTextDocument, UserDomainObject user, DocumentDomainObject parent) {
        DocumentPermissionSetTypeDomainObject documentPermissionSetType = user.getDocumentPermissionSetTypeFor(parent);
        String templateName = null;
        if (DocumentPermissionSetTypeDomainObject.RESTRICTED_1.equals(documentPermissionSetType)) {
            templateName = newTextDocument.getDefaultTemplateNameForRestricted1();
        } else if (DocumentPermissionSetTypeDomainObject.RESTRICTED_2.equals(documentPermissionSetType)) {
            templateName = newTextDocument.getDefaultTemplateNameForRestricted2();
        }
        if (null == templateName && parent instanceof TextDocumentDomainObject) {
            templateName = ((TextDocumentDomainObject)parent).getDefaultTemplateName();
        }
        if (null != templateName) {
            newTextDocument.setTemplateName(templateName);
        }
    }

    void makeDocumentLookNew(DocumentDomainObject document, UserDomainObject user) {
        Date now = new Date();
        document.setCreator(user);
        this.setCreatedAndModifiedDatetimes(document, now);
        document.setPublicationStartDatetime(now);
        document.setArchivedDatetime(null);
        document.setPublicationEndDatetime(null);
        document.setPublicationStatus(Document.PublicationStatus.NEW);
    }

    public SectionDomainObject[] getAllSections() {
        Object[] parameters = new String[]{};
        String[][] sqlRows = (String[][])this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand(SQL_GET_ALL_SECTIONS, parameters, Utility.STRING_ARRAY_ARRAY_HANDLER));
        SectionDomainObject[] allSections = new SectionDomainObject[sqlRows.length];
        for (int i = 0; i < sqlRows.length; ++i) {
            int sectionId = Integer.parseInt(sqlRows[i][0]);
            String sectionName = sqlRows[i][1];
            allSections[i] = new SectionDomainObject(sectionId, sectionName);
        }
        Arrays.sort(allSections, SECTION_NAME_COMPARATOR);
        return allSections;
    }

    public DocumentReference getDocumentReference(DocumentDomainObject document) {
        return this.getDocumentReference(document.getId());
    }

    public DocumentReference getDocumentReference(int childId) {
        return new GetterDocumentReference(childId, this.cachingDocumentGetter);
    }

    public SectionDomainObject getSectionById(int sectionId) {
        SectionsSet sectionsSet = (SectionsSet)this.sections.get();
        return sectionsSet.getSectionById(sectionId);
    }

    public SectionDomainObject getSectionByName(String name) {
        SectionsSet sectionsSet = (SectionsSet)this.sections.get();
        return sectionsSet.getSectionByName(name);
    }

    public void saveNewDocument(DocumentDomainObject document, UserDomainObject user, boolean copying) throws DocumentSaveException, NoPermissionToAddDocumentToMenuException {
        this.documentSaver.saveNewDocument(user, document, copying);
    }

    public void saveDocument(DocumentDomainObject document, UserDomainObject user) throws DocumentSaveException, NoPermissionToAddDocumentToMenuException, NoPermissionToEditDocumentException {
        DocumentDomainObject oldDocument = this.getDocument((Integer)document.getId(), document.getMeta().getVersion().getNumber());
        this.documentSaver.updateDocument(document, oldDocument, user);
    }

    public void publishWorkingDocument(DocumentDomainObject document, UserDomainObject user) throws DocumentSaveException, NoPermissionToEditDocumentException {
        this.documentSaver.publishWorkingDocument(document, user);
    }

    public void createWorkingDocument(Integer documentId, Integer documentVersion, UserDomainObject user) throws DocumentSaveException, NoPermissionToEditDocumentException {
        DocumentDomainObject document = this.getDocument(documentId, documentVersion);
        this.documentSaver.createWorkingDocumentFromExisting(document, user);
    }

    @Override
    public DocumentDomainObject getDocument(Integer documentId, Integer documentVersion) {
        return this.cachingDocumentGetter.getDocument(documentId, documentVersion);
    }

    public DocumentDomainObject getDocumentForShowing(Integer documentId, Integer versionNumber, UserDomainObject user) {
        DocumentDomainObject document = this.getDocument(documentId, versionNumber);
        return this.createDocumentShowInterceptor(document, user);
    }

    public boolean hasPublishedVersion(Integer documentId) {
        return this.cachingDocumentGetter.getPublishedDocument(documentId) != null;
    }

    public void invalidateDocument(DocumentDomainObject document) {
        this.documentIndex.indexDocument(document);
        this.cachingDocumentGetter.removeDocumentFromCache(document.getId());
    }

    public DocumentIndex getDocumentIndex() {
        return this.documentIndex;
    }

    public String[][] getParentDocumentAndMenuIdsForDocument(DocumentDomainObject document) {
        String sqlStr = "SELECT meta_id,menu_index FROM childs, menus WHERE menus.menu_id = childs.menu_id AND to_meta_id = ?";
        Object[] parameters = new String[]{"" + document.getId()};
        return (String[][])this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand(sqlStr, parameters, Utility.STRING_ARRAY_ARRAY_HANDLER));
    }

    public String[][] getAllMimeTypesWithDescriptions(UserDomainObject user) {
        String sqlStr = "SELECT mime, mime_name FROM mime_types WHERE lang_prefix = ? AND mime_id > 0 ORDER BY mime_id";
        Object[] parameters = new String[]{user.getLanguageIso639_2()};
        return (String[][])this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand(sqlStr, parameters, Utility.STRING_ARRAY_ARRAY_HANDLER));
    }

    public String[] getAllMimeTypes() {
        String sqlStr = "SELECT mime FROM mime_types WHERE mime_id > 0 ORDER BY mime_id";
        Object[] params = new String[]{};
        return (String[])this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand(sqlStr, params, Utility.STRING_ARRAY_HANDLER));
    }

    public void deleteDocument(DocumentDomainObject document, UserDomainObject user) {
        DatabaseCommand deleteDocumentCommand = this.createDeleteDocumentCommand(document);
        this.getDatabase().execute(deleteDocumentCommand);
        document.accept(new DocumentDeletingVisitor());
        this.documentIndex.removeDocument(document);
        this.cachingDocumentGetter.removeDocumentFromCache(document.getId());
    }

    private DatabaseCommand createDeleteDocumentCommand(DocumentDomainObject document) {
        String metaIdStr = "" + document.getId();
        String metaIdColumn = "meta_id";
        return new CompositeDatabaseCommand(new DatabaseCommand[]{new DeleteWhereColumnsEqualDatabaseCommand("document_categories", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("childs", "to_meta_id", (Object)metaIdStr), new SqlUpdateDatabaseCommand("DELETE FROM childs WHERE menu_id IN (SELECT menu_id FROM menus WHERE meta_id = ?)", (Object[])new String[]{metaIdStr}), new DeleteWhereColumnsEqualDatabaseCommand("menus", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("text_docs", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("texts", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("images", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("roles_rights", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("user_rights", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("url_docs", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("fileupload_docs", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("frameset_docs", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("new_doc_permission_sets_ex", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("new_doc_permission_sets", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("doc_permission_sets_ex", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("doc_permission_sets", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("includes", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("includes", "included_meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("texts_history", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("images_history", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("childs_history", "to_meta_id", (Object)metaIdStr), new SqlUpdateDatabaseCommand("DELETE FROM childs_history WHERE menu_id IN (SELECT menu_id FROM menus_history WHERE meta_id = ?)", (Object[])new String[]{metaIdStr}), new DeleteWhereColumnsEqualDatabaseCommand("menus_history", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("document_properties", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("meta_section", "meta_id", (Object)metaIdStr), new DeleteWhereColumnsEqualDatabaseCommand("meta", "meta_id", (Object)metaIdStr)});
    }

    public Map getAllDocumentTypeIdsAndNamesInUsersLanguage(UserDomainObject user) {
        Object[] parameters = new String[]{user.getLanguageIso639_2()};
        String[][] rows = (String[][])this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand("SELECT doc_type, type FROM doc_types WHERE lang_prefix = ? ORDER BY doc_type", parameters, Utility.STRING_ARRAY_ARRAY_HANDLER));
        TreeMap<Integer, String> allDocumentTypeIdsAndNamesInUsersLanguage = new TreeMap<Integer, String>();
        for (int i = 0; i < rows.length; ++i) {
            String[] row = rows[i];
            Integer documentTypeId = Integer.valueOf(row[0]);
            String documentTypeNameInUsersLanguage = row[1];
            allDocumentTypeIdsAndNamesInUsersLanguage.put(documentTypeId, documentTypeNameInUsersLanguage);
        }
        return allDocumentTypeIdsAndNamesInUsersLanguage;
    }

    public TextDocumentMenuIndexPair[] getDocumentMenuPairsContainingDocument(DocumentDomainObject document) {
        String sqlSelectMenus = "SELECT meta_id, menu_index FROM menus, childs WHERE menus.menu_id = childs.menu_id AND childs.to_meta_id = ? ORDER BY meta_id, menu_index";
        Object[] parameters = new String[]{"" + document.getId()};
        String[][] sqlRows = (String[][])this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand(sqlSelectMenus, parameters, Utility.STRING_ARRAY_ARRAY_HANDLER));
        TextDocumentMenuIndexPair[] documentMenuPairs = new TextDocumentMenuIndexPair[sqlRows.length];
        for (int i = 0; i < sqlRows.length; ++i) {
            String[] sqlRow = sqlRows[i];
            int containingDocumentId = Integer.parseInt(sqlRow[0]);
            int menuIndex = Integer.parseInt(sqlRow[1]);
            TextDocumentDomainObject containingDocument = (TextDocumentDomainObject)this.getPublishedDocument(containingDocumentId);
            documentMenuPairs[i] = new TextDocumentMenuIndexPair(containingDocument, menuIndex);
        }
        return documentMenuPairs;
    }

    public Iterator getDocumentsIterator(IntRange idRange) {
        return new DocumentsIterator(this.getDocumentIds(idRange));
    }

    private int[] getDocumentIds(IntRange idRange) {
        String sqlSelectIds = "SELECT meta_id FROM meta WHERE meta_id >= ? AND meta_id <= ? ORDER BY meta_id";
        Object[] params = new String[]{"" + idRange.getMinimumInteger(), "" + idRange.getMaximumInteger()};
        String[] documentIdStrings = (String[])this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand(sqlSelectIds, params, Utility.STRING_ARRAY_HANDLER));
        int[] documentIds = new int[documentIdStrings.length];
        for (int i = 0; i < documentIdStrings.length; ++i) {
            documentIds[i] = Integer.parseInt(documentIdStrings[i]);
        }
        return documentIds;
    }

    public int[] getAllDocumentIds() {
        Object[] params = new String[]{};
        String[] documentIdStrings = (String[])this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand("SELECT meta_id FROM meta ORDER BY meta_id", params, Utility.STRING_ARRAY_HANDLER));
        int[] documentIds = new int[documentIdStrings.length];
        for (int i = 0; i < documentIdStrings.length; ++i) {
            documentIds[i] = Integer.parseInt(documentIdStrings[i]);
        }
        return documentIds;
    }

    public Set<String> getAllDocumentAlias() {
        List<String> aliasesList = this.databaseDocumentGetter.getMetaDao().getAllAliases();
        HashSet aliasesSet = new HashSet();
        Transformer transformer = new Transformer(){

            public String transform(Object alias) {
                return ((String)alias).toLowerCase();
            }
        };
        return (Set)CollectionUtils.collect(aliasesList, (Transformer)transformer, aliasesSet);
    }

    public DocumentDomainObject getDocument(String documentIdentity) {
        Integer documentId = this.toDocumentId(documentIdentity);
        return documentId == null ? null : this.getDocument(documentId);
    }

    public DocumentDomainObject getDocumentForShowing(String documentIdString, Integer versionNumber, UserDomainObject user) {
        DocumentDomainObject document = this.getDocument(documentIdString, versionNumber);
        return this.createDocumentShowInterceptor(document, user);
    }

    public DocumentDomainObject getDocument(String documentIdentity, Integer versionNumber) {
        Integer documentId = this.toDocumentId(documentIdentity);
        return documentId == null ? null : this.getDocument(documentId, versionNumber);
    }

    private Integer toDocumentId(String documentIdentity) {
        if (documentIdentity == null) {
            return null;
        }
        try {
            return Integer.valueOf(documentIdentity);
        }
        catch (NumberFormatException e) {
            return this.cachingDocumentGetter.getDocumentIdByAlias(documentIdentity);
        }
    }

    static void deleteFileDocumentFilesAccordingToFileFilter(FileFilter fileFilter) {
        File filePath = Imcms.getServices().getConfig().getFilePath();
        File[] filesToDelete = filePath.listFiles(fileFilter);
        for (int i = 0; i < filesToDelete.length; ++i) {
            filesToDelete[i].delete();
        }
    }

    static void deleteAllFileDocumentFiles(FileDocumentDomainObject fileDocument) {
        DocumentMapper.deleteFileDocumentFilesAccordingToFileFilter(new FileDocumentFileFilter(fileDocument));
    }

    public DocumentPermissionSetMapper getDocumentPermissionSetMapper() {
        return this.documentPermissionSetMapper;
    }

    static void deleteOtherFileDocumentFiles(FileDocumentDomainObject fileDocument) {
        DocumentMapper.deleteFileDocumentFilesAccordingToFileFilter(new SuperfluousFileDocumentFilesFileFilter(fileDocument));
    }

    public int getLowestDocumentId() {
        Object[] params = new String[]{};
        return Integer.parseInt((String)this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand("SELECT MIN(meta_id) FROM meta", params, Utility.SINGLE_STRING_HANDLER)));
    }

    public int getHighestDocumentId() {
        Object[] params = new String[]{};
        return Integer.parseInt((String)this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand("SELECT MAX(meta_id) FROM meta", params, Utility.SINGLE_STRING_HANDLER)));
    }

    public DocumentDomainObject copyDocument(DocumentDomainObject document, UserDomainObject user) throws NoPermissionToAddDocumentToMenuException, DocumentSaveException {
        document = document.clone();
        String copyHeadlineSuffix = this.imcmsServices.getAdminTemplate(COPY_HEADLINE_SUFFIX_TEMPLATE, user, null);
        document.setAlias(null);
        this.makeDocumentLookNew(document, user);
        for (I18nMeta i18nMeta : document.getMeta().getI18nMetas()) {
            i18nMeta.setHeadline(i18nMeta.getHeadline() + copyHeadlineSuffix);
        }
        this.saveNewDocument(document, user, true);
        return document;
    }

    public List getDocumentsWithPermissionsForRole(RoleDomainObject role) {
        String sqlStr = "SELECT meta_id FROM roles_rights WHERE role_id = ? ORDER BY meta_id";
        Object[] parameters = new String[]{"" + role.getId()};
        String[] documentIdStrings = (String[])this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand(sqlStr, parameters, Utility.STRING_ARRAY_HANDLER));
        final int[] documentIds = Utility.convertStringArrayToIntArray(documentIdStrings);
        return new AbstractList(){

            public Object get(int index) {
                return DocumentMapper.this.getPublishedDocument(documentIds[index]);
            }

            public int size() {
                return documentIds.length;
            }
        };
    }

    public DocumentDomainObject getDocument(Integer documentId, DocumentVersionSelector versionSelector) {
        return versionSelector.getDocument(this, documentId);
    }

    public DocumentDomainObject getLatestDocumentVersionForShowing(Integer documentId, UserDomainObject user) {
        DocumentDomainObject document = this.getDocument(documentId);
        return document == null ? null : this.createDocumentShowInterceptor(document, user);
    }

    @Override
    public DocumentDomainObject getDocument(Integer documentId) {
        return this.cachingDocumentGetter.getDocument(documentId);
    }

    @Override
    public DocumentDomainObject getPublishedDocument(Integer documentId) {
        return this.cachingDocumentGetter.getPublishedDocument(documentId);
    }

    @Override
    public DocumentDomainObject getWorkingDocument(Integer documentId) {
        return this.cachingDocumentGetter.getWorkingDocument(documentId);
    }

    public DocumentDomainObject getDocumentForShowing(String documentIdentity, UserDomainObject user) {
        Integer documentId = this.toDocumentId(documentIdentity);
        return documentId == null ? null : this.getDocumentForShowing(documentId, user);
    }

    public List<DocumentVersion> getDocumentVersions(Integer documentId) {
        return this.documentSaver.getMetaDao().getDocumentVersions(documentId);
    }

    public DocumentDomainObject getDocumentForShowing(Integer documentId, UserDomainObject user) {
        DocumentDomainObject document = null;
        DocumentShowSettings showSettings = user.getDocumentShowSettings();
        switch (showSettings.getVersionSelector().getType()) {
            case PUBLISHED: {
                document = this.getPublishedDocument(documentId);
                break;
            }
            case WORKING: {
                document = this.getWorkingDocument(documentId);
                if (document != null || (document = this.getPublishedDocument(documentId)) == null) break;
                try {
                    this.createWorkingDocument(documentId, document.getMeta().getVersion().getNumber(), user);
                }
                catch (DocumentSaveException e) {
                    throw new RuntimeException(e);
                }
                document = this.getWorkingDocument(documentId);
                break;
            }
            case CUSTOM: {
                document = this.getDocument(documentId, showSettings.getVersionSelector().getVersionNumber());
                break;
            }
            default: {
                document = null;
            }
        }
        return this.createDocumentShowInterceptor(document, user);
    }

    private DocumentDomainObject createDocumentShowInterceptor(DocumentDomainObject document, UserDomainObject user) {
        if (document != null) {
            I18nMeta i18nMeta;
            I18nLanguage currentDocumentLanguage = I18nSupport.getCurrentLanguage();
            DocumentShowSettings showSettings = user.getDocumentShowSettings();
            if (!(I18nSupport.getCurrentIsDefault() || showSettings.isIgnoreI18nShowMode() || (i18nMeta = document.getI18nMeta(I18nSupport.getCurrentLanguage())).getEnabled().booleanValue())) {
                if (document.getMeta().isShowDisabledI18nContentInDefaultLanguage()) {
                    currentDocumentLanguage = I18nSupport.getDefaultLanguage();
                } else {
                    throw new I18nDisabledException(document, I18nSupport.getCurrentLanguage());
                }
            }
            AspectJProxyFactory aspectJProxyFactory = new AspectJProxyFactory((Object)document);
            aspectJProxyFactory.setProxyTargetClass(true);
            aspectJProxyFactory.addAspect((Object)new DocumentAspect(currentDocumentLanguage));
            if (document instanceof TextDocumentDomainObject) {
                aspectJProxyFactory.addAspect((Object)new TextDocumentAspect(currentDocumentLanguage));
            }
            document = (DocumentDomainObject)aspectJProxyFactory.getProxy();
        }
        return document;
    }

    public CategoryMapper getCategoryMapper() {
        return this.categoryMapper;
    }

    public Database getDatabase() {
        return this.database;
    }

    public Clock getClock() {
        return this.clock;
    }

    public ImcmsServices getImcmsServices() {
        return this.imcmsServices;
    }

    void setCreatedAndModifiedDatetimes(DocumentDomainObject document, Date now) {
        document.setCreatedDatetime(now);
        document.setModifiedDatetime(now);
        document.setActualModifiedDatetime(now);
    }

    public void setClock(Clock clock) {
        this.clock = clock;
    }

    public void setDocumentPermissionSetMapper(DocumentPermissionSetMapper documentPermissionSetMapper) {
        this.documentPermissionSetMapper = documentPermissionSetMapper;
    }

    public void setDocumentIndex(DocumentIndex documentIndex) {
        this.documentIndex = documentIndex;
    }

    public List getDocuments(Collection documentIds) {
        return this.cachingDocumentGetter.getDocuments(documentIds);
    }

    public Set getSections(Collection sectionIds) {
        HashSet<SectionDomainObject> sections = new HashSet<SectionDomainObject>();
        for (Integer sectionId : sectionIds) {
            sections.add(this.getSectionById(sectionId));
        }
        return sections;
    }

    private void removeNonInheritedCategories(DocumentDomainObject document) {
        Set categories = this.getCategoryMapper().getCategories(document.getCategoryIds());
        for (CategoryDomainObject category : categories) {
            if (category.getType().isInherited()) continue;
            document.removeCategoryId(category.getId());
        }
    }

    public CachingDocumentGetter getDocumentGetter() {
        return this.cachingDocumentGetter;
    }

    public CachingDocumentGetter getCachingDocumentGetter() {
        return this.cachingDocumentGetter;
    }

    public void setCachingDocumentGetter(CachingDocumentGetter cachingDocumentGetter) {
        this.cachingDocumentGetter = cachingDocumentGetter;
    }

    public void setDocumentSaver(DocumentSaver documentSaver) {
        this.documentSaver = documentSaver;
    }

    public DatabaseDocumentGetter getDatabaseDocumentGetter() {
        return this.databaseDocumentGetter;
    }

    public void setDatabaseDocumentGetter(DatabaseDocumentGetter databaseDocumentGetter) {
        this.databaseDocumentGetter = databaseDocumentGetter;
    }

    private class SectionsSetLoader
    implements LazilyLoadedObject.Loader {
        private SectionsSetLoader() {
        }

        public LazilyLoadedObject.Copyable load() {
            return (SectionsSet)DocumentMapper.this.getDatabase().execute((DatabaseCommand)new SqlQueryCommand(DocumentMapper.SQL_GET_ALL_SECTIONS, null, (ResultSetHandler)new CollectionHandler((Collection)new SectionsSet(), new RowTransformer(){

                public Object createObjectFromResultSetRow(ResultSet rs) throws SQLException {
                    int sectionId = rs.getInt(1);
                    String sectionName = rs.getString(2);
                    return new SectionDomainObject(sectionId, sectionName);
                }

                public Class getClassOfCreatedObjects() {
                    return SectionDomainObject.class;
                }
            })));
        }
    }

    private static class SectionsSet
    extends AbstractSet
    implements LazilyLoadedObject.Copyable {
        private Map byId = new HashMap();
        private Map byName = new HashMap();

        private SectionsSet() {
        }

        public boolean add(Object o) {
            SectionDomainObject section = (SectionDomainObject)o;
            this.byName.put(section.getName().toLowerCase(), section);
            return null == this.byId.put(new Integer(section.getId()), section);
        }

        public int size() {
            return this.byId.size();
        }

        public Iterator iterator() {
            return this.byId.values().iterator();
        }

        public SectionDomainObject getSectionById(int sectionId) {
            return (SectionDomainObject)this.byId.get(new Integer(sectionId));
        }

        public SectionDomainObject getSectionByName(String name) {
            return (SectionDomainObject)this.byName.get(name.toLowerCase());
        }

        public LazilyLoadedObject.Copyable copy() {
            return this;
        }
    }

    private static class SectionNameComparator
    implements Comparator {
        private SectionNameComparator() {
        }

        public int compare(Object o1, Object o2) {
            SectionDomainObject section1 = (SectionDomainObject)o1;
            SectionDomainObject section2 = (SectionDomainObject)o2;
            return section1.getName().compareToIgnoreCase(section2.getName());
        }
    }

    private static class SuperfluousFileDocumentFilesFileFilter
    extends FileDocumentFileFilter {
        private SuperfluousFileDocumentFilesFileFilter(FileDocumentDomainObject fileDocument) {
            super(fileDocument);
        }

        public boolean accept(File file, int fileDocumentId, String fileId) {
            boolean correctFileForFileDocumentFile = file.equals(DocumentSavingVisitor.getFileForFileDocumentFile(fileDocumentId, fileId));
            boolean fileDocumentHasFile = null != this.fileDocument.getFile(fileId);
            return super.accept(file, fileDocumentId, fileId) && (!correctFileForFileDocumentFile || !fileDocumentHasFile);
        }
    }

    private static class FileDocumentFileFilter
    implements FileFilter {
        protected final FileDocumentDomainObject fileDocument;

        protected FileDocumentFileFilter(FileDocumentDomainObject fileDocument) {
            this.fileDocument = fileDocument;
        }

        public boolean accept(File file) {
            Perl5Util perl5Util = new Perl5Util();
            String filename = file.getName();
            if (perl5Util.match("/(\\d+)(?:_se|\\.(.*))?/", filename)) {
                String idStr = perl5Util.group(1);
                String variantName = FileUtility.unescapeFilename(StringUtils.defaultString((String)perl5Util.group(2)));
                return this.accept(file, Integer.parseInt(idStr), variantName);
            }
            return false;
        }

        public boolean accept(File file, int fileDocumentId, String fileId) {
            return fileDocumentId == this.fileDocument.getId();
        }
    }

    public static class PublushDocumentCommand
    implements DocumentPageFlow.SaveDocumentCommand {
        public void saveDocument(DocumentDomainObject document, UserDomainObject user) throws NoPermissionToEditDocumentException, NoPermissionToAddDocumentToMenuException, DocumentSaveException {
            Imcms.getServices().getDocumentMapper().publishWorkingDocument(document, user);
        }
    }

    public static class SaveEditedDocumentCommand
    implements DocumentPageFlow.SaveDocumentCommand {
        public void saveDocument(DocumentDomainObject document, UserDomainObject user) throws NoPermissionInternalException, DocumentSaveException {
            Imcms.getServices().getDocumentMapper().saveDocument(document, user);
        }
    }

    private class DocumentsIterator
    implements Iterator {
        int[] documentIds;
        int index;

        DocumentsIterator(int[] documentIds) {
            this.documentIds = (int[])documentIds.clone();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasNext() {
            return this.index < this.documentIds.length;
        }

        public Object next() {
            int documentId;
            DocumentDomainObject document;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if ((document = DocumentMapper.this.getPublishedDocument(documentId = this.documentIds[this.index++])) == null) {
                document = DocumentMapper.this.getWorkingDocument(documentId);
            }
            return document;
        }
    }

    public static class TextDocumentMenuIndexPair {
        private TextDocumentDomainObject document;
        private int menuIndex;

        public TextDocumentMenuIndexPair(TextDocumentDomainObject document, int menuIndex) {
            this.document = document;
            this.menuIndex = menuIndex;
        }

        public TextDocumentDomainObject getDocument() {
            return this.document;
        }

        public int getMenuIndex() {
            return this.menuIndex;
        }
    }
}

