/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.dao;

import com.imcode.imcms.api.DocumentVersion;
import com.imcode.imcms.api.I18nLanguage;
import imcode.server.document.textdocument.TextDomainObject;
import imcode.server.user.UserDomainObject;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextDao
extends HibernateTemplate {
    @Transactional
    public TextDomainObject saveText(TextDomainObject text) {
        this.saveOrUpdate(text);
        return text;
    }

    @Transactional
    public void updateTexts(Collection<TextDomainObject> texts) {
        for (TextDomainObject text : texts) {
            this.update(text);
        }
    }

    @Transactional
    public void saveTextHistory(Integer documentId, TextDomainObject text, UserDomainObject user) {
        String sql = "INSERT INTO texts_history (meta_id, meta_version, name, text, type, modified_datetime, user_id, language_id) VALUES (:metaId,:metaVersion,:index,:text,:type,:modifiedDt,:userId,:languageId)";
        this.getSession().createSQLQuery(sql).setParameter("metaId", (Object)documentId).setParameter("metaVersion", (Object)text.getMetaVersion()).setParameter("index", (Object)text.getIndex()).setParameter("type", (Object)text.getType()).setParameter("text", (Object)text.getText()).setParameter("modifiedDt", (Object)new Date()).setParameter("userId", (Object)user.getId()).setParameter("languageId", (Object)text.getLanguage().getId()).executeUpdate();
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public List<TextDomainObject> getTexts(Integer documentId, Integer index, I18nLanguage language, Collection<DocumentVersion> versions) {
        String hql = String.format("SELECT t FROM Text t WHERE t.metaId = ? AND t.index = ? AND t.language.id = ? AND t.metaVersion IN (%s)", this.createVersionString(versions));
        return this.find(hql, new Object[]{documentId, index, language.getId()});
    }

    @Transactional
    public Collection<TextDomainObject> getTexts(Integer documentId, Integer documentVersion) {
        return this.findByNamedQueryAndNamedParam("Text.getByDocumentIdAndDocumentVersion", new String[]{"documentId", "documentVersion"}, new Object[]{documentId, documentVersion});
    }

    public List<TextDomainObject> getTextsForAllVersions(Integer documentId, I18nLanguage language) {
        String query = "SELECT t FROM Text t WHERE t.metaId = ? AND t.language = ?";
        return this.find(query, new Object[]{documentId, language});
    }

    public List<TextDomainObject> getTextsForVersionsInRange(Integer documentId, I18nLanguage language, Integer versionFrom, Integer versionTo) {
        String query = "SELECT t FROM Text t WHERE t.metaId=? AND t.language=? AND t.metaVersion BETWEEN ? AND ?";
        return this.find(query, new Object[]{documentId, language, versionFrom, versionTo});
    }

    public List<TextDomainObject> getTextsForVersions(Integer documentId, I18nLanguage language, Collection<Integer> versions) {
        String versionsString = StringUtils.join(versions, (String)",");
        String query = String.format("SELECT t FROM Text t WHERE t.metaId = ? AND t.language=? AND t.metaVersion IN (%s)", versionsString);
        return this.find(query, new Object[]{documentId, language});
    }

    private String createVersionString(Collection<DocumentVersion> versions) {
        StringBuilder versionString = new StringBuilder();
        int i = 0;
        for (DocumentVersion version : versions) {
            if (i++ != 0) {
                versionString.append(",");
            }
            versionString.append(version.getVersion().toString());
        }
        return versionString.toString();
    }
}

