/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.dao;

import com.imcode.imcms.api.DocumentProperty;
import com.imcode.imcms.api.DocumentVersion;
import com.imcode.imcms.api.DocumentVersionSelector;
import com.imcode.imcms.api.DocumentVersionTag;
import com.imcode.imcms.api.I18nLanguage;
import com.imcode.imcms.api.I18nMeta;
import com.imcode.imcms.api.Meta;
import com.imcode.imcms.mapping.orm.FileReference;
import com.imcode.imcms.mapping.orm.HtmlReference;
import com.imcode.imcms.mapping.orm.Include;
import com.imcode.imcms.mapping.orm.TemplateNames;
import com.imcode.imcms.mapping.orm.UrlReference;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.hibernate.Query;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDao
extends HibernateTemplate {
    @Transactional
    private Meta getMeta(Integer documentId) {
        Meta meta = (Meta)this.get(Meta.class, documentId);
        return this.initI18nMetas(meta);
    }

    @Transactional
    public synchronized DocumentVersion createWorkingVersion(Integer documentId, Integer userId) {
        DocumentVersion nextVersion;
        DocumentVersion latestVersion = (DocumentVersion)this.getSession().getNamedQuery("DocumentVersion.getLastVersion").setParameter("documentId", (Object)documentId).uniqueResult();
        if (latestVersion == null) {
            nextVersion = new DocumentVersion(documentId, 1, DocumentVersionTag.WORKING);
        } else {
            nextVersion = new DocumentVersion(documentId, latestVersion.getNumber() + 1, DocumentVersionTag.WORKING);
            if (latestVersion.getTag() == DocumentVersionTag.WORKING) {
                latestVersion.setTag(DocumentVersionTag.POSTPONED);
                this.update(latestVersion);
            }
        }
        nextVersion.setUserId(userId);
        nextVersion.setCreatedDt(new Date());
        this.save(nextVersion);
        return nextVersion;
    }

    @Transactional
    public Meta getMeta(Integer id, Integer version) {
        Meta meta = this.getMeta(id);
        if (meta != null) {
            DocumentVersion documentVersion = (DocumentVersion)this.getSession().getNamedQuery("DocumentVersion.getByDocumentIdAndVersion").setParameter("documentId", (Object)id).setParameter("version", (Object)version).uniqueResult();
            if (documentVersion != null) {
                meta.setVersion(documentVersion);
            } else {
                meta = null;
            }
        }
        return this.initI18nMetas(meta);
    }

    @Transactional
    public Meta getMeta(Integer documentId, DocumentVersionSelector versionSpecifier) {
        switch (versionSpecifier.getType()) {
            case PUBLISHED: {
                return this.getPublishedMeta(documentId);
            }
            case WORKING: {
                return this.getWorkingMeta(documentId);
            }
        }
        return this.getMeta(documentId, versionSpecifier.getVersionNumber());
    }

    @Transactional
    public Meta getPublishedMeta(Integer documentId) {
        Meta meta = this.getMeta(documentId);
        if (meta != null) {
            Query query = this.getSession().getNamedQuery("DocumentVersion.getByDocumentIdAndVersionTag").setParameter("documentId", (Object)documentId).setParameter("versionTag", (Object)DocumentVersionTag.PUBLISHED);
            DocumentVersion documentVersion = (DocumentVersion)query.uniqueResult();
            if (documentVersion == null) {
                return null;
            }
            meta.setVersion(documentVersion);
        }
        return this.initI18nMetas(meta);
    }

    @Transactional
    public Meta getWorkingMeta(Integer documentId) {
        Meta meta = this.getMeta(documentId);
        if (meta != null) {
            Query query = this.getSession().getNamedQuery("DocumentVersion.getByDocumentIdAndVersionTag").setParameter("documentId", (Object)documentId).setParameter("versionTag", (Object)DocumentVersionTag.WORKING);
            DocumentVersion documentVersion = (DocumentVersion)query.uniqueResult();
            if (documentVersion == null) {
                return null;
            }
            meta.setVersion(documentVersion);
        }
        return this.initI18nMetas(meta);
    }

    private Meta initI18nMetas(Meta meta) {
        if (meta == null) {
            return null;
        }
        List languages = this.findByNamedQueryAndNamedParam("I18nLanguage.missingMetaLanguages", "metaId", meta.getId());
        if (languages != null) {
            Set<I18nMeta> parts = meta.getI18nMetas();
            for (I18nLanguage language : languages) {
                I18nMeta part = new I18nMeta();
                part.setLanguage(language);
                part.setEnabled(false);
                part.setHeadline("");
                part.setMenuImageURL("");
                part.setMenuText("");
                parts.add(part);
            }
        }
        meta.initI18nMetaMapping();
        return meta;
    }

    @Transactional
    public void saveMeta(Meta meta) {
        boolean setFk = meta.getId() == null;
        this.saveOrUpdate(meta);
        if (setFk) {
            Integer fk = meta.getId();
            for (I18nMeta i18nMeta : meta.getI18nMetas()) {
                i18nMeta.setMetaId(fk);
            }
        }
    }

    @Transactional
    public void saveIncludes(Integer documentId, Collection<Include> includes) {
        this.bulkUpdate("delete from Include i where i.metaId = ?", documentId);
        for (Include include : includes) {
            this.saveOrUpdate(include);
        }
    }

    @Transactional
    public void saveTemplateNames(Integer documentId, TemplateNames templateNames) {
        this.saveOrUpdate(templateNames);
    }

    @Transactional
    public Collection<Include> getIncludes(Integer documentId) {
        return this.find("select i from Include i where i.metaId = ?", documentId);
    }

    @Transactional
    public TemplateNames getTemplateNames(Integer documentId) {
        return (TemplateNames)this.getSession().createQuery("select n from TemplateNames n where n.metaId = ?").setParameter(0, (Object)documentId).uniqueResult();
    }

    @Transactional
    public Collection<FileReference> getFileReferences(Integer documentId) {
        return this.find("select f from FileReference f where f.metaId = ? ORDER BY f.defaultFileId DESC, f.fileId", documentId);
    }

    @Transactional
    public FileReference saveFileReference(FileReference fileRef) {
        this.saveOrUpdate(fileRef);
        return fileRef;
    }

    @Transactional
    public int deleteFileReferences(Integer documentId) {
        return this.bulkUpdate("delete from FileReference f where f.metaId = ?", documentId);
    }

    @Transactional
    public HtmlReference getHtmlReference(Integer documentId) {
        return (HtmlReference)this.getSession().createQuery("select h from HtmlReference h where h.metaId = ?").setParameter(0, (Object)documentId).uniqueResult();
    }

    @Transactional
    public HtmlReference saveHtmlReference(HtmlReference reference) {
        this.saveOrUpdate(reference);
        return reference;
    }

    @Transactional
    public UrlReference getUrlReference(Integer documentId) {
        return (UrlReference)this.getSession().createQuery("select u from UrlReference u where u.metaId = ?").setParameter(0, (Object)documentId).uniqueResult();
    }

    @Transactional
    public UrlReference saveUrlReference(UrlReference reference) {
        this.saveOrUpdate(reference);
        return reference;
    }

    @Transactional
    public synchronized void publishWorkingDocument(Integer documentId) {
        Query query = this.getSession().getNamedQuery("DocumentVersion.getByDocumentIdAndVersionTag").setParameter("documentId", (Object)documentId).setParameter("versionTag", (Object)DocumentVersionTag.PUBLISHED);
        DocumentVersion publishedVersion = (DocumentVersion)query.uniqueResult();
        if (publishedVersion != null) {
            publishedVersion.setTag(DocumentVersionTag.ARCHIVED);
            this.save(publishedVersion);
        }
        query.setParameter("versionTag", (Object)DocumentVersionTag.WORKING);
        DocumentVersion workingVersion = (DocumentVersion)query.uniqueResult();
        if (workingVersion != null) {
            workingVersion.setTag(DocumentVersionTag.PUBLISHED);
            this.save(workingVersion);
        }
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public List<DocumentVersion> getDocumentVersions(Integer documentId) {
        return this.findByNamedQueryAndNamedParam("DocumentVersion.getByDocumentId", "documentId", documentId);
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public Integer getDocumentIdByAlias(String alias) {
        return (Integer)this.getSession().getNamedQuery("DocumentProperty.getDocumentIdByAlias").setParameter("name", (Object)"imcms.document.alias").setParameter("value", (Object)alias.toLowerCase()).uniqueResult();
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public List<String> getAllAliases() {
        return this.findByNamedQueryAndNamedParam("DocumentProperty.getAllAliases", "name", "imcms.document.alias");
    }

    @Transactional(propagation=Propagation.SUPPORTS)
    public DocumentProperty getAliasProperty(String alias) {
        return (DocumentProperty)this.getSession().getNamedQuery("DocumentProperty.getAliasProperty").setParameter("name", (Object)"imcms.document.alias").setParameter("value", (Object)alias).uniqueResult();
    }
}

