/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.dao;

import imcode.server.document.textdocument.MenuDomainObject;
import imcode.server.document.textdocument.MenuItemDomainObject;
import imcode.server.document.textdocument.TreeSortKeyDomainObject;
import java.util.List;
import java.util.Map;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MenuDao
extends HibernateTemplate {
    @Transactional
    public List<MenuDomainObject> getMenus(Integer documentId) {
        String hql = "SELECT m FROM Menu m  WHERE m.metaId = :metaId";
        List menus = this.findByNamedParam(hql, "metaId", documentId);
        for (MenuDomainObject menu : menus) {
            for (MenuItemDomainObject item : menu.getItemsMap().values()) {
                item.setTreeSortKey(new TreeSortKeyDomainObject(item.getTreeSortIndex()));
            }
        }
        return menus;
    }

    @Transactional
    public Map<Integer, MenuDomainObject> saveDocumentMenus(Integer documentId, Map<Integer, MenuDomainObject> menusMap) {
        for (Map.Entry<Integer, MenuDomainObject> entry : menusMap.entrySet()) {
            MenuDomainObject menu = entry.getValue();
            menu.setMetaId(documentId);
            menu.setIndex(entry.getKey());
            for (Map.Entry<Integer, MenuItemDomainObject> itemEntry : menu.getItemsMap().entrySet()) {
                MenuItemDomainObject item = itemEntry.getValue();
                item.setTreeSortIndex(item.getTreeSortKey().toString());
            }
            this.saveOrUpdate(menu);
        }
        return menusMap;
    }

    @Transactional
    public void deleteMenu(MenuDomainObject menu) {
        this.delete(menu);
    }
}

