/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.imcms.api.I18nLanguage;
import imcode.server.document.textdocument.TextDomainObject;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;

@Entity
@Table(name="texts_history")
public class TextHistory {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="counter")
    private Long id;
    @Column(name="meta_id")
    private Integer metaId;
    @Column(name="name")
    private Integer index;
    private String text;
    private Integer type;
    @Column(name="user_id")
    private Integer userId;
    @OneToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="language_id", referencedColumnName="language_id")
    private I18nLanguage language;

    public TextHistory() {
    }

    public TextHistory(TextDomainObject textDO) {
        this.setIndex(textDO.getIndex());
        this.setText(textDO.getText());
        this.setLanguage(textDO.getLanguage());
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String toString() {
        return this.getText();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getMetaId() {
        return this.metaId;
    }

    public void setMetaId(Integer metaId) {
        this.metaId = metaId;
    }

    public I18nLanguage getLanguage() {
        return this.language;
    }

    public void setLanguage(I18nLanguage language) {
        this.language = language;
    }

    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(Integer index) {
        this.index = index;
    }
}

