/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.imcms.api.DocumentVersion;
import com.imcode.imcms.api.I18nLanguage;
import com.imcode.imcms.api.I18nMeta;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.MapKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="meta")
public class Meta
implements Serializable,
Cloneable {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="meta_id")
    private Integer id;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @JoinColumn(name="meta_id", referencedColumnName="meta_id")
    private Set<I18nMeta> i18nMetas = new HashSet<I18nMeta>();
    @Enumerated(value=EnumType.STRING)
    @Column(name="missing_i18n_show_rule", nullable=false)
    private UnavailableI18nDataSubstitution unavailableI18nDataSubstitution = UnavailableI18nDataSubstitution.DO_NOT_SHOW;
    @Transient
    private DocumentVersion version;
    @Column(name="activate", nullable=false, updatable=false)
    private Integer activate;
    @Column(name="doc_type", nullable=false, updatable=false)
    private Integer documentType;
    @Column(name="owner_id", nullable=false)
    private Integer creatorId;
    @Column(name="permissions", nullable=false)
    private Boolean restrictedOneMorePrivilegedThanRestrictedTwo;
    @Column(name="shared", nullable=false)
    private Boolean linkableByOtherUsers;
    @Column(name="show_meta", nullable=false)
    private Boolean linkedForUnauthorizedUsers;
    @Column(name="lang_prefix", nullable=false)
    private String lang_prefix = "";
    @Column(name="date_created", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createdDatetime;
    @Column(name="date_modified", nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date modifiedDatetime;
    @Transient
    private Date actualModifiedDatetime;
    @Column(name="disable_search", nullable=false)
    private Boolean searchDisabled;
    @Column(name="target", nullable=false)
    private String target;
    @Column(name="archived_datetime", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date archivedDatetime;
    @Column(name="publisher_id", nullable=true)
    private Integer publisherId;
    @Column(name="status", nullable=true)
    private Integer publicationStatusInt;
    @Column(name="publication_start_datetime", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date publicationStartDatetime;
    @Column(name="publication_end_datetime", nullable=true)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date publicationEndDatetime;
    @CollectionOfElements(fetch=FetchType.EAGER)
    @JoinTable(name="document_properties", joinColumns={@JoinColumn(name="meta_id", referencedColumnName="meta_id")})
    @MapKey(columns={@Column(name="key_name")})
    @Column(name="value", nullable=false)
    private Map<String, String> properties = new HashMap<String, String>();
    @CollectionOfElements(fetch=FetchType.EAGER)
    @JoinTable(name="document_categories", joinColumns={@JoinColumn(name="meta_id", referencedColumnName="meta_id")})
    @Column(name="category_id", nullable=false)
    private Set<Integer> categoryIds = new HashSet<Integer>();
    @CollectionOfElements(fetch=FetchType.EAGER)
    @JoinTable(name="meta_section", joinColumns={@JoinColumn(name="meta_id", referencedColumnName="meta_id")})
    @Column(name="section_id", nullable=false)
    private Set<Integer> sectionIds = new HashSet<Integer>();
    @CollectionOfElements(fetch=FetchType.EAGER)
    @JoinTable(name="roles_rights", joinColumns={@JoinColumn(name="meta_id", referencedColumnName="meta_id")})
    @MapKey(columns={@Column(name="role_id")})
    @Column(name="set_id")
    private Map<Integer, Integer> roleIdToPermissionSetIdMap = new HashMap<Integer, Integer>();
    @CollectionOfElements(fetch=FetchType.EAGER)
    @JoinTable(name="doc_permission_sets", joinColumns={@JoinColumn(name="meta_id", referencedColumnName="meta_id")})
    @MapKey(columns={@Column(name="set_id")})
    @Column(name="permission_id")
    private Map<Integer, Integer> permissionSetBitsMap = new HashMap<Integer, Integer>();
    @CollectionOfElements(fetch=FetchType.EAGER)
    @JoinTable(name="new_doc_permission_sets", joinColumns={@JoinColumn(name="meta_id", referencedColumnName="meta_id")})
    @MapKey(columns={@Column(name="set_id")})
    @Column(name="permission_id")
    private Map<Integer, Integer> permissionSetBitsForNewMap = new HashMap<Integer, Integer>();
    @CollectionOfElements(fetch=FetchType.EAGER)
    @JoinTable(name="doc_permission_sets_ex", joinColumns={@JoinColumn(name="meta_id", referencedColumnName="meta_id")})
    private Set<PermisionSetEx> permisionSetEx = new HashSet<PermisionSetEx>();
    @CollectionOfElements(fetch=FetchType.EAGER)
    @JoinTable(name="new_doc_permission_sets_ex", joinColumns={@JoinColumn(name="meta_id", referencedColumnName="meta_id")})
    private Set<PermisionSetEx> permisionSetExForNew = new HashSet<PermisionSetEx>();
    @Transient
    private Map<I18nLanguage, I18nMeta> metaMap;

    public Meta clone() {
        try {
            Meta clone = (Meta)super.clone();
            clone.unavailableI18nDataSubstitution = this.unavailableI18nDataSubstitution;
            clone.version = this.version.clone();
            clone.permisionSetEx = new HashSet<PermisionSetEx>(this.permisionSetEx);
            clone.permisionSetExForNew = new HashSet<PermisionSetEx>(this.permisionSetExForNew);
            clone.permissionSetBitsMap = new HashMap<Integer, Integer>(this.permissionSetBitsMap);
            clone.permissionSetBitsForNewMap = new HashMap<Integer, Integer>(this.permissionSetBitsForNewMap);
            clone.roleIdToPermissionSetIdMap = new HashMap<Integer, Integer>(this.roleIdToPermissionSetIdMap);
            clone.sectionIds = new HashSet<Integer>(this.sectionIds);
            clone.properties = new HashMap<String, String>(this.properties);
            clone.categoryIds = new HashSet<Integer>(this.categoryIds);
            if (this.i18nMetas != null) {
                clone.i18nMetas = new HashSet<I18nMeta>();
                for (I18nMeta i18nMeta : this.i18nMetas) {
                    clone.i18nMetas.add(i18nMeta.clone());
                }
            }
            clone.initI18nMetaMapping();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Set<I18nMeta> getI18nMetas() {
        return this.i18nMetas;
    }

    public void setI18nMetas(Set<I18nMeta> i18nMetas) {
        this.i18nMetas = i18nMetas;
    }

    @Deprecated
    public UnavailableI18nDataSubstitution getUnavailableI18nDataSubstitution() {
        return this.unavailableI18nDataSubstitution;
    }

    @Deprecated
    public void setUnavailableI18nDataSubstitution(UnavailableI18nDataSubstitution unavailableI18nDataSubstitution) {
        this.unavailableI18nDataSubstitution = unavailableI18nDataSubstitution;
    }

    public UnavailableI18nDataSubstitution getI18nShowMode() {
        return this.getUnavailableI18nDataSubstitution();
    }

    public void setI18nShowMode(UnavailableI18nDataSubstitution unavailableI18nDataSubstitution) {
        this.setUnavailableI18nDataSubstitution(unavailableI18nDataSubstitution);
    }

    public void initI18nMetaMapping() {
        HashMap<I18nLanguage, I18nMeta> map = new HashMap<I18nLanguage, I18nMeta>();
        if (this.i18nMetas != null) {
            for (I18nMeta i18nMeta : this.i18nMetas) {
                map.put(i18nMeta.getLanguage(), i18nMeta);
            }
        }
        this.metaMap = Collections.unmodifiableMap(map);
    }

    public I18nMeta getI18nMeta(I18nLanguage language) {
        return this.metaMap.get(language);
    }

    public Integer getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(Integer documentType) {
        this.documentType = documentType;
    }

    public Integer getCreatorId() {
        return this.creatorId;
    }

    public void setCreatorId(Integer creatorId) {
        this.creatorId = creatorId;
    }

    public Boolean getRestrictedOneMorePrivilegedThanRestrictedTwo() {
        return this.restrictedOneMorePrivilegedThanRestrictedTwo;
    }

    public void setRestrictedOneMorePrivilegedThanRestrictedTwo(Boolean restrictedOneMorePrivilegedThanRestrictedTwo) {
        this.restrictedOneMorePrivilegedThanRestrictedTwo = restrictedOneMorePrivilegedThanRestrictedTwo;
    }

    public Boolean getLinkableByOtherUsers() {
        return this.linkableByOtherUsers;
    }

    public void setLinkableByOtherUsers(Boolean linkableByOtherUsers) {
        this.linkableByOtherUsers = linkableByOtherUsers;
    }

    public Boolean getLinkedForUnauthorizedUsers() {
        return this.linkedForUnauthorizedUsers;
    }

    public void setLinkedForUnauthorizedUsers(Boolean linkedForUnauthorizedUsers) {
        this.linkedForUnauthorizedUsers = linkedForUnauthorizedUsers;
    }

    public Date getCreatedDatetime() {
        return this.createdDatetime;
    }

    public void setCreatedDatetime(Date createdDatetime) {
        this.createdDatetime = createdDatetime;
    }

    public Date getModifiedDatetime() {
        return this.modifiedDatetime;
    }

    public void setModifiedDatetime(Date modifiedDatetime) {
        this.modifiedDatetime = modifiedDatetime;
    }

    public Date getActualModifiedDatetime() {
        return this.actualModifiedDatetime;
    }

    public void setActualModifiedDatetime(Date actualModifiedDatetime) {
        this.actualModifiedDatetime = actualModifiedDatetime;
    }

    public Boolean getSearchDisabled() {
        return this.searchDisabled;
    }

    public void setSearchDisabled(Boolean searchDisabled) {
        this.searchDisabled = searchDisabled;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public Date getArchivedDatetime() {
        return this.archivedDatetime;
    }

    public void setArchivedDatetime(Date archivedDatetime) {
        this.archivedDatetime = archivedDatetime;
    }

    public Integer getPublisherId() {
        return this.publisherId;
    }

    public void setPublisherId(Integer publisherId) {
        this.publisherId = publisherId;
    }

    public Integer getPublicationStatusInt() {
        return this.publicationStatusInt;
    }

    public void setPublicationStatusInt(Integer publicationStatusInt) {
        this.publicationStatusInt = publicationStatusInt;
    }

    public Date getPublicationStartDatetime() {
        return this.publicationStartDatetime;
    }

    public void setPublicationStartDatetime(Date publicationStartDatetime) {
        this.publicationStartDatetime = publicationStartDatetime;
    }

    public Date getPublicationEndDatetime() {
        return this.publicationEndDatetime;
    }

    public void setPublicationEndDatetime(Date publicationEndDatetime) {
        this.publicationEndDatetime = publicationEndDatetime;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public Set<Integer> getCategoryIds() {
        return this.categoryIds;
    }

    public void setCategoryIds(Set<Integer> categoryIds) {
        this.categoryIds = categoryIds;
    }

    public Set<Integer> getSectionIds() {
        return this.sectionIds;
    }

    public void setSectionIds(Set<Integer> sectionIds) {
        this.sectionIds = sectionIds;
    }

    public Map<Integer, Integer> getRoleIdToPermissionSetIdMap() {
        return this.roleIdToPermissionSetIdMap;
    }

    public void setRoleIdToPermissionSetIdMap(Map<Integer, Integer> roleRights) {
        this.roleIdToPermissionSetIdMap = roleRights;
    }

    public Map<Integer, Integer> getPermissionSetBitsMap() {
        return this.permissionSetBitsMap;
    }

    public void setPermissionSetBitsMap(Map<Integer, Integer> permissionSetBits) {
        this.permissionSetBitsMap = permissionSetBits;
    }

    public Map<Integer, Integer> getPermissionSetBitsForNewMap() {
        return this.permissionSetBitsForNewMap;
    }

    public void setPermissionSetBitsForNewMap(Map<Integer, Integer> permissionSetBitsForNew) {
        this.permissionSetBitsForNewMap = permissionSetBitsForNew;
    }

    public Set<PermisionSetEx> getPermisionSetEx() {
        return this.permisionSetEx;
    }

    public void setPermisionSetEx(Set<PermisionSetEx> permisionSetEx) {
        this.permisionSetEx = permisionSetEx;
    }

    public Set<PermisionSetEx> getPermisionSetExForNew() {
        return this.permisionSetExForNew;
    }

    public void setPermisionSetExForNew(Set<PermisionSetEx> docPermisionSetExForNew) {
        this.permisionSetExForNew = docPermisionSetExForNew;
    }

    public Integer getActivate() {
        return this.activate;
    }

    public void setActivate(Integer activate) {
        this.activate = activate;
    }

    @Deprecated
    public boolean getShowDisabledI18nDataInDefaultLanguage() {
        return this.unavailableI18nDataSubstitution == UnavailableI18nDataSubstitution.SHOW_IN_DEFAULT_LANGUAGE;
    }

    public boolean isShowDisabledI18nContentInDefaultLanguage() {
        return this.unavailableI18nDataSubstitution == UnavailableI18nDataSubstitution.SHOW_IN_DEFAULT_LANGUAGE;
    }

    public DocumentVersion getVersion() {
        return this.version;
    }

    public void setVersion(DocumentVersion documentVersion) {
        this.version = documentVersion;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UnavailableI18nDataSubstitution {
        SHOW_IN_DEFAULT_LANGUAGE,
        DO_NOT_SHOW;

    }

    @Embeddable
    public static class PermisionSetEx {
        @Column(name="set_id")
        private Integer setId;
        @Column(name="permission_data")
        private Integer permissionData;
        @Column(name="permission_id")
        private Integer permissionId;

        public boolean equals(Object o) {
            return this == o || o instanceof PermisionSetEx && this.hashCode() == o.hashCode();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 31).append((Object)this.setId).append((Object)this.permissionId).append((Object)this.permissionData).toHashCode();
        }

        public Integer getPermissionData() {
            return this.permissionData;
        }

        public void setPermissionData(Integer documentTypeId) {
            this.permissionData = documentTypeId;
        }

        public Integer getPermissionId() {
            return this.permissionId;
        }

        public void setPermissionId(Integer permissionId) {
            this.permissionId = permissionId;
        }

        public Integer getSetId() {
            return this.setId;
        }

        public void setSetId(Integer setId) {
            this.setId = setId;
        }
    }
}

