/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.imcms.api.Category;
import com.imcode.imcms.api.CategoryType;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.DocumentPermissionSet;
import com.imcode.imcms.api.DocumentPermissionSetType;
import com.imcode.imcms.api.DocumentService;
import com.imcode.imcms.api.I18nLanguage;
import com.imcode.imcms.api.Role;
import com.imcode.imcms.api.Section;
import com.imcode.imcms.api.User;
import com.imcode.imcms.mapping.CategoryMapper;
import com.imcode.util.ChainableReversibleNullComparator;
import com.imcode.util.CountingIterator;
import imcode.server.document.CategoryDomainObject;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentPermissionSetDomainObject;
import imcode.server.document.DocumentPermissionSetTypeDomainObject;
import imcode.server.document.RoleIdToDocumentPermissionSetTypeMappings;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.RoleGetter;
import imcode.server.user.RoleId;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class Document
implements Serializable {
    private final DocumentDomainObject internalDocument;
    ContentManagementSystem contentManagementSystem;
    private static final Logger log = Logger.getLogger((String)Document.class.getName());
    public static final int STATUS_NEW = 0;
    public static final int STATUS_PUBLICATION_DISAPPROVED = 1;
    public static final int STATUS_PUBLICATION_APPROVED = 2;

    protected Document(DocumentDomainObject document, ContentManagementSystem contentManagementSystem) {
        this.internalDocument = document;
        this.contentManagementSystem = contentManagementSystem;
    }

    DocumentDomainObject getInternal() {
        return this.internalDocument;
    }

    public int getId() {
        return this.internalDocument.getId();
    }

    public Map getRolesMappedToPermissions() {
        RoleIdToDocumentPermissionSetTypeMappings roleIdToDocumentPermissionSetTypeMappings = this.internalDocument.getRoleIdsMappedToDocumentPermissionSetTypes();
        HashMap<RoleDomainObject, DocumentPermissionSetDomainObject> result = new HashMap<RoleDomainObject, DocumentPermissionSetDomainObject>();
        RoleIdToDocumentPermissionSetTypeMappings.Mapping[] mappings = roleIdToDocumentPermissionSetTypeMappings.getMappings();
        RoleGetter roleGetter = this.contentManagementSystem.getInternal().getRoleGetter();
        for (int i = 0; i < mappings.length; ++i) {
            RoleIdToDocumentPermissionSetTypeMappings.Mapping mapping = mappings[i];
            RoleId roleId = mapping.getRoleId();
            RoleDomainObject role = roleGetter.getRole(roleId);
            DocumentPermissionSetTypeDomainObject documentPermissionSetType = mapping.getDocumentPermissionSetType();
            if (DocumentPermissionSetTypeDomainObject.FULL.equals(documentPermissionSetType)) {
                result.put(role, DocumentPermissionSetDomainObject.FULL);
                continue;
            }
            if (DocumentPermissionSetTypeDomainObject.RESTRICTED_1.equals(documentPermissionSetType)) {
                result.put(role, this.internalDocument.getPermissionSets().getRestricted1());
                continue;
            }
            if (DocumentPermissionSetTypeDomainObject.RESTRICTED_2.equals(documentPermissionSetType)) {
                result.put(role, this.internalDocument.getPermissionSets().getRestricted2());
                continue;
            }
            if (DocumentPermissionSetTypeDomainObject.READ.equals(documentPermissionSetType)) {
                result.put(role, DocumentPermissionSetDomainObject.READ);
                continue;
            }
            if (DocumentPermissionSetTypeDomainObject.NONE.equals(documentPermissionSetType)) continue;
            log.warn((Object)"A missing mapping in DocumentPermissionSetMapper");
        }
        return Document.wrapDomainObjectsInMap(result);
    }

    private static Map wrapDomainObjectsInMap(Map rolesMappedToPermissionsIds) {
        HashMap<Role, DocumentPermissionSet> result = new HashMap<Role, DocumentPermissionSet>();
        Set keys = rolesMappedToPermissionsIds.keySet();
        for (RoleDomainObject role : keys) {
            DocumentPermissionSetDomainObject documentPermissionSetDO = (DocumentPermissionSetDomainObject)rolesMappedToPermissionsIds.get(role);
            DocumentPermissionSet documentPermissionSet = new DocumentPermissionSet(documentPermissionSetDO);
            result.put(new Role(role), documentPermissionSet);
        }
        return result;
    }

    public boolean isArchived() {
        return this.internalDocument.isArchived();
    }

    public boolean isActive() {
        return this.internalDocument.isActive();
    }

    public boolean isPublished() {
        return this.internalDocument.isPublished();
    }

    public boolean isSearchDisabled() {
        return this.internalDocument.isSearchDisabled();
    }

    public void setSearchDisabled(boolean searchDisabled) {
        this.internalDocument.setSearchDisabled(searchDisabled);
    }

    public DocumentPermissionSet getDocumentPermissionSetForUser() {
        return new DocumentPermissionSet(this.contentManagementSystem.getCurrentUser().getInternal().getPermissionSetFor(this.internalDocument));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Document)) {
            return false;
        }
        Document document = (Document)o;
        return this.internalDocument.equals(document.internalDocument);
    }

    public int hashCode() {
        return this.internalDocument.hashCode();
    }

    public Set getKeywords() {
        return this.internalDocument.getKeywords();
    }

    public void setKeywords(I18nLanguage language, Set keywords) {
        this.internalDocument.setKeywords(language, keywords);
    }

    public DocumentPermissionSet getPermissionSetRestrictedOne() {
        DocumentPermissionSetDomainObject restrictedOne = this.internalDocument.getPermissionSets().getRestricted1();
        return new DocumentPermissionSet(restrictedOne);
    }

    public DocumentPermissionSet getPermissionSetRestrictedTwo() {
        DocumentPermissionSetDomainObject restrictedTwo = this.internalDocument.getPermissionSets().getRestricted2();
        return new DocumentPermissionSet(restrictedTwo);
    }

    public String getHeadline() {
        return this.internalDocument.getHeadline();
    }

    public String getMenuText() {
        return this.internalDocument.getMenuText();
    }

    public String getAlias() {
        return this.internalDocument.getAlias();
    }

    public void setAlias(String alias) {
        this.internalDocument.setAlias(alias);
    }

    public String getName() {
        return this.internalDocument.getName();
    }

    public String getMenuImageURL() {
        return this.internalDocument.getMenuImage();
    }

    public void setHeadline(I18nLanguage language, String headline) {
        this.internalDocument.setHeadline(language, headline);
    }

    public void setMenuText(I18nLanguage language, String menuText) {
        this.internalDocument.setMenuText(language, menuText);
    }

    public void setMenuImageURL(I18nLanguage language, String imageUrl) {
        this.internalDocument.setMenuImage(language, imageUrl);
    }

    public User getCreator() {
        int creatorId = this.internalDocument.getCreatorId();
        return this.contentManagementSystem.getUserService().getUser(creatorId);
    }

    public void setCreator(User creator) {
        this.internalDocument.setCreator(creator.getInternal());
    }

    public void addCategory(Category category) {
        this.internalDocument.addCategoryId(category.getId());
    }

    public void removeCategory(Category category) {
        this.internalDocument.removeCategoryId(category.getId());
    }

    public Category[] getCategories() {
        Set categories = this.contentManagementSystem.getInternal().getCategoryMapper().getCategories(this.internalDocument.getCategoryIds());
        CategoryDomainObject[] categoryDomainObjects = categories.toArray(new CategoryDomainObject[categories.size()]);
        return this.getCategoryArrayFromCategoryDomainObjectArray(categoryDomainObjects);
    }

    private Category[] getCategoryArrayFromCategoryDomainObjectArray(CategoryDomainObject[] categoryDomainObjects) {
        Category[] categories = new Category[categoryDomainObjects.length];
        for (int i = 0; i < categories.length; ++i) {
            CategoryDomainObject categoryDomainObject = categoryDomainObjects[i];
            categories[i] = new Category(categoryDomainObject);
        }
        return categories;
    }

    public void setPermissionSetIdForRole(Role role, int permissionSetId) {
        if (null != role) {
            this.internalDocument.setDocumentPermissionSetTypeForRoleId(role.getInternal().getId(), DocumentPermissionSetTypeDomainObject.fromInt(permissionSetId));
        }
    }

    public void setPermissionSetTypeForRole(Role role, DocumentPermissionSetType documentPermissionSetType) {
        this.internalDocument.setDocumentPermissionSetTypeForRoleId(role.getInternal().getId(), documentPermissionSetType.getInternal());
    }

    public int getPermissionSetIdForRole(Role role) {
        return this.internalDocument.getDocumentPermissionSetTypeForRoleId(role.getInternal().getId()).getId();
    }

    public DocumentPermissionSetType getPermissionSetTypeForRole(Role role) {
        return new DocumentPermissionSetType(this.internalDocument.getDocumentPermissionSetTypeForRoleId(role.getInternal().getId()));
    }

    public Category[] getCategoriesOfType(CategoryType categoryType) {
        CategoryMapper categoryMapper = this.contentManagementSystem.getInternal().getCategoryMapper();
        Set categoriesOfType = categoryMapper.getCategoriesOfType(categoryType.getInternal(), this.internalDocument.getCategoryIds());
        CategoryDomainObject[] categories = categoriesOfType.toArray(new CategoryDomainObject[categoriesOfType.size()]);
        return this.getCategoryArrayFromCategoryDomainObjectArray(categories);
    }

    public User getPublisher() {
        Integer publisherId = this.internalDocument.getPublisherId();
        if (null != publisherId) {
            return this.contentManagementSystem.getUserService().getUser(publisherId);
        }
        return null;
    }

    public String getTarget() {
        return this.internalDocument.getTarget();
    }

    public Date getPublicationStartDatetime() {
        return this.internalDocument.getPublicationStartDatetime();
    }

    public void setPublicationStartDatetime(Date datetime) {
        this.internalDocument.setPublicationStartDatetime(datetime);
    }

    public Date getArchivedDatetime() {
        return this.internalDocument.getArchivedDatetime();
    }

    public void setArchivedDatetime(Date datetime) {
        this.internalDocument.setArchivedDatetime(datetime);
    }

    public void setPublisher(User user) {
        this.internalDocument.setPublisher(user.getInternal());
    }

    public Section[] getSections() {
        Set sectionIds = this.internalDocument.getSectionIds();
        Section[] sections = new Section[sectionIds.size()];
        DocumentService documentService = this.contentManagementSystem.getDocumentService();
        CountingIterator iterator = new CountingIterator(sectionIds.iterator());
        while (iterator.hasNext()) {
            Integer sectionId = (Integer)iterator.next();
            sections[iterator.getCount() - 1] = documentService.getSection(sectionId);
        }
        return sections;
    }

    public void setSections(Section[] sections) {
        HashSet<Integer> sectionIds = new HashSet<Integer>();
        for (int i = 0; i < sections.length; ++i) {
            Section section = sections[i];
            int sectionId = section.getId();
            sectionIds.add(new Integer(sectionId));
        }
        this.internalDocument.setSectionIds(sectionIds);
    }

    public Date getModifiedDatetime() {
        return this.internalDocument.getModifiedDatetime();
    }

    public void setModifiedDatetime(Date date) {
        this.internalDocument.setModifiedDatetime(date);
    }

    public Date getCreatedDatetime() {
        return this.internalDocument.getCreatedDatetime();
    }

    public void addSection(Section section) {
        this.internalDocument.addSectionId(section.getId());
    }

    public void setStatus(int status) {
        this.internalDocument.setPublicationStatus(new PublicationStatus(status));
    }

    public void setPublicationEndDatetime(Date datetime) {
        this.internalDocument.setPublicationEndDatetime(datetime);
    }

    public Date getPublicationEndDatetime() {
        return this.internalDocument.getPublicationEndDatetime();
    }

    public int getStatus() {
        return this.internalDocument.getPublicationStatus().status;
    }

    public void setVisibleInMenusForUnauthorizedUsers(boolean visibleInMenusForUnauthorizedUsers) {
        this.internalDocument.setLinkedForUnauthorizedUsers(visibleInMenusForUnauthorizedUsers);
    }

    public boolean isVisibleInMenusForUnauthorizedUsers() {
        return this.internalDocument.isLinkedForUnauthorizedUsers();
    }

    public boolean isLinkableByOtherUsers() {
        return this.internalDocument.isLinkableByOtherUsers();
    }

    public void setLinkableByOtherUsers(boolean linkableByOtherUsers) {
        this.internalDocument.setLinkableByOtherUsers(linkableByOtherUsers);
    }

    public PublicationStatus getPublicationStatus() {
        return this.internalDocument.getPublicationStatus();
    }

    public void setPublicationStatus(PublicationStatus publicationStatus) {
        this.internalDocument.setPublicationStatus(publicationStatus);
    }

    public static abstract class Comparator
    extends ChainableReversibleNullComparator {
        public static final Comparator ID = new Comparator(){

            protected int compareDocuments(Document d1, Document d2) {
                return d1.getId() - d2.getId();
            }
        };
        public static final Comparator HEADLINE = new Comparator(){

            protected int compareDocuments(Document d1, Document d2) {
                return d1.getHeadline().compareToIgnoreCase(d2.getHeadline());
            }
        };
        public static final Comparator CREATED_DATETIME = new Comparator(){

            protected int compareDocuments(Document d1, Document d2) {
                return d1.getCreatedDatetime().compareTo(d2.getCreatedDatetime());
            }
        };
        public static final Comparator MODIFIED_DATETIME = new Comparator(){

            protected int compareDocuments(Document d1, Document d2) {
                return d1.getModifiedDatetime().compareTo(d2.getModifiedDatetime());
            }
        };
        public static final Comparator PUBLICATION_START_DATETIME = new Comparator(){

            protected int compareDocuments(Document document1, Document document2) {
                return document1.getPublicationStartDatetime().compareTo(document2.getPublicationStartDatetime());
            }
        };
        public static final Comparator PUBLICATION_END_DATETIME = new Comparator(){

            protected int compareDocuments(Document document1, Document document2) {
                return document1.getPublicationEndDatetime().compareTo(document2.getPublicationEndDatetime());
            }
        };
        public static final Comparator ARCHIVED_DATETIME = new Comparator(){

            protected int compareDocuments(Document document1, Document document2) {
                return document1.getArchivedDatetime().compareTo(document2.getArchivedDatetime());
            }
        };

        public int compare(Object o1, Object o2) {
            Document d1 = (Document)o1;
            Document d2 = (Document)o2;
            try {
                return this.compareDocuments(d1, d2);
            }
            catch (NullPointerException npe) {
                NullPointerException nullPointerException = new NullPointerException("Tried sorting on null fields! You need to call .nullsFirst() or .nullsLast() on your Comparator.");
                nullPointerException.initCause(npe);
                throw nullPointerException;
            }
        }

        protected abstract int compareDocuments(Document var1, Document var2);
    }

    public static class LifeCyclePhase
    implements Serializable {
        public static final LifeCyclePhase NEW = new LifeCyclePhase(imcode.server.document.LifeCyclePhase.NEW);
        public static final LifeCyclePhase DISAPPROVED = new LifeCyclePhase(imcode.server.document.LifeCyclePhase.DISAPPROVED);
        public static final LifeCyclePhase PUBLISHED = new LifeCyclePhase(imcode.server.document.LifeCyclePhase.PUBLISHED);
        public static final LifeCyclePhase UNPUBLISHED = new LifeCyclePhase(imcode.server.document.LifeCyclePhase.UNPUBLISHED);
        public static final LifeCyclePhase ARCHIVED = new LifeCyclePhase(imcode.server.document.LifeCyclePhase.ARCHIVED);
        public static final LifeCyclePhase APPROVED = new LifeCyclePhase(imcode.server.document.LifeCyclePhase.APPROVED);
        private imcode.server.document.LifeCyclePhase phase;

        private LifeCyclePhase(imcode.server.document.LifeCyclePhase phase) {
            this.phase = phase;
        }

        public String toString() {
            return this.phase.toString();
        }
    }

    public static class PublicationStatus
    implements Serializable {
        public static final PublicationStatus NEW = new PublicationStatus(0);
        public static final PublicationStatus APPROVED = new PublicationStatus(2);
        public static final PublicationStatus DISAPPROVED = new PublicationStatus(1);
        private final int status;

        private PublicationStatus(int status) {
            this.status = status;
        }

        public String toString() {
            return "" + this.status;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.status == ((PublicationStatus)o).status;
        }

        public int hashCode() {
            return this.status;
        }

        public Integer asInt() {
            return this.status;
        }
    }
}

