/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.imcms.api.ContentManagementSystemRunnable;
import com.imcode.imcms.api.DatabaseService;
import com.imcode.imcms.api.DefaultContentManagementSystem;
import com.imcode.imcms.api.DocumentService;
import com.imcode.imcms.api.MailService;
import com.imcode.imcms.api.NoPermissionException;
import com.imcode.imcms.api.TemplateService;
import com.imcode.imcms.api.User;
import com.imcode.imcms.api.UserService;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public abstract class ContentManagementSystem {
    public abstract UserService getUserService();

    public abstract DocumentService getDocumentService();

    public abstract User getCurrentUser();

    public abstract DatabaseService getDatabaseService();

    public abstract TemplateService getTemplateService();

    public abstract MailService getMailService();

    public abstract void runAsSuperadmin(ContentManagementSystemRunnable var1) throws NoPermissionException;

    public static ContentManagementSystem getContentManagementSystem(String userName, String password) {
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = imcref.verifyUser(userName, password);
        return DefaultContentManagementSystem.create(imcref, user, Imcms.getApiDataSource());
    }

    public static ContentManagementSystem login(HttpServletRequest request, String username, String password) {
        ImcmsServices services = Imcms.getServices();
        UserDomainObject user = services.verifyUser(username, password);
        if (null == user || user.isDefaultUser()) {
            return null;
        }
        ContentManagementSystem cms = Utility.initRequestWithApi((ServletRequest)request, user);
        if (services.getConfig().isDenyMultipleUserLogin()) {
            User currentUser = cms.getCurrentUser();
            currentUser.setSessionId(request.getSession().getId());
            cms.getUserService().updateUserSession(currentUser);
        }
        Utility.makeUserLoggedIn(request, user);
        return cms;
    }

    public static ContentManagementSystem fromRequest(ServletRequest request) {
        return Utility.getContentManagementSystemFromRequest(request);
    }

    abstract ImcmsServices getInternal();
}

