/*
 * Decompiled with CFR 0.152.
 */
package imcode.util;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class CompositeList
extends AbstractList
implements Serializable {
    private final List lists = Collections.synchronizedList(new ArrayList());

    public Object get(int index) {
        return this.operateOnIndex(index, new ListIndexOperation(){

            public Object operate(List list, int index) {
                return list.get(index);
            }
        });
    }

    public Object remove(int index) {
        return this.operateOnIndex(index, new ListIndexOperation(){

            public Object operate(List list, int index) {
                return list.remove(index);
            }
        });
    }

    public Object set(int index, final Object element) {
        return this.operateOnIndex(index, new ListIndexOperation(){

            public Object operate(List list, int index) {
                return list.set(index, element);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object operateOnIndex(int index, ListIndexOperation listIndexOperation) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("" + index);
        }
        List list = this.lists;
        synchronized (list) {
            int firstIndexInList = 0;
            Iterator iterator = this.lists.iterator();
            while (iterator.hasNext()) {
                int indexInList = index - firstIndexInList;
                List list2 = (List)iterator.next();
                if (indexInList < list2.size()) {
                    return listIndexOperation.operate(list2, indexInList);
                }
                firstIndexInList += list2.size();
            }
        }
        throw new IndexOutOfBoundsException("" + index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        List list = this.lists;
        synchronized (list) {
            int size = 0;
            for (List list2 : this.lists) {
                size += list2.size();
            }
            return size;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object o) {
        List list = this.lists;
        synchronized (list) {
            for (List list2 : this.lists) {
                if (!list2.contains(o)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addList(List list) {
        List list2 = this.lists;
        synchronized (list2) {
            this.lists.add(list);
        }
    }

    private static interface ListIndexOperation {
        public Object operate(List var1, int var2);
    }
}

