/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document.index;

import imcode.server.document.DocumentDomainObject;
import imcode.server.document.index.BackgroundIndexBuilder;
import imcode.server.document.index.DefaultDirectoryIndex;
import imcode.server.document.index.DirectoryIndex;
import imcode.server.document.index.IndexDocumentFactory;
import imcode.server.document.index.IndexException;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.ClassUtils;
import org.apache.log4j.Logger;
import org.apache.log4j.NDC;

class IndexBuildingThread
extends Thread {
    private final Set documentsToAddToNewIndex = Collections.synchronizedSet(new LinkedHashSet());
    private final Set documentsToRemoveFromNewIndex = Collections.synchronizedSet(new LinkedHashSet());
    private static final Logger log = Logger.getLogger((String)IndexBuildingThread.class.getName());
    private final BackgroundIndexBuilder backgroundIndexBuilder;
    private final File indexDirectory;
    private boolean indexing;
    private IndexDocumentFactory indexDocumentFactory;

    IndexBuildingThread(BackgroundIndexBuilder backgroundIndexBuilder, File indexDirectory, IndexDocumentFactory indexDocumentFactory) {
        this.indexDirectory = indexDirectory;
        this.backgroundIndexBuilder = backgroundIndexBuilder;
        this.setName(ClassUtils.getShortClassName(this.getClass()) + "-" + this.getName());
        this.setPriority(1);
        this.setDaemon(true);
        this.indexDocumentFactory = indexDocumentFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        IndexBuildingThread indexBuildingThread;
        NDC.push((String)Thread.currentThread().getName());
        DefaultDirectoryIndex newIndex = new DefaultDirectoryIndex(this.indexDirectory, this.indexDocumentFactory);
        try {
            indexBuildingThread = this;
            synchronized (indexBuildingThread) {
                this.indexing = true;
            }
            newIndex.rebuild();
            indexBuildingThread = this;
            synchronized (indexBuildingThread) {
                this.indexing = false;
                this.considerDocumentsAddedOrRemovedDuringIndexing(newIndex);
            }
            log.info((Object)"Index rebuild completed.");
        }
        catch (Throwable e) {
            log.fatal((Object)"Failed to index all documents.", e);
        }
        finally {
            indexBuildingThread = this;
            synchronized (indexBuildingThread) {
                this.indexing = false;
            }
            this.backgroundIndexBuilder.notifyRebuildComplete(newIndex);
            NDC.pop();
        }
    }

    private synchronized void considerDocumentsAddedOrRemovedDuringIndexing(DirectoryIndex index) throws IndexException {
        DocumentDomainObject document;
        log.debug((Object)"Considering documents added and removed during index rebuild.");
        Iterator iterator = this.documentsToAddToNewIndex.iterator();
        while (iterator.hasNext()) {
            document = (DocumentDomainObject)iterator.next();
            index.indexDocument(document);
            iterator.remove();
        }
        iterator = this.documentsToRemoveFromNewIndex.iterator();
        while (iterator.hasNext()) {
            document = (DocumentDomainObject)iterator.next();
            index.removeDocument(document);
            iterator.remove();
        }
    }

    public synchronized void addDocument(DocumentDomainObject document) {
        if (this.indexing) {
            this.documentsToAddToNewIndex.add(document);
        }
    }

    public synchronized void removeDocument(DocumentDomainObject document) {
        if (this.indexing) {
            this.documentsToRemoveFromNewIndex.add(document);
        }
    }
}

