/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.util.rss;

import com.imcode.imcms.util.rss.Channel;
import com.imcode.imcms.util.rss.Item;
import com.imcode.imcms.util.rss.NameSpace;
import com.imcode.imcms.util.rss.Rss20DocumentFactory;
import com.imcode.imcms.util.rss.dc.DublinCoreEntity;
import com.imcode.imcms.util.rss.dc.DublinCoreItem;
import com.imcode.imcms.util.rss.dc.DublinCoreTerms;
import imcode.util.Utility;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import javax.xml.transform.stream.StreamResult;
import junit.framework.TestCase;
import org.apache.commons.beanutils.DynaBean;
import org.w3c.dom.Document;

public class Rss20DocumentFactoryTest
extends TestCase {
    public void testCreateRssDocument() {
        Rss20DocumentFactory rssDocumentFactory = new Rss20DocumentFactory();
        SimpleChannel channel = new SimpleChannel();
        channel.setTitle("title");
        channel.setLink("link");
        channel.setDescription("description");
        SimpleDublinCoreTerms dublinCoreTerms = new SimpleDublinCoreTerms();
        dublinCoreTerms.setTitle("title");
        dublinCoreTerms.setIssued(new Date());
        DublinCoreItem item = new DublinCoreItem(dublinCoreTerms);
        channel.setItems(Arrays.asList(item));
        Document rssDocument = rssDocumentFactory.createRssDocument(channel);
        Utility.writeXmlDocument(rssDocument, new StreamResult(System.out));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SimpleChannel
    implements Channel {
        private String title;
        private String link;
        private String description;
        private Collection<Item> items;

        private SimpleChannel() {
        }

        @Override
        public String getTitle() {
            return this.title;
        }

        @Override
        public String getLink() {
            return this.link;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public Iterable<Item> getItems() {
            return this.items;
        }

        @Override
        public Map<NameSpace, Map<String, String>> getNameSpaceStrings() {
            return Collections.EMPTY_MAP;
        }

        @Override
        public Map<NameSpace, DynaBean> getNameSpaceBeans() {
            return Collections.EMPTY_MAP;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setItems(Collection<Item> items) {
            this.items = items;
        }

        public void setLink(String link) {
            this.link = link;
        }

        public void setTitle(String title) {
            this.title = title;
        }
    }

    private static class SimpleDublinCoreTerms
    implements DublinCoreTerms {
        private Date created;
        private DublinCoreEntity creator;
        private String description;
        private String identifier;
        private Date issued;
        private Date modified;
        private String title;

        private SimpleDublinCoreTerms() {
        }

        public Date getCreated() {
            return this.created;
        }

        public DublinCoreEntity getCreator() {
            return this.creator;
        }

        public String getDescription() {
            return this.description;
        }

        public String getIdentifer() {
            return this.identifier;
        }

        public Date getIssued() {
            return this.issued;
        }

        public Date getModified() {
            return this.modified;
        }

        public String getTitle() {
            return this.title;
        }

        public void setCreated(Date created) {
            this.created = created;
        }

        public void setCreator(DublinCoreEntity creator) {
            this.creator = creator;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public void setIssued(Date issued) {
            this.issued = issued;
        }

        public void setModified(Date modified) {
            this.modified = modified;
        }

        public void setTitle(String title) {
            this.title = title;
        }
    }
}

