/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.util.rss;

import com.imcode.imcms.util.rss.Channel;
import com.imcode.imcms.util.rss.Item;
import com.imcode.imcms.util.rss.NameSpace;
import com.imcode.imcms.util.rss.RssDocumentFactory;
import com.imcode.imcms.util.rss.dc.DublinCoreEntity;
import com.imcode.imcms.util.rss.dc.DublinCoreTerms;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rss20DocumentFactory
implements RssDocumentFactory {
    private static final String RFC822_DATE_PATTERN = "EEE, d MMM yyyy HH:mm:ss Z";

    @Override
    public Document createRssDocument(Channel channel) {
        try {
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
            Document xmlDocument = documentBuilder.newDocument();
            this.appendRssElement(xmlDocument, channel);
            return xmlDocument;
        }
        catch (ParserConfigurationException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    private Element appendRssElement(Document xmlDocument, Channel channel) {
        Element rssElement = xmlDocument.createElement("rss");
        xmlDocument.appendChild(rssElement);
        rssElement.setAttribute("version", "2.0");
        this.appendChannelElement(rssElement, channel);
        return rssElement;
    }

    private Element appendChannelElement(Element rssElement, Channel channel) {
        Element channelElement = rssElement.getOwnerDocument().createElement("channel");
        rssElement.appendChild(channelElement);
        this.appendTextElement(channelElement, "title", channel.getTitle());
        this.appendTextElement(channelElement, "link", channel.getLink());
        this.appendTextElement(channelElement, "description", channel.getDescription());
        this.appendNameSpaceStrings(channelElement, channel.getNameSpaceStrings());
        this.appendItems(channelElement, channel);
        return channelElement;
    }

    private void appendItems(Element channelElement, Channel channel) {
        for (Item item : channel.getItems()) {
            this.appendItem(channelElement, item);
        }
    }

    private void appendItem(Element channelElement, Item item) {
        channelElement.appendChild(this.createItemElement(channelElement.getOwnerDocument(), item));
    }

    private Element createItemElement(Document xmlDocument, Item item) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(RFC822_DATE_PATTERN);
        Element itemElement = xmlDocument.createElement("item");
        this.appendTextElement(itemElement, "link", item.getLink());
        this.appendTextElement(itemElement, "title", item.getTitle());
        this.appendTextElement(itemElement, "description", item.getDescription());
        try {
            DublinCoreEntity dublinCoreEntity = (DublinCoreEntity)item.getNameSpaceBeans().get(DublinCoreTerms.DUBLIN_CORE_ELEMENTS_NAME_SPACE).get("creator");
            this.appendTextElement(itemElement, "author", dublinCoreEntity.getEmailAddress());
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        try {
            Date issued = (Date)item.getNameSpaceBeans().get(DublinCoreTerms.DUBLIN_CORE_TERMS_NAME_SPACE).get("issued");
            this.appendTextElement(itemElement, "pubDate", dateFormat.format(issued));
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        Map<NameSpace, Map<String, String>> nameSpaces = item.getNameSpaceStrings();
        this.appendNameSpaceStrings(itemElement, nameSpaces);
        return itemElement;
    }

    private void appendNameSpaceStrings(Element itemElement, Map<NameSpace, Map<String, String>> nameSpaces) {
        for (Map.Entry<NameSpace, Map<String, String>> nameSpaceEntry : nameSpaces.entrySet()) {
            NameSpace nameSpace = nameSpaceEntry.getKey();
            String nameSpaceUri = nameSpace.getNameSpaceUri();
            String prefix = this.lookupPrefix(itemElement, nameSpaceUri, nameSpace);
            Map<String, String> nameSpaceValues = nameSpaceEntry.getValue();
            for (Map.Entry<String, String> nameSpaceValueEntry : nameSpaceValues.entrySet()) {
                String name = nameSpaceValueEntry.getKey();
                if (null != prefix) {
                    name = prefix + ":" + name;
                }
                String value = nameSpaceValueEntry.getValue();
                this.appendTextElementNS(itemElement, nameSpaceUri, name, value);
            }
        }
    }

    private String lookupPrefix(Element element, String nameSpaceUri, NameSpace nameSpace) {
        String suggestedPrefix;
        String prefix = element.lookupPrefix(nameSpaceUri);
        if (null == prefix && null == element.lookupNamespaceURI(suggestedPrefix = nameSpace.getSuggestedPrefix())) {
            prefix = suggestedPrefix;
            element.getOwnerDocument().getDocumentElement().setAttribute("xmlns:" + prefix, nameSpaceUri);
        }
        return prefix;
    }

    private void appendTextElement(Element parentElement, String tagName, String text) {
        this.appendTextElementNS(parentElement, null, tagName, text);
    }

    private void appendTextElementNS(Element parentElement, String namespaceUri, String qualifiedName, String text) {
        if (StringUtils.isNotBlank((String)text)) {
            parentElement.appendChild(this.createTextElementNS(parentElement.getOwnerDocument(), namespaceUri, qualifiedName, text));
        }
    }

    private Element createTextElementNS(Document xmlDocument, String namespaceUri, String qualifiedName, String text) {
        Element treeKeyElement = xmlDocument.createElementNS(namespaceUri, qualifiedName);
        treeKeyElement.appendChild(xmlDocument.createTextNode(text));
        return treeKeyElement;
    }
}

