/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.util;

import com.imcode.imcms.util.SchemaVersionCheckerException;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class SchemaVersionChecker {
    public String SQL_SELECT_SCHEMA_VERSION = "SELECT concat(cast(major as char), '.', cast(minor as char)) FROM database_version";
    private HibernateTemplate hibernateTemplate;

    public void checkSchemaVersion(String expectedVersion) {
        try {
            expectedVersion = expectedVersion.trim();
            String realVersion = this.getSchemaVersion().trim();
            if (!expectedVersion.equals(realVersion)) {
                throw new SchemaVersionCheckerException(String.format("Versions mismatch. Expected version: [%s], real version: [%s].", realVersion, expectedVersion));
            }
        }
        catch (SchemaVersionCheckerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SchemaVersionCheckerException("Uncategorized error.", e);
        }
    }

    public String getSchemaVersion() {
        return (String)this.hibernateTemplate.execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createSQLQuery(SchemaVersionChecker.this.SQL_SELECT_SCHEMA_VERSION).uniqueResult();
            }
        });
    }

    public HibernateTemplate getHibernateTemplate() {
        return this.hibernateTemplate;
    }

    public void setHibernateTemplate(HibernateTemplate hibernateTemplate) {
        this.hibernateTemplate = hibernateTemplate;
    }
}

