/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.superadmin;

import com.imcode.imcms.db.StringArrayResultSetHandler;
import com.imcode.imcms.servlet.superadmin.AdminIpAccess;
import com.imcode.imcms.util.l10n.ImcmsPrefsLocalizedMessageProvider;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.user.ImcmsAuthenticatorAndUserAndRoleMapper;
import imcode.server.user.NameTooLongException;
import imcode.server.user.RoleAlreadyExistsException;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.RolePermissionDomainObject;
import imcode.server.user.UserAndRoleRegistryException;
import imcode.server.user.UserDomainObject;
import imcode.util.Html;
import imcode.util.ToStringPairTransformer;
import imcode.util.Utility;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.UnhandledException;
import org.apache.log4j.Logger;

public class AdminRoles
extends HttpServlet {
    private static final Logger LOG = Logger.getLogger((String)AdminRoles.class.getName());
    private static final String HTML_ADMIN_ROLES = "AdminRoles_roles.htm";
    private static final String HTML_ADD_ROLE = "AdminRoles_Add.htm";
    private static final String HTML_RENAME_ROLE = "AdminRoles_Rename.htm";
    private static final String HTML_DELETE_ROLE_1 = "AdminRoles_Delete1.htm";
    private static final String HTML_DELETE_ROLE_2 = "AdminRoles_Delete2.htm";
    private static final String HTML_EDIT_ROLE = "AdminRoles_Edit.html";
    private static final String HTML_EDIT_ROLE_TABLE = "AdminRoles_Edit_Permissions_List.html";
    private static final String HTML_EDIT_ROLE_TABLE_ROW = "AdminRoles_Edit_Permission.html";

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        Utility.setDefaultHtmlContentType(res);
        if (!user.isSuperAdmin()) {
            String header = "Error in AdminRoles.";
            Properties langproperties = ImcmsPrefsLocalizedMessageProvider.getLanguageProperties(user);
            String msg = langproperties.getProperty("error/servlet/global/no_administrator") + "<br>";
            LOG.debug((Object)(header + "- user is not an administrator"));
            AdminRoles.printErrorMessage(req, res, header, msg);
            return;
        }
        Object[] parameters = new String[]{};
        String[] rolesArr = (String[])imcref.getProcedureExecutor().executeProcedure("RoleAdminGetAll", parameters, new StringArrayResultSetHandler());
        ArrayList<String> rolesV = new ArrayList<String>(Arrays.asList(rolesArr));
        HashMap<String, String> vm = new HashMap<String, String>();
        String opt = Html.createOptionList(rolesV, Arrays.asList(""));
        vm.put("ROLES_MENU", opt);
        AdminRoles.sendHtml(req, res, vm, HTML_ADMIN_ROLES);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        ImcmsAuthenticatorAndUserAndRoleMapper userAndRoleMapper = Imcms.getServices().getImcmsAuthenticatorAndUserAndRoleMapper();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        Utility.setDefaultHtmlContentType(res);
        if (!user.isSuperAdmin()) {
            AdminIpAccess.printNonAdminError(imcref, user, req, res, ((Object)((Object)this)).getClass());
        } else {
            String msg;
            String header;
            RoleDomainObject role;
            int roleId;
            String roleIdStr;
            Properties params;
            if (req.getParameter("VIEW_ADMIN_ROLES") != null) {
                Object[] parameters = new String[]{};
                String[] rolesArr = (String[])imcref.getProcedureExecutor().executeProcedure("RoleAdminGetAll", parameters, new StringArrayResultSetHandler());
                List<String> rolesV = Arrays.asList(rolesArr);
                HashMap<String, String> vm = new HashMap<String, String>();
                String opt = Html.createOptionList(rolesV, "");
                vm.put("ROLES_MENU", opt);
                AdminRoles.sendHtml(req, res, vm, HTML_ADMIN_ROLES);
                return;
            }
            if (req.getParameter("CANCEL") != null || req.getParameter("CANCEL_ROLE_ADMIN") != null) {
                res.sendRedirect("AdminManager");
                return;
            }
            if (req.getParameter("CANCEL_ROLE") != null) {
                this.doGet(req, res);
                return;
            }
            if (req.getParameter("VIEW_ADD_NEW_ROLE") != null) {
                RolePermissionDomainObject[] allRolePermissions = RoleDomainObject.getAllRolePermissions();
                String[][] permissionList = new String[allRolePermissions.length][];
                for (int i = 0; i < permissionList.length; ++i) {
                    RolePermissionDomainObject rolePermission = allRolePermissions[i];
                    permissionList[i] = new String[]{"0", "" + rolePermission.getId(), rolePermission.getDescription().toLocalizedString(req)};
                }
                String permissionComponent = this.createPermissionComponent(req, permissionList);
                HashMap<String, String> vm = new HashMap<String, String>();
                vm.put("ROLE_PERMISSIONS", permissionComponent);
                AdminRoles.sendHtml(req, res, vm, HTML_ADD_ROLE);
                return;
            }
            if (req.getParameter("VIEW_RENAME_ROLE") != null) {
                String roleIdStr2 = req.getParameter("ROLE_ID");
                if (roleIdStr2 == null) {
                    Properties langproperties = ImcmsPrefsLocalizedMessageProvider.getLanguageProperties(user);
                    String msg2 = langproperties.getProperty("error/servlet/AdminRoles/rolename_missing") + "<BR>";
                    LOG.debug((Object)"Error in rename roles, no role selected for rename");
                    AdminRoles.printErrorMessage(req, res, "Roles error", msg2);
                    return;
                }
                int roleId2 = Integer.parseInt(roleIdStr2);
                RoleDomainObject role2 = imcref.getImcmsAuthenticatorAndUserAndRoleMapper().getRoleById(roleId2);
                HashMap<String, String> vm = new HashMap<String, String>();
                vm.put("CURRENT_ROLE_ID", roleIdStr2);
                vm.put("CURRENT_ROLE_NAME", "" + role2.getName());
                AdminRoles.sendHtml(req, res, vm, HTML_RENAME_ROLE);
                return;
            }
            if (req.getParameter("VIEW_EDIT_ROLE") != null) {
                String roleIdStr3 = req.getParameter("ROLE_ID");
                if (roleIdStr3 == null) {
                    String header2 = "Error in AdminRoles, edit role";
                    Properties langproperties = ImcmsPrefsLocalizedMessageProvider.getLanguageProperties(user);
                    String msg3 = langproperties.getProperty("error/servlet/AdminRoles/role_missing") + "<br>";
                    LOG.debug((Object)(header2 + "- select the role to be changed"));
                    AdminRoles.printErrorMessage(req, res, header2, msg3);
                    return;
                }
                if (roleIdStr3.equals("0")) {
                    LOG.debug((Object)"Error in checking roles: Trying to look att superadmin permissions");
                    AdminRoles.printErrorMessage(req, res, "Error in AdminRoles, edit role", "<BR>");
                    return;
                }
                int roleId3 = Integer.parseInt(roleIdStr3);
                RoleDomainObject role3 = userAndRoleMapper.getRoleById(roleId3);
                RolePermissionDomainObject[] allRolePermissions = RoleDomainObject.getAllRolePermissions();
                String[][] permissionList = new String[allRolePermissions.length][];
                for (int i = 0; i < permissionList.length; ++i) {
                    RolePermissionDomainObject rolePermission = allRolePermissions[i];
                    int rolePermissionId = rolePermission.getId();
                    permissionList[i] = new String[3];
                    permissionList[i][0] = role3.hasPermission(rolePermission) ? "" + rolePermissionId : "0";
                    permissionList[i][1] = "" + rolePermissionId;
                    permissionList[i][2] = "" + rolePermission.getDescription().toLocalizedString(req);
                }
                String permissionComponent = this.createPermissionComponent(req, permissionList);
                HashMap<String, String> vm = new HashMap<String, String>();
                vm.put("CURRENT_ROLE_NAME", role3.getName());
                vm.put("CURRENT_ROLE_ID", roleIdStr3);
                vm.put("ROLE_PERMISSIONS", permissionComponent);
                AdminRoles.sendHtml(req, res, vm, HTML_EDIT_ROLE);
                return;
            }
            if (req.getParameter("ADD_NEW_ROLE") != null) {
                Properties params2 = this.getAddRoleParameters(req);
                if (params2.values().contains("")) {
                    String header3 = "Error in AdminRoles ";
                    Properties langproperties = ImcmsPrefsLocalizedMessageProvider.getLanguageProperties(user);
                    String msg4 = langproperties.getProperty("error/servlet/AdminRoles/new_rolename_missing") + "<br>";
                    LOG.debug((Object)(header3 + "- new rolename missing"));
                    AdminRoles.printErrorMessage(req, res, header3, msg4);
                    return;
                }
                String roleName = params2.getProperty("ROLE_NAME");
                if (this.roleExists(userAndRoleMapper, roleName)) {
                    String header4 = "Error in AdminRoles.";
                    Properties langproperties = ImcmsPrefsLocalizedMessageProvider.getLanguageProperties(user);
                    String msg5 = langproperties.getProperty("error/servlet/AdminRoles/rolename_already_exists") + "<br>";
                    LOG.debug((Object)(header4 + "- role name already exists"));
                    AdminRoles.printErrorMessage(req, res, header4, msg5);
                    return;
                }
                String[] checkedPermissions = req.getParameterValues("PERMISSION_CHECKBOX");
                int permissionValue = this.collectPermissionsState(checkedPermissions);
                RoleDomainObject role4 = new RoleDomainObject(roleName);
                role4.addUnionOfPermissionIdsToRole(permissionValue);
                try {
                    userAndRoleMapper.saveRole(role4);
                }
                catch (UserAndRoleRegistryException e) {
                    throw new UnhandledException((Throwable)e);
                }
                this.doGet(req, res);
                return;
            }
            if (req.getParameter("RENAME_ROLE") != null) {
                Properties params3 = this.getRenameRoleParameters(req);
                if (params3.values().contains("")) {
                    String header5 = "Error in AdminRoles, rename role ";
                    Properties langproperties = ImcmsPrefsLocalizedMessageProvider.getLanguageProperties(user);
                    String msg6 = langproperties.getProperty("error/servlet/AdminRoles/new_rolename_missing") + "<br>";
                    LOG.debug((Object)(header5 + "- new role name is missing"));
                    AdminRoles.printErrorMessage(req, res, header5, msg6);
                    return;
                }
                String roleName = params3.getProperty("ROLE_NAME");
                String roleIdStr4 = params3.getProperty("ROLE_ID");
                int roleId4 = Integer.parseInt(roleIdStr4);
                RoleDomainObject role5 = userAndRoleMapper.getRoleById(roleId4);
                role5.setName(roleName);
                try {
                    userAndRoleMapper.saveRole(role5);
                }
                catch (NameTooLongException e) {
                    throw new UnhandledException((Throwable)e);
                }
                catch (RoleAlreadyExistsException e) {
                    String header6 = "Error in AdminRoles.";
                    Properties langproperties = ImcmsPrefsLocalizedMessageProvider.getLanguageProperties(user);
                    String msg7 = langproperties.getProperty("error/servlet/AdminRoles/rolename_already_exists") + "<br>";
                    LOG.debug((Object)(header6 + "- rolename already exists"));
                    AdminRoles.printErrorMessage(req, res, header6, msg7);
                    return;
                }
                this.doGet(req, res);
                return;
            }
            boolean warnDelRole = false;
            if (req.getParameter("VIEW_DELETE_ROLE") != null) {
                List<UserDomainObject> affectedUsers;
                params = this.getDeleteRoleParameters(req);
                if (params.values().contains("")) {
                    String header7 = "Error in AdminRoles ";
                    Properties langproperties = ImcmsPrefsLocalizedMessageProvider.getLanguageProperties(user);
                    String msg8 = langproperties.getProperty("error/servlet/AdminRoles/role_to_delete_missing") + "<br>";
                    LOG.debug((Object)(header7 + "- no role was selected for delete"));
                    AdminRoles.printErrorMessage(req, res, header7, msg8);
                    return;
                }
                roleIdStr = params.getProperty("ROLE_ID");
                roleId = Integer.parseInt(roleIdStr);
                role = userAndRoleMapper.getRoleById(roleId);
                List affectedDocuments = imcref.getDocumentMapper().getDocumentsWithPermissionsForRole(role);
                int affectedDocumentsCount = affectedDocuments.size();
                if (affectedDocuments.size() > 50) {
                    affectedDocuments = affectedDocuments.subList(0, 50);
                }
                if ((affectedUsers = Arrays.asList(userAndRoleMapper.getAllUsersWithRole(role))).size() > 50) {
                    affectedUsers = affectedUsers.subList(0, 50);
                }
                if (!affectedUsers.isEmpty() || !affectedDocuments.isEmpty()) {
                    String opt = Html.createOptionList(affectedDocuments, new ToStringPairTransformer(){

                        public String[] transformToStringPair(Object input) {
                            DocumentDomainObject d = (DocumentDomainObject)input;
                            return new String[]{"" + d.getId(), "" + d.getId()};
                        }
                    });
                    String users = Html.createOptionList(affectedUsers, new ToStringPairTransformer(){

                        public String[] transformToStringPair(Object input) {
                            UserDomainObject user = (UserDomainObject)input;
                            return new String[]{"" + user.getId(), user.getLastName() + ", " + user.getFirstName() + " (" + user.getLoginName() + ")"};
                        }
                    });
                    HashMap<String, String> vm = new HashMap<String, String>();
                    vm.put("META_ID_LIST", opt);
                    vm.put("USER_ID_LIST", users);
                    vm.put("USER_COUNT", "" + affectedUsers.size());
                    vm.put("ROLE_COUNT", "" + affectedDocumentsCount);
                    vm.put("CURRENT_ROLE_ID", params.getProperty("ROLE_ID"));
                    AdminRoles.sendHtml(req, res, vm, HTML_DELETE_ROLE_1);
                    return;
                }
                warnDelRole = true;
            }
            if (req.getParameter("WARN_DELETE_ROLE") != null || warnDelRole) {
                params = this.getDeleteRoleParameters(req);
                if (params.values().contains("")) {
                    header = "Error in AdminRoles, delete ";
                    Properties langproperties = ImcmsPrefsLocalizedMessageProvider.getLanguageProperties(user);
                    msg = langproperties.getProperty("error/servlet/AdminRoles/role_to_delete_missing") + "<br>";
                    LOG.debug((Object)(header + "- no role was selected for delete"));
                    AdminRoles.printErrorMessage(req, res, header, msg);
                    return;
                }
                HashMap<String, String> vm = new HashMap<String, String>();
                vm.put("CURRENT_ROLE_ID", params.getProperty("ROLE_ID"));
                AdminRoles.sendHtml(req, res, vm, HTML_DELETE_ROLE_2);
                return;
            }
            if (req.getParameter("DELETE_ROLE") != null) {
                params = this.getDeleteRoleParameters(req);
                if (params.values().contains("")) {
                    header = "Error in AdminRoles, delete";
                    Properties langproperties = ImcmsPrefsLocalizedMessageProvider.getLanguageProperties(user);
                    msg = langproperties.getProperty("error/servlet/AdminRoles/role_to_delete_missing") + "<br>";
                    LOG.debug((Object)(header + "- no role was selected for delete"));
                    AdminRoles.printErrorMessage(req, res, header, msg);
                    return;
                }
                roleIdStr = params.getProperty("ROLE_ID");
                roleId = Integer.parseInt(roleIdStr);
                role = userAndRoleMapper.getRoleById(roleId);
                userAndRoleMapper.deleteRole(role);
                this.doGet(req, res);
                return;
            }
            if (req.getParameter("UPDATE_ROLE_PERMISSIONS") != null) {
                params = this.getEditRoleParameters(req);
                String[] checkedPermissions = req.getParameterValues("PERMISSION_CHECKBOX");
                if (params.values().contains("")) {
                    String header8 = "Error in AdminRoles ";
                    Properties langproperties = ImcmsPrefsLocalizedMessageProvider.getLanguageProperties(user);
                    String msg9 = langproperties.getProperty("error/servlet/AdminRoles/role_to_delete_missing") + "<br>";
                    LOG.debug((Object)(header8 + "- no role was selected for delete"));
                    AdminRoles.printErrorMessage(req, res, header8, msg9);
                    return;
                }
                int permissionValue = this.collectPermissionsState(checkedPermissions);
                Object[] parameters = new String[]{params.getProperty("ROLE_ID"), "" + permissionValue};
                imcref.getProcedureExecutor().executeUpdateProcedure("RoleUpdatePermissions", parameters);
                this.doGet(req, res);
            }
        }
    }

    private boolean roleExists(ImcmsAuthenticatorAndUserAndRoleMapper userAndRoleMapper, String roleName) {
        return null != userAndRoleMapper.getRoleByName(roleName);
    }

    private Properties getAddRoleParameters(HttpServletRequest req) {
        Properties roleInfoP = new Properties();
        String roleInfo = req.getParameter("ROLE_NAME") != null ? req.getParameter("ROLE_NAME") : "";
        roleInfoP.setProperty("ROLE_NAME", roleInfo);
        return roleInfoP;
    }

    private Properties getRenameRoleParameters(HttpServletRequest req) {
        Properties roleInfoP = new Properties();
        String roleId = req.getParameter("ROLE_ID") != null ? req.getParameter("ROLE_ID") : "";
        String roleInfo = req.getParameter("ROLE_NAME") != null ? req.getParameter("ROLE_NAME") : "";
        roleInfoP.setProperty("ROLE_ID", roleId);
        roleInfoP.setProperty("ROLE_NAME", roleInfo);
        return roleInfoP;
    }

    private Properties getDeleteRoleParameters(HttpServletRequest req) {
        Properties roleInfoP = new Properties();
        String roleInfo = req.getParameter("ROLE_ID") != null ? req.getParameter("ROLE_ID") : "";
        roleInfoP.setProperty("ROLE_ID", roleInfo);
        return roleInfoP;
    }

    private Properties getEditRoleParameters(HttpServletRequest req) {
        Properties roleInfoP = new Properties();
        String roleInfo = req.getParameter("ROLE_ID") == null ? "" : req.getParameter("ROLE_ID");
        roleInfoP.setProperty("ROLE_ID", roleInfo);
        return roleInfoP;
    }

    private String createPermissionComponent(HttpServletRequest req, String[][] permissionList) {
        StringBuffer permissionTableRows = new StringBuffer();
        for (String[] aPermissionList : permissionList) {
            String permissionId = aPermissionList[1];
            String description = aPermissionList[2];
            boolean isChecked = !aPermissionList[0].equals("0");
            HashMap<String, String> vm = new HashMap<String, String>();
            vm.put("PERMISSION_DESCRIPTION", description);
            vm.put("PERMISSON_ID", permissionId);
            if (isChecked) {
                vm.put("PERMISSION_CHECKED", "checked");
            } else {
                vm.put("PERMISSION_CHECKED", "");
            }
            String rowString = AdminRoles.createHtml(req, vm, HTML_EDIT_ROLE_TABLE_ROW);
            permissionTableRows.append(rowString);
        }
        HashMap<String, String> vmTable = new HashMap<String, String>();
        vmTable.put("PERMISSION_ROWS", permissionTableRows.toString());
        return AdminRoles.createHtml(req, vmTable, HTML_EDIT_ROLE_TABLE);
    }

    private int collectPermissionsState(String[] checkedPermissions) {
        int permissionValue = 0;
        if (checkedPermissions != null) {
            for (String checkedPermission : checkedPermissions) {
                int permissionId = 0;
                try {
                    permissionId = Integer.parseInt(checkedPermission);
                }
                catch (NumberFormatException e) {
                    LOG.debug((Object)"Error in checking roles: NumberFormatException");
                }
                permissionValue |= permissionId;
            }
        }
        return permissionValue;
    }

    public static void printErrorMessage(HttpServletRequest req, HttpServletResponse res, String header, String msg) throws IOException {
        ArrayList<String> tagsAndData = new ArrayList<String>();
        tagsAndData.add("#ERROR_HEADER#");
        tagsAndData.add(header);
        tagsAndData.add("#ERROR_MESSAGE#");
        tagsAndData.add(msg);
        String fileName = "AdminError.htm";
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        String html = imcref.getAdminTemplate(fileName, user, tagsAndData);
        Utility.setDefaultHtmlContentType(res);
        res.getWriter().println(html);
    }

    static String createHtml(HttpServletRequest req, Map vm, String htmlFile) {
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        vm.put("SERVLET_URL", "");
        vm.put("SERVLET_URL2", "");
        ArrayList<String> tagsAndData1 = new ArrayList<String>(vm.size() * 2);
        for (Map.Entry entry : vm.entrySet()) {
            tagsAndData1.add("#" + (String)entry.getKey() + "#");
            tagsAndData1.add((String)entry.getValue());
        }
        return imcref.getAdminTemplate(htmlFile, user, tagsAndData1);
    }

    public static void sendHtml(HttpServletRequest req, HttpServletResponse res, Map vm, String htmlFile) throws IOException {
        String str = AdminRoles.createHtml(req, vm, htmlFile);
        Utility.setDefaultHtmlContentType(res);
        PrintWriter out = res.getWriter();
        out.println(str);
    }
}

