/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.superadmin;

import com.imcode.db.handlers.ObjectFromFirstRowResultSetHandler;
import com.imcode.db.handlers.ObjectFromRowFactory;
import com.imcode.imcms.db.StringFromRowFactory;
import com.imcode.imcms.mapping.DocumentMapper;
import com.imcode.imcms.servlet.superadmin.AdminIpAccess;
import com.imcode.imcms.servlet.superadmin.AdminRoles;
import com.imcode.imcms.util.l10n.ImcmsPrefsLocalizedMessageProvider;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.log4j.Logger;

public class AdminDeleteDoc
extends HttpServlet {
    private static final Logger log = Logger.getLogger((String)AdminDeleteDoc.class.getName());
    private static final String HTML_TEMPLATE = "AdminDeleteDoc.htm";

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!user.isSuperAdmin()) {
            AdminIpAccess.printNonAdminError(imcref, user, req, res, ((Object)((Object)this)).getClass());
        } else {
            HashMap vm = new HashMap();
            AdminRoles.sendHtml(req, res, vm, HTML_TEMPLATE);
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!user.isSuperAdmin()) {
            AdminIpAccess.printNonAdminError(imcref, user, req, res, ((Object)((Object)this)).getClass());
        } else if (req.getParameter("DELETE_DOC") != null) {
            Properties params = this.getParameters(req);
            if (!this.validateParameters(params)) {
                String header = "Error in AdminDeleteDoc.";
                Properties langproperties = ImcmsPrefsLocalizedMessageProvider.getLanguageProperties(user);
                String msg = langproperties.getProperty("error/servlet/AdminDeleteDoc/no_valid_metaid") + "<br>";
                log.debug((Object)(header + "- no valid metaid"));
                AdminRoles.printErrorMessage(req, res, header, msg);
                return;
            }
            int metaId = Integer.parseInt(params.getProperty("DEL_META_ID"));
            Object[] parameters = new String[]{"" + metaId};
            String foundMetaId = (String)imcref.getProcedureExecutor().executeProcedure("FindMetaId", parameters, (ResultSetHandler)new ObjectFromFirstRowResultSetHandler((ObjectFromRowFactory)new StringFromRowFactory()));
            log.debug((Object)("FoundMetaId: " + foundMetaId));
            if (foundMetaId == null) {
                String header = "Error in AdminDeleteDoc. ";
                Properties langproperties = ImcmsPrefsLocalizedMessageProvider.getLanguageProperties(user);
                String msg = langproperties.getProperty("error/servlet/AdminDeleteDoc/no_metaid_in_db") + "( " + metaId + " ) <br>";
                log.debug((Object)(header + "- metaid could not be found in db"));
                AdminRoles.printErrorMessage(req, res, header, msg);
                return;
            }
            DocumentMapper documentMapper = imcref.getDocumentMapper();
            DocumentDomainObject document = documentMapper.getPublishedDocument(metaId);
            documentMapper.deleteDocument(document, user);
            imcref.updateMainLog("Document  [" + document.getId() + "] ALL deleted by user: [" + user.getFullName() + "]");
            this.doGet(req, res);
        } else if (req.getParameter("GO_BACK") != null) {
            String url = "AdminManager";
            res.sendRedirect(url);
        } else {
            log.debug((Object)"Unidentified argument was sent!");
            this.doGet(req, res);
        }
    }

    private Properties getParameters(HttpServletRequest req) {
        Properties params = new Properties();
        String del_meta_id = req.getParameter("delete_meta_id") == null ? "" : req.getParameter("delete_meta_id");
        params.setProperty("DEL_META_ID", del_meta_id);
        return params;
    }

    private boolean validateParameters(Properties params) {
        if (params.values().contains("")) {
            return false;
        }
        try {
            Integer.parseInt(params.getProperty("DEL_META_ID"));
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }
}

