/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.admin;

import com.imcode.imcms.flow.DispatchCommand;
import com.imcode.imcms.flow.EditDocumentInformationPageFlow;
import com.imcode.imcms.flow.OkCancelPage;
import com.imcode.imcms.mapping.DocumentMapper;
import com.imcode.imcms.servlet.admin.Handler;
import com.imcode.imcms.servlet.admin.ImageBrowser;
import com.imcode.imcms.util.l10n.LocalizedMessage;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.TextDocumentPermissionSetDomainObject;
import imcode.server.document.textdocument.ImageDomainObject;
import imcode.server.document.textdocument.ImageSource;
import imcode.server.document.textdocument.ImagesPathRelativePathImageSource;
import imcode.server.document.textdocument.NullImageSource;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.ImcmsImageUtils;
import imcode.util.Utility;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageEditPage
extends OkCancelPage {
    public static final String REQUEST_PARAMETER__GO_TO_IMAGE_BROWSER_BUTTON = "goToImageBrowser";
    public static final String REQUEST_PARAMETER__PREVIEW_BUTTON = "show_img";
    public static final String REQUEST_PARAMETER__CANCEL_BUTTON = "cancel";
    public static final String REQUEST_PARAMETER__DELETE_BUTTON = "delete";
    public static final String REQUEST_PARAMETER__DOCUMENT_ID = "documentId";
    public static final String REQUEST_PARAMETER__IMAGE_URL = "imageref";
    public static final String REQUEST_PARAMETER__OK_BUTTON = "ok";
    public static final String REQUEST_PARAMETER__IMAGE_HEIGHT = "image_height";
    public static final String REQUEST_PARAMETER__IMAGE_WIDTH = "image_width";
    public static final String REQUEST_PARAMETER__IMAGE_BORDER = "image_border";
    public static final String REQUEST_PARAMETER__VERTICAL_SPACE = "v_space";
    public static final String REQUEST_PARAMETER__HORIZONTAL_SPACE = "h_space";
    public static final String REQUEST_PARAMETER__IMAGE_NAME = "image_name";
    public static final String REQUEST_PARAMETER__IMAGE_ALIGN = "image_align";
    public static final String REQUEST_PARAMETER__IMAGE_ALT = "alt_text";
    public static final String REQUEST_PARAMETER__IMAGE_LOWSRC = "low_scr";
    public static final String REQUEST_PARAMETER__LINK_URL = "imageref_link";
    public static final String REQUEST_PARAMETER__LINK_TARGET = "target";
    public static final String REQUEST_PARAMETER__I18N_CODE = "i18nCode";
    static final LocalizedMessage ERROR_MESSAGE__ONLY_ALLOWED_TO_UPLOAD_IMAGES = new LocalizedMessage("error/servlet/images/only_allowed_to_upload_images");
    public static final String REQUEST_PARAMETER__SHARE_IMAGE = "share_image";
    private TextDocumentDomainObject document;
    private String label;
    private final Handler<List<ImageDomainObject>> imageCommand;
    private final LocalizedMessage heading;
    private boolean linkable;
    private boolean shareImages;
    private ImageDomainObject image;
    private List<ImageDomainObject> images = new LinkedList<ImageDomainObject>();

    public ImageEditPage(TextDocumentDomainObject document, ImageDomainObject image, LocalizedMessage heading, String label, ServletContext servletContext, Handler<List<ImageDomainObject>> imageCommand, DispatchCommand returnCommand, boolean linkable) {
        super(returnCommand, returnCommand);
        this.document = document;
        this.image = image;
        this.label = label;
        this.imageCommand = imageCommand;
        this.heading = heading;
        this.linkable = linkable;
    }

    public ImageDomainObject getImage() {
        return this.image;
    }

    @Override
    public String getPath(HttpServletRequest request) {
        UserDomainObject user = Utility.getLoggedOnUser(request);
        return "/imcms/" + user.getLanguageIso639_2() + "/jsp/change_img.jsp";
    }

    @Override
    protected void updateFromRequest(HttpServletRequest request) {
        this.image = this.getImageFromRequest(request);
    }

    public String getLabel() {
        return this.label;
    }

    private ImageDomainObject getImageFromRequest(HttpServletRequest req) {
        String imageUrl;
        ImageDomainObject image = new ImageDomainObject();
        try {
            image.setWidth(Integer.parseInt(req.getParameter(REQUEST_PARAMETER__IMAGE_WIDTH)));
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        try {
            image.setHeight(Integer.parseInt(req.getParameter(REQUEST_PARAMETER__IMAGE_HEIGHT)));
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        try {
            image.setBorder(Integer.parseInt(req.getParameter(REQUEST_PARAMETER__IMAGE_BORDER)));
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        try {
            image.setVerticalSpace(Integer.parseInt(req.getParameter(REQUEST_PARAMETER__VERTICAL_SPACE)));
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        try {
            image.setHorizontalSpace(Integer.parseInt(req.getParameter(REQUEST_PARAMETER__HORIZONTAL_SPACE)));
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        image.setName(StringUtils.trim((String)req.getParameter(REQUEST_PARAMETER__IMAGE_NAME)));
        image.setAlign(req.getParameter(REQUEST_PARAMETER__IMAGE_ALIGN));
        if (this.isLinkable()) {
            image.setTarget(EditDocumentInformationPageFlow.getTargetFromRequest(req, REQUEST_PARAMETER__LINK_TARGET));
            image.setLinkUrl(req.getParameter(REQUEST_PARAMETER__LINK_URL));
        }
        if (null != (imageUrl = req.getParameter(REQUEST_PARAMETER__IMAGE_URL)) && imageUrl.startsWith(req.getContextPath())) {
            imageUrl = imageUrl.substring(req.getContextPath().length());
        }
        ImageSource imageSource = ImcmsImageUtils.createImageSourceFromString(imageUrl);
        image.setSource(imageSource);
        image.setAlternateText(req.getParameter(REQUEST_PARAMETER__IMAGE_ALT));
        image.setLowResolutionUrl(req.getParameter(REQUEST_PARAMETER__IMAGE_LOWSRC));
        this.shareImages = req.getParameter(REQUEST_PARAMETER__SHARE_IMAGE) != null;
        int index = 0;
        ImageDomainObject firstImage = this.images.get(0);
        for (ImageDomainObject i18nImage : this.images) {
            String suffix = "_" + i18nImage.getLanguage().getCode();
            String alternateText = req.getParameter(REQUEST_PARAMETER__IMAGE_ALT + suffix);
            if (this.shareImages && index++ > 0) {
                imageSource = firstImage.getSource();
            } else {
                imageUrl = req.getParameter(REQUEST_PARAMETER__IMAGE_URL + suffix);
                if (null != imageUrl && imageUrl.startsWith(req.getContextPath())) {
                    imageUrl = imageUrl.substring(req.getContextPath().length());
                }
                imageSource = ImcmsImageUtils.createImageSourceFromString(imageUrl);
            }
            i18nImage.setImageUrl(imageUrl);
            i18nImage.setType(imageSource.getTypeId());
            i18nImage.setAlternateText(alternateText);
            i18nImage.setSource(imageSource);
            i18nImage.setWidth(image.getWidth());
            i18nImage.setHeight(image.getHeight());
            i18nImage.setBorder(image.getBorder());
            i18nImage.setVerticalSpace(image.getVerticalSpace());
            i18nImage.setHorizontalSpace(image.getHorizontalSpace());
            i18nImage.setName(image.getName());
            i18nImage.setAlign(image.getAlign());
            if (!this.isLinkable()) continue;
            i18nImage.setTarget(image.getTarget());
            i18nImage.setLinkUrl(image.getLinkUrl());
        }
        return image;
    }

    @Override
    protected void dispatchOther(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        UserDomainObject user = Utility.getLoggedOnUser(request);
        ImcmsServices imcref = Imcms.getServices();
        DocumentMapper documentMapper = imcref.getDocumentMapper();
        if (null != request.getParameter(REQUEST_PARAMETER__DELETE_BUTTON)) {
            NullImageSource source = new NullImageSource();
            for (ImageDomainObject image : this.images) {
                image.setSourceAndClearSize(source);
                image.setAlternateText(null);
            }
            this.image = this.images.get(0);
            this.forward(request, response);
        } else if (null != request.getParameter(REQUEST_PARAMETER__PREVIEW_BUTTON)) {
            this.forward(request, response);
        } else if (null != request.getParameter(REQUEST_PARAMETER__GO_TO_IMAGE_BROWSER_BUTTON)) {
            this.goToImageBrowser(request, response);
        }
    }

    private void goToImageBrowser(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        final String i18nCode = request.getParameter(REQUEST_PARAMETER__I18N_CODE);
        if (i18nCode == null) {
            throw new RuntimeException("Language code is not set.");
        }
        ImageBrowser imageBrowser = new ImageBrowser();
        imageBrowser.setCancelCommand(new DispatchCommand(){

            public void dispatch(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                ImageEditPage.this.forward(request, response);
            }
        });
        imageBrowser.setSelectImageUrlCommand(new ImageBrowser.SelectImageUrlCommand(){

            public void selectImageUrl(String imageUrl, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                int width = ImageEditPage.this.image.getWidth();
                int height = ImageEditPage.this.image.getHeight();
                for (ImageDomainObject i18nImage : ImageEditPage.this.images) {
                    if (ImageEditPage.this.shareImages || i18nImage.getLanguage().getCode().equals(i18nCode)) {
                        i18nImage.setSource(new ImagesPathRelativePathImageSource(imageUrl));
                    }
                    i18nImage.setHeight(height);
                    i18nImage.setWidth(width);
                }
                ImageEditPage.this.forward(request, response);
            }
        });
        imageBrowser.forward(request, response);
    }

    static boolean userHasImagePermissionsOnDocument(UserDomainObject user, TextDocumentDomainObject document) {
        TextDocumentPermissionSetDomainObject textDocumentPermissionSet = (TextDocumentPermissionSetDomainObject)user.getPermissionSetFor(document);
        return textDocumentPermissionSet.getEditImages();
    }

    public static ImageEditPage getFromRequest(HttpServletRequest request) {
        return (ImageEditPage)ImageEditPage.fromRequest(request);
    }

    public LocalizedMessage getHeading() {
        return this.heading;
    }

    public boolean canAddImageFiles(UserDomainObject user) {
        return user.canCreateDocumentOfTypeIdFromParent(8, this.document);
    }

    public boolean isLinkable() {
        return this.linkable;
    }

    @Override
    protected void dispatchOk(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.imageCommand.handle(this.images);
        super.dispatchOk(request, response);
    }

    public List<ImageDomainObject> getImages() {
        return this.images;
    }

    public void setImages(List<ImageDomainObject> images) {
        boolean mayShareImages;
        this.images = images;
        boolean bl = mayShareImages = images != null && images.size() > 1;
        if (mayShareImages) {
            Iterator<ImageDomainObject> iterator = images.iterator();
            ImageDomainObject image = iterator.next();
            ImageSource source = image.getSource();
            while (iterator.hasNext()) {
                image = iterator.next();
                ImageSource otherSource = image.getSource();
                if (source.getTypeId() == otherSource.getTypeId() && source.getUrlPathRelativeToContextPath().equals(otherSource.getUrlPathRelativeToContextPath())) continue;
                mayShareImages = false;
                break;
            }
        }
        this.shareImages = mayShareImages;
    }

    public boolean getImagesSharesSameSource() {
        boolean same = this.images.size() > 0;
        String path = null;
        for (ImageDomainObject image : this.images) {
            ImageSource source = image.getSource();
            String newPath = source.getUrlPathRelativeToContextPath();
            if (image.getSource() instanceof NullImageSource) {
                same = false;
                break;
            }
            if (path != null && !path.equals(newPath)) {
                same = false;
                break;
            }
            path = newPath;
        }
        return same;
    }

    public boolean isShareImages() {
        return this.shareImages;
    }

    public void setShareImages(boolean shareImages) {
        this.shareImages = shareImages;
    }
}

