/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.admin;

import com.imcode.imcms.api.DocumentVersionSelector;
import com.imcode.imcms.flow.DispatchCommand;
import com.imcode.imcms.flow.DocumentPageFlow;
import com.imcode.imcms.flow.EditDocumentInformationPageFlow;
import com.imcode.imcms.flow.EditDocumentPermissionsPageFlow;
import com.imcode.imcms.flow.EditFileDocumentPageFlow;
import com.imcode.imcms.flow.EditHtmlDocumentPageFlow;
import com.imcode.imcms.flow.EditUrlDocumentPageFlow;
import com.imcode.imcms.flow.PageFlow;
import com.imcode.imcms.flow.PublishDocumentPageFlow;
import com.imcode.imcms.mapping.DocumentMapper;
import com.imcode.imcms.servlet.GetDoc;
import imcode.server.DocumentRequest;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.FileDocumentDomainObject;
import imcode.server.document.HtmlDocumentDomainObject;
import imcode.server.document.UrlDocumentDomainObject;
import imcode.server.parser.ParserParameters;
import imcode.server.user.UserDomainObject;
import imcode.util.Html;
import imcode.util.Utility;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Stack;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.ObjectUtils;

public class AdminDoc
extends HttpServlet {
    private static final String PARAMETER__META_ID = "meta_id";
    public static final String PARAMETER__DISPATCH_FLAGS = "flags";

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        PageFlow pageFlow;
        int metaId = Integer.parseInt(req.getParameter(PARAMETER__META_ID));
        int flags = Integer.parseInt((String)ObjectUtils.defaultIfNull((Object)req.getParameter(PARAMETER__DISPATCH_FLAGS), (Object)"0"));
        DocumentMapper documentMapper = Imcms.getServices().getDocumentMapper();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        DocumentVersionSelector versionSelector = user.getDocumentShowSettings().getVersionSelector();
        DocumentDomainObject document = documentMapper.getDocument((Integer)metaId, versionSelector);
        if (!user.canEdit(document)) {
            flags = 0;
        }
        if (null != (pageFlow = this.createFlow(document, flags, user)) && user.canEdit(document)) {
            pageFlow.dispatch(req, res);
        } else {
            Utility.setDefaultHtmlContentType(res);
            int meta_id = Integer.parseInt(req.getParameter(PARAMETER__META_ID));
            AdminDoc.adminDoc(meta_id, user, req, res, this.getServletContext());
        }
    }

    private PageFlow createFlow(DocumentDomainObject document, int flags, UserDomainObject user) {
        RedirectToDocumentCommand returnCommand = new RedirectToDocumentCommand(document);
        DocumentMapper.SaveEditedDocumentCommand saveDocumentCommand = new DocumentMapper.SaveEditedDocumentCommand();
        DocumentPageFlow pageFlow = null;
        if (1 == flags && user.canEditDocumentInformationFor(document)) {
            pageFlow = new EditDocumentInformationPageFlow(document, returnCommand, saveDocumentCommand);
        } else if (4 == flags && user.canEditPermissionsFor(document)) {
            pageFlow = new EditDocumentPermissionsPageFlow(document, returnCommand, saveDocumentCommand);
        } else if (document instanceof HtmlDocumentDomainObject && 65536 == flags) {
            pageFlow = new EditHtmlDocumentPageFlow((HtmlDocumentDomainObject)document, (DispatchCommand)returnCommand, (DocumentPageFlow.SaveDocumentCommand)saveDocumentCommand);
        } else if (document instanceof UrlDocumentDomainObject && 65536 == flags) {
            pageFlow = new EditUrlDocumentPageFlow((UrlDocumentDomainObject)document, (DispatchCommand)returnCommand, (DocumentPageFlow.SaveDocumentCommand)saveDocumentCommand);
        } else if (document instanceof FileDocumentDomainObject && 65536 == flags) {
            pageFlow = new EditFileDocumentPageFlow((FileDocumentDomainObject)document, this.getServletContext(), returnCommand, saveDocumentCommand, null);
        } else if (0x400000 == flags) {
            pageFlow = new PublishDocumentPageFlow(document, returnCommand, new DocumentMapper.PublushDocumentCommand(), user);
        }
        return pageFlow;
    }

    public static void adminDoc(int meta_id, UserDomainObject user, HttpServletRequest req, HttpServletResponse res, ServletContext servletContext) throws IOException, ServletException {
        int flags;
        DocumentDomainObject document;
        ImcmsServices imcref;
        block7: {
            imcref = Imcms.getServices();
            HttpSession session = req.getSession();
            Stack<Integer> history = (Stack<Integer>)session.getAttribute("history");
            if (history == null) {
                history = new Stack<Integer>();
                session.setAttribute("history", history);
            }
            Integer meta_int = new Integer(meta_id);
            if (history.empty() || !history.peek().equals(meta_int)) {
                history.push(meta_int);
            }
            if ((document = imcref.getDocumentMapper().getDocumentForShowing(meta_id, user)) == null) {
                document = imcref.getDocumentMapper().getLatestDocumentVersionForShowing(meta_id, user);
            }
            if (null == document) {
                res.sendError(404);
                return;
            }
            int doc_type = document.getDocumentTypeId();
            Integer userflags = (Integer)session.getAttribute(PARAMETER__DISPATCH_FLAGS);
            session.removeAttribute(PARAMETER__DISPATCH_FLAGS);
            flags = userflags == null ? 0 : userflags;
            try {
                flags = Integer.parseInt(req.getParameter(PARAMETER__DISPATCH_FLAGS));
            }
            catch (NumberFormatException ex) {
                if (flags != 0 || doc_type == 1 || doc_type == 2) break block7;
                ArrayList<String> vec = new ArrayList<String>(4);
                vec.add("#adminMode#");
                vec.add(Html.getAdminButtons(user, document, req, res));
                vec.add("#doc_type_description#");
                vec.add(imcref.getAdminTemplate("adminbuttons/adminbuttons" + doc_type + "_description.html", user, null));
                Utility.setDefaultHtmlContentType(res);
                res.getWriter().write(imcref.getAdminTemplate("docinfo.html", user, vec));
                return;
            }
        }
        if (!user.canEdit(document)) {
            GetDoc.viewDoc("" + meta_id, req, res);
            return;
        }
        DocumentRequest documentRequest = new DocumentRequest(imcref, user, document, null, req, res);
        ParserParameters parserParameters = new ParserParameters(documentRequest);
        parserParameters.setFlags(flags);
        imcref.parsePage(parserParameters, res.getWriter());
    }

    private static class RedirectToDocumentCommand
    implements DispatchCommand {
        private final DocumentDomainObject document;

        RedirectToDocumentCommand(DocumentDomainObject document) {
            this.document = document;
        }

        public void dispatch(HttpServletRequest request, HttpServletResponse response) throws IOException {
            response.sendRedirect("AdminDoc?meta_id=" + this.document.getId());
        }
    }
}

