/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet;

import imcode.server.Imcms;
import imcode.util.Prefs;
import java.io.File;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ContextListener
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        ServletContext servletContext = servletContextEvent.getServletContext();
        File realPathToWebApp = new File(servletContext.getRealPath("/"));
        File configPath = new File(realPathToWebApp, "WEB-INF/conf");
        Prefs.setConfigPath(configPath);
        System.setProperty("com.imcode.imcms.path", realPathToWebApp.toString());
        Logger log = Logger.getLogger(ContextListener.class);
        log.info((Object)"Logging started");
        this.logPlatformInfo(servletContext, log);
        try {
            Imcms.setPath(realPathToWebApp);
            log.info((Object)"imCMS initialized.");
        }
        catch (RuntimeException e) {
            log.fatal((Object)"Failed to initialize imCMS.", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        Logger log = Logger.getLogger(ContextListener.class);
        log.debug((Object)"Stopping imCMS.");
        try {
            Imcms.stop();
        }
        catch (Exception e) {
            log.error((Object)"Stopping imCMS failed.", (Throwable)e);
        }
        log.debug((Object)"Shutting down logging.");
        try {
            LogManager.shutdown();
        }
        catch (Exception e) {
            System.err.println(e);
        }
        try {
            LogFactory.releaseAll();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    private void logPlatformInfo(ServletContext application, Logger log) {
        log.info((Object)("Servlet Engine: " + application.getServerInfo()));
        String[] systemPropertyNames = new String[]{"java.version", "java.vendor", "java.class.path", "os.name", "os.arch", "os.version"};
        for (int i = 0; i < systemPropertyNames.length; ++i) {
            String systemPropertyName = systemPropertyNames[i];
            log.info((Object)(systemPropertyName + ": " + System.getProperty(systemPropertyName)));
        }
    }
}

