/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.mapping.aop;

import com.imcode.imcms.mapping.DocumentInitializingVisitor;
import imcode.server.document.UrlDocumentDomainObject;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;

@Aspect
public class UrlDocumentLazyLoadingAspect {
    private boolean loaded;
    private DocumentInitializingVisitor documentInitializingVisitor;

    public UrlDocumentLazyLoadingAspect(DocumentInitializingVisitor documentInitializingVisitor) {
        this.documentInitializingVisitor = documentInitializingVisitor;
    }

    @Before(value="(execution(* *Url*(..)) || execution(* clone())) && target(document)")
    public void load(UrlDocumentDomainObject document) {
        if (!this.loaded) {
            this.documentInitializingVisitor.visitUrlDocument(document);
            this.loaded = true;
        }
    }
}

